% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R, R/AllMethods.R
\docType{class}
\name{H5Ref-class}
\alias{H5Ref-class}
\alias{show,H5Ref-method}
\alias{length,H5Ref-method}
\alias{c,H5Ref-method}
\alias{[,H5Ref-method}
\title{An S4 class representing H5 references.}
\usage{
\S4method{show}{H5Ref}(object)

\S4method{length}{H5Ref}(x)

\S4method{c}{H5Ref}(x, ...)

\S4method{[}{H5Ref}(x, i)
}
\arguments{
\item{object}{Object of class \code{H5Ref}}

\item{x}{An \code{H5Ref} object.}

\item{...}{Additional \code{H5Ref} objects to be combined with \code{x}.}

\item{i}{Integer vector giving the indices of references to select.}
}
\description{
A class representing one or more HDF5 references.
}
\details{
The length of the \code{val} slot is dependent on both the number and type of
references stored in the object. \code{H5R_OBJECT} references are stored in 8
bytes, while \code{H5R_DATASET_REGION} references require 12 bytes.  The length
of \code{val} will then be a multiple of 8 or 12 respectively.  This also means
that references of different types cannot be combined in a single object.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Print details of the object to screen.

\item \code{length}: Return the number of references stored in an \code{H5Ref}
object.

\item \code{c}: Combine two or more \code{H5Ref} objects.  Objects must all
contain the same type of reference, either \code{H5R_OBJECT} or
\code{H5R_DATASET_REFERENCE}.

\item \code{[}: Subset an \code{H5Ref} object.
}}

\section{Slots}{

\describe{
\item{\code{val}}{\code{raw} vector containing the byte-level representation of each
reference.}

\item{\code{type}}{\code{integer} of length 1, which maps to either \code{H5R_OBJECT} or
\code{H5R_DATASET_REGION}.}
}}

