# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`unbound`](#unbound): Class: unbound  Installs and configures Unbound, the caching DNS resolver from NLnet Labs
* [`unbound::remote`](#unboundremote): Class: unbound::remote  Configure remote control of the unbound daemon process  === Parameters:  [*enable*]   (optional) The option is used t

### Defined types

* [`unbound::forward`](#unboundforward): Class: unbound::forward  Configures a zone for DNS forwarding  == Parameters:  [*zone*]   (required) the name of the zone.  [*address*]   IP 
* [`unbound::localzone`](#unboundlocalzone): Class: unbound::localzone  Configures a local zone. The  default  zones  are  localhost, reverse 127.0.0.1 and ::1, and the AS112 zones. The 
* [`unbound::record`](#unboundrecord): Class: unbound::record  Create an unbound static DNS record override  == Parameters:  [*content*]   (required) The name of the record (ip add
* [`unbound::stub`](#unboundstub): Class: unbound::stub  Create an unbound stub zone for caching upstream name resolvers  === Parameters:  [*address*]   (required) IP address o

### Data types

* [`Unbound::Access_control`](#unboundaccess_control)
* [`Unbound::Address`](#unboundaddress): Patterns copied from Stdlib::IP
* [`Unbound::Chroot`](#unboundchroot)
* [`Unbound::Hints_file`](#unboundhints_file)
* [`Unbound::Local_zone`](#unboundlocal_zone): custom enum type for local-zone types
* [`Unbound::Local_zone_override`](#unboundlocal_zone_override)
* [`Unbound::Local_zone_type`](#unboundlocal_zone_type): custom enum type for local-zone types
* [`Unbound::Module`](#unboundmodule)
* [`Unbound::Range`](#unboundrange)
* [`Unbound::Resource_record_type`](#unboundresource_record_type): custom type for resource record used for local-data
* [`Unbound::Size`](#unboundsize)

## Classes

### <a name="unbound"></a>`unbound`

Class: unbound

Installs and configures Unbound, the caching DNS resolver from NLnet Labs

#### Parameters

The following parameters are available in the `unbound` class:

* [`hints_file`](#hints_file)
* [`hints_file_content`](#hints_file_content)
* [`manage_service`](#manage_service)
* [`verbosity`](#verbosity)
* [`statistics_interval`](#statistics_interval)
* [`statistics_cumulative`](#statistics_cumulative)
* [`extended_statistics`](#extended_statistics)
* [`num_threads`](#num_threads)
* [`port`](#port)
* [`interface`](#interface)
* [`interface_automatic`](#interface_automatic)
* [`outgoing_interface`](#outgoing_interface)
* [`outgoing_range`](#outgoing_range)
* [`outgoing_port_permit`](#outgoing_port_permit)
* [`outgoing_port_avoid`](#outgoing_port_avoid)
* [`outgoing_port_permit_first`](#outgoing_port_permit_first)
* [`outgoing_num_tcp`](#outgoing_num_tcp)
* [`incoming_num_tcp`](#incoming_num_tcp)
* [`edns_buffer_size`](#edns_buffer_size)
* [`max_udp_size`](#max_udp_size)
* [`stream_wait_size`](#stream_wait_size)
* [`msg_cache_size`](#msg_cache_size)
* [`msg_cache_slabs`](#msg_cache_slabs)
* [`num_queries_per_thread`](#num_queries_per_thread)
* [`jostle_timeout`](#jostle_timeout)
* [`delay_close`](#delay_close)
* [`unknown_server_time_limit`](#unknown_server_time_limit)
* [`so_rcvbuf`](#so_rcvbuf)
* [`so_sndbuf`](#so_sndbuf)
* [`so_reuseport`](#so_reuseport)
* [`ip_transparent`](#ip_transparent)
* [`ip_freebind`](#ip_freebind)
* [`rrset_cache_size`](#rrset_cache_size)
* [`rrset_cache_slabs`](#rrset_cache_slabs)
* [`cache_max_ttl`](#cache_max_ttl)
* [`cache_max_negative_ttl`](#cache_max_negative_ttl)
* [`cache_min_ttl`](#cache_min_ttl)
* [`infra_host_ttl`](#infra_host_ttl)
* [`infra_cache_numhosts`](#infra_cache_numhosts)
* [`infra_cache_slabs`](#infra_cache_slabs)
* [`infra_cache_min_rtt`](#infra_cache_min_rtt)
* [`define_tag`](#define_tag)
* [`do_ip4`](#do_ip4)
* [`do_ip6`](#do_ip6)
* [`prefer_ip6`](#prefer_ip6)
* [`do_udp`](#do_udp)
* [`do_tcp`](#do_tcp)
* [`tcp_mss`](#tcp_mss)
* [`tls_cert_bundle`](#tls_cert_bundle)
* [`tls_upstream`](#tls_upstream)
* [`outgoing_tcp_mss`](#outgoing_tcp_mss)
* [`tcp_idle_timeout`](#tcp_idle_timeout)
* [`edns_tcp_keepalive`](#edns_tcp_keepalive)
* [`edns_tcp_keepalive_timeout`](#edns_tcp_keepalive_timeout)
* [`tcp_upstream`](#tcp_upstream)
* [`udp_upstream_without_downstream`](#udp_upstream_without_downstream)
* [`ssl_upstream`](#ssl_upstream)
* [`ssl_service_key`](#ssl_service_key)
* [`ssl_service_pem`](#ssl_service_pem)
* [`ssl_port`](#ssl_port)
* [`tls_ciphers`](#tls_ciphers)
* [`tls_ciphersuites`](#tls_ciphersuites)
* [`use_systemd`](#use_systemd)
* [`do_daemonize`](#do_daemonize)
* [`access_control`](#access_control)
* [`chroot`](#chroot)
* [`logfile`](#logfile)
* [`log_identity`](#log_identity)
* [`log_time_ascii`](#log_time_ascii)
* [`log_queries`](#log_queries)
* [`log_replies`](#log_replies)
* [`log_tag_queryreply`](#log_tag_queryreply)
* [`log_local_actions`](#log_local_actions)
* [`log_servfail`](#log_servfail)
* [`pidfile`](#pidfile)
* [`hide_identity`](#hide_identity)
* [`identity`](#identity)
* [`hide_version`](#hide_version)
* [`version`](#version)
* [`hide_trustanchor`](#hide_trustanchor)
* [`target_fetch_policy`](#target_fetch_policy)
* [`harden_short_bufsize`](#harden_short_bufsize)
* [`harden_large_queries`](#harden_large_queries)
* [`harden_glue`](#harden_glue)
* [`harden_dnssec_stripped`](#harden_dnssec_stripped)
* [`harden_below_nxdomain`](#harden_below_nxdomain)
* [`harden_referral_path`](#harden_referral_path)
* [`harden_algo_downgrade`](#harden_algo_downgrade)
* [`use_caps_for_id`](#use_caps_for_id)
* [`caps_whitlist`](#caps_whitlist)
* [`qname_minimisation`](#qname_minimisation)
* [`qname_minimisation_strict`](#qname_minimisation_strict)
* [`private_address`](#private_address)
* [`private_domain`](#private_domain)
* [`unwanted_reply_threshold`](#unwanted_reply_threshold)
* [`do_not_query_address`](#do_not_query_address)
* [`do_not_query_localhost`](#do_not_query_localhost)
* [`prefetch`](#prefetch)
* [`prefetch_key`](#prefetch_key)
* [`deny_any`](#deny_any)
* [`rrset_roundrobin`](#rrset_roundrobin)
* [`minimal_responses`](#minimal_responses)
* [`disable_dnssec_lame_check`](#disable_dnssec_lame_check)
* [`trust_anchor_file`](#trust_anchor_file)
* [`trust_anchor`](#trust_anchor)
* [`trust_anchor_signaling`](#trust_anchor_signaling)
* [`domain_insecure`](#domain_insecure)
* [`val_sig_skew_min`](#val_sig_skew_min)
* [`val_sig_skew_max`](#val_sig_skew_max)
* [`val_bogus_ttl`](#val_bogus_ttl)
* [`val_clean_additional`](#val_clean_additional)
* [`val_log_level`](#val_log_level)
* [`val_permissive_mode`](#val_permissive_mode)
* [`ignore_cd_flag`](#ignore_cd_flag)
* [`serve_expired`](#serve_expired)
* [`serve_expired_ttl`](#serve_expired_ttl)
* [`serve_expired_ttl_reset`](#serve_expired_ttl_reset)
* [`serve_expired_reply_ttl`](#serve_expired_reply_ttl)
* [`serve_expired_client_timeout`](#serve_expired_client_timeout)
* [`val_nsec3_keysize_iterations`](#val_nsec3_keysize_iterations)
* [`add_holddown`](#add_holddown)
* [`del_holddown`](#del_holddown)
* [`keep_missing`](#keep_missing)
* [`permit_small_holddown`](#permit_small_holddown)
* [`key_cache_size`](#key_cache_size)
* [`key_cache_slabs`](#key_cache_slabs)
* [`neg_cache_size`](#neg_cache_size)
* [`unblock_lan_zones`](#unblock_lan_zones)
* [`insecure_lan_zones`](#insecure_lan_zones)
* [`local_zone`](#local_zone)
* [`local_data`](#local_data)
* [`local_data_ptr`](#local_data_ptr)
* [`local_zone_tag`](#local_zone_tag)
* [`local_zone_override`](#local_zone_override)
* [`ratelimit`](#ratelimit)
* [`ratelimit_size`](#ratelimit_size)
* [`ratelimit_slabs`](#ratelimit_slabs)
* [`ratelimit_factor`](#ratelimit_factor)
* [`ratelimit_for_domain`](#ratelimit_for_domain)
* [`ratelimit_below_domain`](#ratelimit_below_domain)
* [`ip_ratelimit`](#ip_ratelimit)
* [`ip_ratelimit_size`](#ip_ratelimit_size)
* [`ip_ratelimit_slabs`](#ip_ratelimit_slabs)
* [`ip_ratelimit_factor`](#ip_ratelimit_factor)
* [`fast_server_permil`](#fast_server_permil)
* [`fast_server_num`](#fast_server_num)
* [`forward`](#forward)
* [`stub`](#stub)
* [`record`](#record)
* [`access`](#access)
* [`confdir`](#confdir)
* [`directory`](#directory)
* [`conf_d`](#conf_d)
* [`config_file`](#config_file)
* [`control_enable`](#control_enable)
* [`control_setup_path`](#control_setup_path)
* [`control_path`](#control_path)
* [`fetch_client`](#fetch_client)
* [`group`](#group)
* [`keys_d`](#keys_d)
* [`trusted_keys_file`](#trusted_keys_file)
* [`module_config`](#module_config)
* [`owner`](#owner)
* [`username`](#username)
* [`package_name`](#package_name)
* [`package_ensure`](#package_ensure)
* [`purge_unbound_conf_d`](#purge_unbound_conf_d)
* [`root_hints_url`](#root_hints_url)
* [`runtime_dir`](#runtime_dir)
* [`auto_trust_anchor_file`](#auto_trust_anchor_file)
* [`anchor_fetch_command`](#anchor_fetch_command)
* [`service_name`](#service_name)
* [`service_hasstatus`](#service_hasstatus)
* [`service_ensure`](#service_ensure)
* [`service_enable`](#service_enable)
* [`validate_cmd`](#validate_cmd)
* [`restart_cmd`](#restart_cmd)
* [`custom_server_conf`](#custom_server_conf)
* [`skip_roothints_download`](#skip_roothints_download)
* [`python_script`](#python_script)
* [`dns64_prefix`](#dns64_prefix)
* [`dns64_synthall`](#dns64_synthall)
* [`send_client_subnet`](#send_client_subnet)
* [`client_subnet_zone`](#client_subnet_zone)
* [`client_subnet_always_forward`](#client_subnet_always_forward)
* [`max_client_subnet_ipv6`](#max_client_subnet_ipv6)
* [`max_client_subnet_ipv4`](#max_client_subnet_ipv4)
* [`min_client_subnet_ipv6`](#min_client_subnet_ipv6)
* [`min_client_subnet_ipv4`](#min_client_subnet_ipv4)
* [`max_ecs_tree_size_ipv4`](#max_ecs_tree_size_ipv4)
* [`max_ecs_tree_size_ipv6`](#max_ecs_tree_size_ipv6)
* [`ipsecmod_enabled`](#ipsecmod_enabled)
* [`ipsecmod_hook`](#ipsecmod_hook)
* [`ipsecmod_strict`](#ipsecmod_strict)
* [`ipsecmod_max_ttl`](#ipsecmod_max_ttl)
* [`ipsecmod_ignore_bogus`](#ipsecmod_ignore_bogus)
* [`ipsecmod_whitelist`](#ipsecmod_whitelist)
* [`backend`](#backend)
* [`secret_seed`](#secret_seed)
* [`redis_server_host`](#redis_server_host)
* [`redis_server_port`](#redis_server_port)
* [`redis_timeout`](#redis_timeout)
* [`unbound_conf_d`](#unbound_conf_d)

##### <a name="hints_file"></a>`hints_file`

Data type: `Unbound::Hints_file`

File path to the root-hints. Set to 'builtin' to remove root-hint option from unbound.conf and use built-in hints.

Default value: `"${confdir}/root.hints"`

##### <a name="hints_file_content"></a>`hints_file_content`

Data type: `Optional[String[1]]`

Contents of the root hints file, if it's not remotely fetched.

Default value: ``undef``

##### <a name="manage_service"></a>`manage_service`

Data type: `Boolean`



Default value: ``true``

##### <a name="verbosity"></a>`verbosity`

Data type: `Integer[0,5]`



Default value: `1`

##### <a name="statistics_interval"></a>`statistics_interval`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="statistics_cumulative"></a>`statistics_cumulative`

Data type: `Boolean`



Default value: ``false``

##### <a name="extended_statistics"></a>`extended_statistics`

Data type: `Boolean`



Default value: ``false``

##### <a name="num_threads"></a>`num_threads`

Data type: `Integer[1]`



Default value: `1`

##### <a name="port"></a>`port`

Data type: `Integer[0, 65535]`



Default value: `53`

##### <a name="interface"></a>`interface`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="interface_automatic"></a>`interface_automatic`

Data type: `Boolean`



Default value: ``false``

##### <a name="outgoing_interface"></a>`outgoing_interface`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="outgoing_range"></a>`outgoing_range`

Data type: `Optional[Integer[1]]`



Default value: ``undef``

##### <a name="outgoing_port_permit"></a>`outgoing_port_permit`

Data type: `Unbound::Range`



Default value: `'32768-65535'`

##### <a name="outgoing_port_avoid"></a>`outgoing_port_avoid`

Data type: `Unbound::Range`



Default value: `'0-32767'`

##### <a name="outgoing_port_permit_first"></a>`outgoing_port_permit_first`

Data type: `Boolean`



Default value: ``true``

##### <a name="outgoing_num_tcp"></a>`outgoing_num_tcp`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="incoming_num_tcp"></a>`incoming_num_tcp`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="edns_buffer_size"></a>`edns_buffer_size`

Data type: `Integer[0,4096]`



Default value: `1232`

##### <a name="max_udp_size"></a>`max_udp_size`

Data type: `Optional[Integer[0,65536]]`



Default value: ``undef``

##### <a name="stream_wait_size"></a>`stream_wait_size`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="msg_cache_size"></a>`msg_cache_size`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="msg_cache_slabs"></a>`msg_cache_slabs`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="num_queries_per_thread"></a>`num_queries_per_thread`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="jostle_timeout"></a>`jostle_timeout`

Data type: `Optional[Integer[1]]`



Default value: ``undef``

##### <a name="delay_close"></a>`delay_close`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="unknown_server_time_limit"></a>`unknown_server_time_limit`

Data type: `Optional[Integer[1]]`



Default value: ``undef``

##### <a name="so_rcvbuf"></a>`so_rcvbuf`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="so_sndbuf"></a>`so_sndbuf`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="so_reuseport"></a>`so_reuseport`

Data type: `Boolean`



Default value: ``false``

##### <a name="ip_transparent"></a>`ip_transparent`

Data type: `Boolean`



Default value: ``false``

##### <a name="ip_freebind"></a>`ip_freebind`

Data type: `Boolean`



Default value: ``false``

##### <a name="rrset_cache_size"></a>`rrset_cache_size`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="rrset_cache_slabs"></a>`rrset_cache_slabs`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="cache_max_ttl"></a>`cache_max_ttl`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="cache_max_negative_ttl"></a>`cache_max_negative_ttl`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="cache_min_ttl"></a>`cache_min_ttl`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="infra_host_ttl"></a>`infra_host_ttl`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="infra_cache_numhosts"></a>`infra_cache_numhosts`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="infra_cache_slabs"></a>`infra_cache_slabs`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="infra_cache_min_rtt"></a>`infra_cache_min_rtt`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="define_tag"></a>`define_tag`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="do_ip4"></a>`do_ip4`

Data type: `Boolean`



Default value: ``true``

##### <a name="do_ip6"></a>`do_ip6`

Data type: `Boolean`



Default value: ``true``

##### <a name="prefer_ip6"></a>`prefer_ip6`

Data type: `Boolean`



Default value: ``false``

##### <a name="do_udp"></a>`do_udp`

Data type: `Boolean`



Default value: ``true``

##### <a name="do_tcp"></a>`do_tcp`

Data type: `Boolean`



Default value: ``true``

##### <a name="tcp_mss"></a>`tcp_mss`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="tls_cert_bundle"></a>`tls_cert_bundle`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### <a name="tls_upstream"></a>`tls_upstream`

Data type: `Boolean`



Default value: ``false``

##### <a name="outgoing_tcp_mss"></a>`outgoing_tcp_mss`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="tcp_idle_timeout"></a>`tcp_idle_timeout`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="edns_tcp_keepalive"></a>`edns_tcp_keepalive`

Data type: `Boolean`



Default value: ``false``

##### <a name="edns_tcp_keepalive_timeout"></a>`edns_tcp_keepalive_timeout`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="tcp_upstream"></a>`tcp_upstream`

Data type: `Boolean`



Default value: ``false``

##### <a name="udp_upstream_without_downstream"></a>`udp_upstream_without_downstream`

Data type: `Boolean`



Default value: ``false``

##### <a name="ssl_upstream"></a>`ssl_upstream`

Data type: `Boolean`



Default value: ``false``

##### <a name="ssl_service_key"></a>`ssl_service_key`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### <a name="ssl_service_pem"></a>`ssl_service_pem`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### <a name="ssl_port"></a>`ssl_port`

Data type: `Optional[Integer[0,65535]]`



Default value: ``undef``

##### <a name="tls_ciphers"></a>`tls_ciphers`

Data type: `Optional[String[1]]`



Default value: ``undef``

##### <a name="tls_ciphersuites"></a>`tls_ciphersuites`

Data type: `Optional[String[1]]`



Default value: ``undef``

##### <a name="use_systemd"></a>`use_systemd`

Data type: `Boolean`



Default value: ``false``

##### <a name="do_daemonize"></a>`do_daemonize`

Data type: `Boolean`



Default value: ``true``

##### <a name="access_control"></a>`access_control`

Data type: `Hash[String[1], Unbound::Access_control]`



Default value: `{}`

##### <a name="chroot"></a>`chroot`

Data type: `Optional[Unbound::Chroot]`



Default value: ``undef``

##### <a name="logfile"></a>`logfile`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### <a name="log_identity"></a>`log_identity`

Data type: `Optional[String[1]]`



Default value: ``undef``

##### <a name="log_time_ascii"></a>`log_time_ascii`

Data type: `Boolean`



Default value: ``false``

##### <a name="log_queries"></a>`log_queries`

Data type: `Boolean`



Default value: ``false``

##### <a name="log_replies"></a>`log_replies`

Data type: `Boolean`



Default value: ``false``

##### <a name="log_tag_queryreply"></a>`log_tag_queryreply`

Data type: `Boolean`



Default value: ``false``

##### <a name="log_local_actions"></a>`log_local_actions`

Data type: `Boolean`



Default value: ``false``

##### <a name="log_servfail"></a>`log_servfail`

Data type: `Boolean`



Default value: ``false``

##### <a name="pidfile"></a>`pidfile`

Data type: `Stdlib::Absolutepath`



Default value: `'/var/run/unbound/unbound.pid'`

##### <a name="hide_identity"></a>`hide_identity`

Data type: `Boolean`



Default value: ``true``

##### <a name="identity"></a>`identity`

Data type: `Optional[String[1]]`



Default value: ``undef``

##### <a name="hide_version"></a>`hide_version`

Data type: `Boolean`



Default value: ``true``

##### <a name="version"></a>`version`

Data type: `Optional[String[1]]`



Default value: ``undef``

##### <a name="hide_trustanchor"></a>`hide_trustanchor`

Data type: `Boolean`



Default value: ``true``

##### <a name="target_fetch_policy"></a>`target_fetch_policy`

Data type: `Array[Integer]`



Default value: `[]`

##### <a name="harden_short_bufsize"></a>`harden_short_bufsize`

Data type: `Boolean`



Default value: ``false``

##### <a name="harden_large_queries"></a>`harden_large_queries`

Data type: `Boolean`



Default value: ``false``

##### <a name="harden_glue"></a>`harden_glue`

Data type: `Boolean`



Default value: ``true``

##### <a name="harden_dnssec_stripped"></a>`harden_dnssec_stripped`

Data type: `Boolean`



Default value: ``true``

##### <a name="harden_below_nxdomain"></a>`harden_below_nxdomain`

Data type: `Boolean`



Default value: ``true``

##### <a name="harden_referral_path"></a>`harden_referral_path`

Data type: `Boolean`



Default value: ``false``

##### <a name="harden_algo_downgrade"></a>`harden_algo_downgrade`

Data type: `Boolean`



Default value: ``false``

##### <a name="use_caps_for_id"></a>`use_caps_for_id`

Data type: `Boolean`



Default value: ``false``

##### <a name="caps_whitlist"></a>`caps_whitlist`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="qname_minimisation"></a>`qname_minimisation`

Data type: `Boolean`



Default value: ``false``

##### <a name="qname_minimisation_strict"></a>`qname_minimisation_strict`

Data type: `Boolean`



Default value: ``false``

##### <a name="private_address"></a>`private_address`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="private_domain"></a>`private_domain`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="unwanted_reply_threshold"></a>`unwanted_reply_threshold`

Data type: `Integer[0]`



Default value: `10000000`

##### <a name="do_not_query_address"></a>`do_not_query_address`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="do_not_query_localhost"></a>`do_not_query_localhost`

Data type: `Boolean`



Default value: ``true``

##### <a name="prefetch"></a>`prefetch`

Data type: `Boolean`



Default value: ``false``

##### <a name="prefetch_key"></a>`prefetch_key`

Data type: `Boolean`



Default value: ``false``

##### <a name="deny_any"></a>`deny_any`

Data type: `Boolean`



Default value: ``false``

##### <a name="rrset_roundrobin"></a>`rrset_roundrobin`

Data type: `Boolean`



Default value: ``false``

##### <a name="minimal_responses"></a>`minimal_responses`

Data type: `Boolean`



Default value: ``false``

##### <a name="disable_dnssec_lame_check"></a>`disable_dnssec_lame_check`

Data type: `Boolean`



Default value: ``false``

##### <a name="trust_anchor_file"></a>`trust_anchor_file`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### <a name="trust_anchor"></a>`trust_anchor`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="trust_anchor_signaling"></a>`trust_anchor_signaling`

Data type: `Boolean`



Default value: ``true``

##### <a name="domain_insecure"></a>`domain_insecure`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="val_sig_skew_min"></a>`val_sig_skew_min`

Data type: `Optional[Integer[1]]`



Default value: ``undef``

##### <a name="val_sig_skew_max"></a>`val_sig_skew_max`

Data type: `Optional[Integer[1]]`



Default value: ``undef``

##### <a name="val_bogus_ttl"></a>`val_bogus_ttl`

Data type: `Optional[Integer[1]]`



Default value: ``undef``

##### <a name="val_clean_additional"></a>`val_clean_additional`

Data type: `Boolean`



Default value: ``true``

##### <a name="val_log_level"></a>`val_log_level`

Data type: `Optional[Integer[0,2]]`



Default value: ``undef``

##### <a name="val_permissive_mode"></a>`val_permissive_mode`

Data type: `Boolean`



Default value: ``false``

##### <a name="ignore_cd_flag"></a>`ignore_cd_flag`

Data type: `Boolean`



Default value: ``false``

##### <a name="serve_expired"></a>`serve_expired`

Data type: `Boolean`



Default value: ``false``

##### <a name="serve_expired_ttl"></a>`serve_expired_ttl`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="serve_expired_ttl_reset"></a>`serve_expired_ttl_reset`

Data type: `Boolean`



Default value: ``false``

##### <a name="serve_expired_reply_ttl"></a>`serve_expired_reply_ttl`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="serve_expired_client_timeout"></a>`serve_expired_client_timeout`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="val_nsec3_keysize_iterations"></a>`val_nsec3_keysize_iterations`

Data type: `Array[Integer[1]]`



Default value: `[]`

##### <a name="add_holddown"></a>`add_holddown`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="del_holddown"></a>`del_holddown`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="keep_missing"></a>`keep_missing`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="permit_small_holddown"></a>`permit_small_holddown`

Data type: `Boolean`



Default value: ``false``

##### <a name="key_cache_size"></a>`key_cache_size`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="key_cache_slabs"></a>`key_cache_slabs`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="neg_cache_size"></a>`neg_cache_size`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="unblock_lan_zones"></a>`unblock_lan_zones`

Data type: `Boolean`



Default value: ``false``

##### <a name="insecure_lan_zones"></a>`insecure_lan_zones`

Data type: `Boolean`



Default value: ``false``

##### <a name="local_zone"></a>`local_zone`

Data type: `Unbound::Local_zone`



Default value: `{}`

##### <a name="local_data"></a>`local_data`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="local_data_ptr"></a>`local_data_ptr`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="local_zone_tag"></a>`local_zone_tag`

Data type: `Hash[String[1], Array[String[1]]]`



Default value: `{}`

##### <a name="local_zone_override"></a>`local_zone_override`

Data type: `Hash[String[1], Unbound::Local_zone_override]`



Default value: `{}`

##### <a name="ratelimit"></a>`ratelimit`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="ratelimit_size"></a>`ratelimit_size`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="ratelimit_slabs"></a>`ratelimit_slabs`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="ratelimit_factor"></a>`ratelimit_factor`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="ratelimit_for_domain"></a>`ratelimit_for_domain`

Data type: `Hash[String[1], Integer[0]]`



Default value: `{}`

##### <a name="ratelimit_below_domain"></a>`ratelimit_below_domain`

Data type: `Hash[String[1], Integer[0]]`



Default value: `{}`

##### <a name="ip_ratelimit"></a>`ip_ratelimit`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="ip_ratelimit_size"></a>`ip_ratelimit_size`

Data type: `Optional[Unbound::Size]`



Default value: ``undef``

##### <a name="ip_ratelimit_slabs"></a>`ip_ratelimit_slabs`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="ip_ratelimit_factor"></a>`ip_ratelimit_factor`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="fast_server_permil"></a>`fast_server_permil`

Data type: `Optional[Integer[0,1000]]`



Default value: ``undef``

##### <a name="fast_server_num"></a>`fast_server_num`

Data type: `Optional[Integer[1]]`



Default value: ``undef``

##### <a name="forward"></a>`forward`

Data type: `Hash`



Default value: `{}`

##### <a name="stub"></a>`stub`

Data type: `Hash`



Default value: `{}`

##### <a name="record"></a>`record`

Data type: `Hash`



Default value: `{}`

##### <a name="access"></a>`access`

Data type: `Array`



Default value: `['::1', '127.0.0.1']`

##### <a name="confdir"></a>`confdir`

Data type: `String[1]`



Default value: `'/etc/unbound'`

##### <a name="directory"></a>`directory`

Data type: `Stdlib::Absolutepath`



Default value: `$confdir`

##### <a name="conf_d"></a>`conf_d`

Data type: `String[1]`



Default value: `"${confdir}/conf.d"`

##### <a name="config_file"></a>`config_file`

Data type: `String[1]`



Default value: `"${confdir}/unbound.conf"`

##### <a name="control_enable"></a>`control_enable`

Data type: `Boolean`



Default value: ``false``

##### <a name="control_setup_path"></a>`control_setup_path`

Data type: `String[1]`



Default value: `'/usr/sbin/unbound-control-setup'`

##### <a name="control_path"></a>`control_path`

Data type: `String[1]`



Default value: `'/usr/sbin/unbound-control'`

##### <a name="fetch_client"></a>`fetch_client`

Data type: `String[1]`



Default value: `'wget -O'`

##### <a name="group"></a>`group`

Data type: `String[1]`



Default value: `'unbound'`

##### <a name="keys_d"></a>`keys_d`

Data type: `String[1]`



Default value: `"${confdir}/keys.d"`

##### <a name="trusted_keys_file"></a>`trusted_keys_file`

Data type: `Stdlib::Absolutepath`



Default value: `"${keys_d}/*.key"`

##### <a name="module_config"></a>`module_config`

Data type: `Array[Unbound::Module]`



Default value: `[]`

##### <a name="owner"></a>`owner`

Data type: `String[1]`



Default value: `'unbound'`

##### <a name="username"></a>`username`

Data type: `String[1]`



Default value: `$owner`

##### <a name="package_name"></a>`package_name`

Data type: `String`



Default value: `'unbound'`

##### <a name="package_ensure"></a>`package_ensure`

Data type: `String[1]`



Default value: `'installed'`

##### <a name="purge_unbound_conf_d"></a>`purge_unbound_conf_d`

Data type: `Boolean`



Default value: ``false``

##### <a name="root_hints_url"></a>`root_hints_url`

Data type: `String[1]`



Default value: `'https://www.internic.net/domain/named.root'`

##### <a name="runtime_dir"></a>`runtime_dir`

Data type: `Stdlib::Absolutepath`



Default value: `$confdir`

##### <a name="auto_trust_anchor_file"></a>`auto_trust_anchor_file`

Data type: `Stdlib::Absolutepath`



Default value: `"${runtime_dir}/root.key"`

##### <a name="anchor_fetch_command"></a>`anchor_fetch_command`

Data type: `String[1]`



Default value: `"unbound-anchor -a ${auto_trust_anchor_file}"`

##### <a name="service_name"></a>`service_name`

Data type: `String[1]`



Default value: `'unbound'`

##### <a name="service_hasstatus"></a>`service_hasstatus`

Data type: `Boolean`



Default value: ``true``

##### <a name="service_ensure"></a>`service_ensure`

Data type: `Enum['running', 'stopped']`



Default value: `'running'`

##### <a name="service_enable"></a>`service_enable`

Data type: `Boolean`



Default value: ``true``

##### <a name="validate_cmd"></a>`validate_cmd`

Data type: `String[1]`



Default value: `'/usr/sbin/unbound-checkconf %'`

##### <a name="restart_cmd"></a>`restart_cmd`

Data type: `String[1]`



Default value: `"/bin/systemctl restart ${service_name}"`

##### <a name="custom_server_conf"></a>`custom_server_conf`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="skip_roothints_download"></a>`skip_roothints_download`

Data type: `Boolean`



Default value: ``false``

##### <a name="python_script"></a>`python_script`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### <a name="dns64_prefix"></a>`dns64_prefix`

Data type: `String[1]`



Default value: `'64:ff9b::/96'`

##### <a name="dns64_synthall"></a>`dns64_synthall`

Data type: `Boolean`



Default value: ``false``

##### <a name="send_client_subnet"></a>`send_client_subnet`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="client_subnet_zone"></a>`client_subnet_zone`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="client_subnet_always_forward"></a>`client_subnet_always_forward`

Data type: `Boolean`



Default value: ``false``

##### <a name="max_client_subnet_ipv6"></a>`max_client_subnet_ipv6`

Data type: `Integer[0,128]`



Default value: `56`

##### <a name="max_client_subnet_ipv4"></a>`max_client_subnet_ipv4`

Data type: `Integer[0,32]`



Default value: `24`

##### <a name="min_client_subnet_ipv6"></a>`min_client_subnet_ipv6`

Data type: `Optional[Integer[0,128]]`



Default value: ``undef``

##### <a name="min_client_subnet_ipv4"></a>`min_client_subnet_ipv4`

Data type: `Optional[Integer[0,32]]`



Default value: ``undef``

##### <a name="max_ecs_tree_size_ipv4"></a>`max_ecs_tree_size_ipv4`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="max_ecs_tree_size_ipv6"></a>`max_ecs_tree_size_ipv6`

Data type: `Optional[Integer[0]]`



Default value: ``undef``

##### <a name="ipsecmod_enabled"></a>`ipsecmod_enabled`

Data type: `Boolean`



Default value: ``true``

##### <a name="ipsecmod_hook"></a>`ipsecmod_hook`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### <a name="ipsecmod_strict"></a>`ipsecmod_strict`

Data type: `Boolean`



Default value: ``false``

##### <a name="ipsecmod_max_ttl"></a>`ipsecmod_max_ttl`

Data type: `Integer[1]`



Default value: `3600`

##### <a name="ipsecmod_ignore_bogus"></a>`ipsecmod_ignore_bogus`

Data type: `Boolean`



Default value: ``false``

##### <a name="ipsecmod_whitelist"></a>`ipsecmod_whitelist`

Data type: `Array[String[1]]`



Default value: `[]`

##### <a name="backend"></a>`backend`

Data type: `Optional[String[1]]`



Default value: ``undef``

##### <a name="secret_seed"></a>`secret_seed`

Data type: `String[1]`



Default value: `'default'`

##### <a name="redis_server_host"></a>`redis_server_host`

Data type: `String[1]`



Default value: `'127.0.0.1'`

##### <a name="redis_server_port"></a>`redis_server_port`

Data type: `Integer[1,65536]`



Default value: `6379`

##### <a name="redis_timeout"></a>`redis_timeout`

Data type: `Integer[1]`



Default value: `100`

##### <a name="unbound_conf_d"></a>`unbound_conf_d`

Data type: `Stdlib::Absolutepath`



Default value: `"${confdir}/unbound.conf.d"`

### <a name="unboundremote"></a>`unbound::remote`

Class: unbound::remote

Configure remote control of the unbound daemon process

=== Parameters:

[*enable*]
  (optional) The option is used to enable remote control, default is false.
  If turned off, the server does not listen for  control.

[*interface*]
  (optional) Give  IPv4  or IPv6 addresses to listen on for control commands.
  By default localhost (127.0.0.1 and ::1) is listened.

[*port*]
  (optional) The port number to listen on for control commands, default is
  8953.  If you change this port number,  and  permissions have been dropped,
  a reload is not sufficient to open the port again, you must then restart.

[*server_key_file*]
  (optional) Path to the server private key, by default unbound_server.key.
  This file is generated by the unbound-control-setup utility.  This file is
  used by the unbound server, but not by unbound-control.

[*server_cert_file*]
  (optional) Path to the server self signed certificate, by default
  unbound_server.pem.  This file is generated by the unbound-control-setup
  utility.  This file is used by the unbound server, and also by
  unbound-control.

[*control_key_file*]
  (optional) Path to the control client private key, by default
  unbound_control.key.  This file is generated by the unbound-control-setup
  utility.  This file is used by unbound-control.

[*control_cert_file*]
  (optional) Path to the control client certificate, by default
  unbound_control.pem.  This certificate has to be  signed  with  the server
  certificate. This file is generated by the unbound-control-setup utility.
  This file is used by unbound-control.

[*group*]
  (optional) Name of the group for unbound files and directory

[*confdir*]
  (optional) Name of the directory where configuration files are stored

[*config_file*]
  (optional) Name of the unbound config file

#### Parameters

The following parameters are available in the `unbound::remote` class:

* [`enable`](#enable)
* [`interface`](#interface)
* [`port`](#port)
* [`control_use_cert`](#control_use_cert)
* [`server_key_file`](#server_key_file)
* [`server_cert_file`](#server_cert_file)
* [`control_key_file`](#control_key_file)
* [`control_cert_file`](#control_cert_file)
* [`group`](#group)
* [`confdir`](#confdir)
* [`config_file`](#config_file)
* [`control_setup_path`](#control_setup_path)

##### <a name="enable"></a>`enable`

Data type: `Boolean`



Default value: `$unbound::control_enable`

##### <a name="interface"></a>`interface`

Data type: `Array`



Default value: `['::1', '127.0.0.1']`

##### <a name="port"></a>`port`

Data type: `Integer`



Default value: `8953`

##### <a name="control_use_cert"></a>`control_use_cert`

Data type: `Boolean`



Default value: ``true``

##### <a name="server_key_file"></a>`server_key_file`

Data type: `String`



Default value: `"${unbound::confdir}/unbound_server.key"`

##### <a name="server_cert_file"></a>`server_cert_file`

Data type: `String`



Default value: `"${unbound::confdir}/unbound_server.pem"`

##### <a name="control_key_file"></a>`control_key_file`

Data type: `String`



Default value: `"${$unbound::confdir}/unbound_control.key"`

##### <a name="control_cert_file"></a>`control_cert_file`

Data type: `String`



Default value: `"${$unbound::confdir}/unbound_control.pem"`

##### <a name="group"></a>`group`

Data type: `Any`



Default value: `$unbound::group`

##### <a name="confdir"></a>`confdir`

Data type: `Any`



Default value: `$unbound::confdir`

##### <a name="config_file"></a>`config_file`

Data type: `Any`



Default value: `$unbound::config_file`

##### <a name="control_setup_path"></a>`control_setup_path`

Data type: `Any`



Default value: `$unbound::control_setup_path`

## Defined types

### <a name="unboundforward"></a>`unbound::forward`

Class: unbound::forward

Configures a zone for DNS forwarding

== Parameters:

[*zone*]
  (required) the name of the zone.

[*address*]
  IP address of server to forward queries to. Can be IP 4 or IP 6 (and an
  array or a single value. To use a nondefault port for DNS communication
  append '@' with the port number.

[*host*]
  Hostname of server to forward queries to. Can be IP 4 or IP 6 (and an array
  or a single value. To use a nondefault port for DNS communication append
  '@' with the port number.

[*forward_first*]
  (optional) If enabled, a query is attempted without the forward clause if
  it fails.  The data could not be retrieved and would have caused SERVFAIL
  because the servers are unreachable, instead it is tried without this
  clause. The default is 'no'.

[*forward_ssl_upstream*]
  (optional) If enabled, unbound will query the forward DNS server via TLS.

[*config_file*]
  (optional) name of configuration file

#### Parameters

The following parameters are available in the `unbound::forward` defined type:

* [`address`](#address)
* [`host`](#host)
* [`zone`](#zone)
* [`forward_first`](#forward_first)
* [`forward_ssl_upstream`](#forward_ssl_upstream)
* [`forward_tls_upstream`](#forward_tls_upstream)
* [`config_file`](#config_file)

##### <a name="address"></a>`address`

Data type: `Array`



Default value: `[]`

##### <a name="host"></a>`host`

Data type: `Array`



Default value: `[]`

##### <a name="zone"></a>`zone`

Data type: `Any`



Default value: `$name`

##### <a name="forward_first"></a>`forward_first`

Data type: `Pattern[/yes|no/]`



Default value: `'no'`

##### <a name="forward_ssl_upstream"></a>`forward_ssl_upstream`

Data type: `Pattern[/yes|no/]`



Default value: `'no'`

##### <a name="forward_tls_upstream"></a>`forward_tls_upstream`

Data type: `Pattern[/yes|no/]`



Default value: `'no'`

##### <a name="config_file"></a>`config_file`

Data type: `Any`



Default value: `$unbound::config_file`

### <a name="unboundlocalzone"></a>`unbound::localzone`

Class: unbound::localzone

Configures a local zone.
The  default  zones  are  localhost, reverse 127.0.0.1 and ::1, and the
AS112 zones. The AS112 zones are reverse DNS zones for private use  and
reserved IP addresses for which the servers on the internet cannot pro-
vide correct answers.

=== Parameters:

[*zone*]
  (required) String. Zone name.

[*type*]
  (required) Custom type Unbound::Local_zone_type.

[*config_file*]
  (optional) name of configuration file.

[*local_data*]
  (optional) Array.
  Define local data which should be rendered into configuration file. Required
  value is an Array of the custom type Unbond::Resource_record_type.
  Default value: [].
  Example:
    unbound::localzone::local_data:
      - name: 'api.test.com'
        ttl: 15
        class: IN
        type: A
        data: '1.1.1.1'
      - name: 'backend.test.com'
        type: A
        data: '2.2.2.2'

[*template_name*]
  (optional) String.
  Use a custom template.
  Default value: 'unbound/local_zone.erb'.

#### Parameters

The following parameters are available in the `unbound::localzone` defined type:

* [`type`](#type)
* [`zone`](#zone)
* [`config_file`](#config_file)
* [`local_data`](#local_data)
* [`template_name`](#template_name)

##### <a name="type"></a>`type`

Data type: `Unbound::Local_zone_type`



##### <a name="zone"></a>`zone`

Data type: `String`



Default value: `$name`

##### <a name="config_file"></a>`config_file`

Data type: `Any`



Default value: `$unbound::config_file`

##### <a name="local_data"></a>`local_data`

Data type: `Array[Unbound::Resource_record_type]`



Default value: `[]`

##### <a name="template_name"></a>`template_name`

Data type: `String`



Default value: `'unbound/local_zone.erb'`

### <a name="unboundrecord"></a>`unbound::record`

Class: unbound::record

Create an unbound static DNS record override

== Parameters:

[*content*]
  (required) The name of the record (ip address)

[*ttl*]
  (optional) The time to live for this record, defaults to '14400'

[*type*]
  (optional) Type or the record

[*reverse*]
  (optional) Reverse record or not, defaults to false

[*entry*]
  (optional) Name entry for the record (name)

[*config_file*]
  (optional) name of configuration file

#### Parameters

The following parameters are available in the `unbound::record` defined type:

* [`content`](#content)
* [`ttl`](#ttl)
* [`type`](#type)
* [`reverse`](#reverse)
* [`entry`](#entry)
* [`config_file`](#config_file)

##### <a name="content"></a>`content`

Data type: `String`



##### <a name="ttl"></a>`ttl`

Data type: `Any`



Default value: `'14400'`

##### <a name="type"></a>`type`

Data type: `Any`



Default value: `'A'`

##### <a name="reverse"></a>`reverse`

Data type: `Any`



Default value: ``false``

##### <a name="entry"></a>`entry`

Data type: `Any`



Default value: `$name`

##### <a name="config_file"></a>`config_file`

Data type: `Any`



Default value: `$unbound::config_file`

### <a name="unboundstub"></a>`unbound::stub`

Class: unbound::stub

Create an unbound stub zone for caching upstream name resolvers

=== Parameters:

[*address*]
  (required) IP address of server to forward to. Can be IP 4 or IP 6 (and an
  array or a single value. To use a nondefault port for DNS communication
  append  '@' with the port number.

[*insecure*]
  (optional) Defaults to false. Sets domain name to be insecure, DNSSEC chain
  of trust is ignored towards the domain name.  So a trust anchor  above the
  domain  name can not make the domain secure with a DS record, such a DS
  record is then ignored.  Also keys from DLV are ignored for the domain.
  Can be given multiple times to specify multiple domains  that  are  treated
  as  if unsigned.  If you set trust anchors for the domain they override
  this setting (and the domain is secured).
  This can be useful if you want to make sure a trust anchor for external
  lookups does not affect an (unsigned) internal domain.  A DS record
  externally can create validation failures for that internal domain.

[*type*]
  (optional) Defaults to 'transparent', can be 'deny', 'refuse', 'static',
  'transparent', 'typetransparent', 'redirect' or 'nodefault'.

[*config_file*]
  (optional) Name of the unbound config file

#### Parameters

The following parameters are available in the `unbound::stub` defined type:

* [`address`](#address)
* [`insecure`](#insecure)
* [`no_cache`](#no_cache)
* [`type`](#type)
* [`config_file`](#config_file)

##### <a name="address"></a>`address`

Data type: `Variant[Array[Unbound::Address], Unbound::Address]`



##### <a name="insecure"></a>`insecure`

Data type: `Variant[Boolean, Enum['true', 'false']]`



Default value: ``false``

##### <a name="no_cache"></a>`no_cache`

Data type: `Variant[Boolean, Enum['true', 'false']]`



Default value: ``false``

##### <a name="type"></a>`type`

Data type: `Unbound::Local_zone_type`



Default value: `'transparent'`

##### <a name="config_file"></a>`config_file`

Data type: `Optional[Stdlib::Unixpath]`



Default value: ``undef``

## Data types

### <a name="unboundaccess_control"></a>`Unbound::Access_control`

The Unbound::Access_control data type.

Alias of

```puppet
Struct[{
    action    => Optional[Enum['deny', 'refuse', 'allow', 'allow_snoop', 'deny_non_local', 'refuse_non_local']],
    tags      => Optional[Array[String]],
    rr_string => Optional[String],
    view      => Optional[String],
}]
```

### <a name="unboundaddress"></a>`Unbound::Address`

Patterns copied from Stdlib::IP

Alias of

```puppet
Variant[Stdlib::IP::Address::Nosubnet, Pattern[
    /\A([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}@\d{1,5}\z/,
    /\A[[:xdigit:]]{1,4}(:[[:xdigit:]]{1,4}){7}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){6}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){4}(:[[:xdigit:]]{1,4}){0,1}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){3}(:[[:xdigit:]]{1,4}){0,2}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){2}(:[[:xdigit:]]{1,4}){0,3}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){1}(:[[:xdigit:]]{1,4}){0,4}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A:(:[[:xdigit:]]{1,4}){0,5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A:(:|(:[[:xdigit:]]{1,4}){1,7})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){1}(:|(:[[:xdigit:]]{1,4}){1,6})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){2}(:|(:[[:xdigit:]]{1,4}){1,5})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){3}(:|(:[[:xdigit:]]{1,4}){1,4})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){4}(:|(:[[:xdigit:]]{1,4}){1,3})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){5}(:|(:[[:xdigit:]]{1,4}){1,2})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){6}(:|(:[[:xdigit:]]{1,4}){1,1})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
    /\A([[:xdigit:]]{1,4}:){7}:(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?@\d{1,5}\z/,
  ]]
```

### <a name="unboundchroot"></a>`Unbound::Chroot`

The Unbound::Chroot data type.

Alias of

```puppet
Variant[Enum[''], Stdlib::Absolutepath]
```

### <a name="unboundhints_file"></a>`Unbound::Hints_file`

The Unbound::Hints_file data type.

Alias of

```puppet
Variant[Enum['builtin'], Stdlib::Absolutepath]
```

### <a name="unboundlocal_zone"></a>`Unbound::Local_zone`

custom enum type for local-zone types

Alias of

```puppet
Hash[String, Unbound::Local_zone_type]
```

### <a name="unboundlocal_zone_override"></a>`Unbound::Local_zone_override`

The Unbound::Local_zone_override data type.

Alias of

```puppet
Struct[{
    netblock => String,
    type     => Unbound::Local_zone_type
}]
```

### <a name="unboundlocal_zone_type"></a>`Unbound::Local_zone_type`

custom enum type for local-zone types

Alias of

```puppet
Enum['deny', 'refuse', 'static', 'transparent', 'redirect', 'nodefault', 'typetransparent', 'inform', 'inform_deny', 'always_transparent', 'always_refuse', 'always_nxdomain']
```

### <a name="unboundmodule"></a>`Unbound::Module`

The Unbound::Module data type.

Alias of

```puppet
Enum['validator', 'iterator', 'python', 'dns64', 'subnetcache', 'ipsecmod', 'cachedb']
```

### <a name="unboundrange"></a>`Unbound::Range`

The Unbound::Range data type.

Alias of

```puppet
Pattern[/\d+(-\d+)?/]
```

### <a name="unboundresource_record_type"></a>`Unbound::Resource_record_type`

custom type for resource record used for local-data

Alias of

```puppet
Struct[{
    'name'      => String,
    'ttl'       => Optional[Integer],
    'class'     => Optional[String],
    'type'      => String,
    'data'      => String,
}]
```

### <a name="unboundsize"></a>`Unbound::Size`

The Unbound::Size data type.

Alias of

```puppet
Pattern[/\d+([kmg])?/]
```

