"""initial

Revision ID: 59b1fbd157a4
Revises: 
Create Date: 2023-01-11 17:35:13.703437

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = '59b1fbd157a4'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('machines',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('hostname', sa.Unicode(length=255), nullable=True),
    sa.Column('serial', sa.String(length=64), nullable=False),
    sa.Column('product_name', sa.String(length=64), nullable=False),
    sa.Column('vendor', sa.String(length=64), nullable=False),
    sa.Column('dhcp_ipv4', sa.String(length=32), nullable=False),
    sa.Column('status', sa.Enum('live', 'installing', 'bootinglive', 'bootinghdd', 'prod'), server_default='live', nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('serial', name='uniq_serial')
    )
    op.create_index('machines_uuid_idx', 'machines', ['uuid'], unique=False)

    op.create_table('roles',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('name', sa.Unicode(length=64), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', name='uniq_role_name')
    )
    op.create_index('roles_uuid_idx', 'roles', ['uuid'], unique=False)

    op.create_table('clusters',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('name', sa.Unicode(length=200), nullable=True),
    sa.Column('domain_name', sa.Unicode(length=255), nullable=True),
    sa.Column('region_name', sa.Unicode(length=255), nullable=True),
    sa.Column('time_server_host', sa.Unicode(length=255), nullable=True),
    sa.Column('mail_relay_host', sa.Unicode(length=200), nullable=True),
    sa.Column('nameserver_v4_prim', sa.String(length=200), nullable=True),
    sa.Column('nameserver_v4_sec', sa.String(length=200), nullable=True),
    sa.Column('nameserver_v6_prim', sa.String(length=200), nullable=True),
    sa.Column('nameserver_v6_sec', sa.String(length=200), nullable=True),
    sa.Column('admin_email_address', sa.Unicode(length=200), nullable=True),
    sa.Column('dhcp_domain', sa.Unicode(length=200), nullable=True)
    )
    op.create_index('clusters_uuid_idx', 'clusters', ['uuid'], unique=False)
    op.create_unique_constraint('uniq_cluster_name', 'clusters', ['name'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('roles')
    op.drop_table('machines')
    op.drop_table('clusters')
    # ### end Alembic commands ###
