#include <iostream>

#include "Global.hh"
#include "Message.hh"
#include "CommandlineOptions.hh"

#include "ContainerIO.hh"
#include "PointConfiguration.hh"
#include "Permutation.hh"
#include "Symmetry.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing some symmetries of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;

  PointConfiguration points;
  if (std::cin >> points) {
    if ((points.no() < 2) || (points.rank() < 2)) {
      MessageStreams::verbose() << "no of points and rank must be at least two." << std::endl;
      return 1;
    }
    if (points.rank() > points.no()) {
      MessageStreams::verbose() << "rank must not be larger than no of points." << std::endl;
      return 1;
    }
    symmetry_collectordata S_data;
    Permutation perm(points.rank(), 2);
    do {
      Symmetry s(perm, true);
      S_data.insert(s);
    } while (perm.lexnext());
    SymmetryGroup S(points.rank(), S_data);
    symmetry_collectordata result_generators(S.rowperm_symmetry_generators(points));
    SymmetryGroup result(points.no(), result_generators, false);
    result.write_sorted_generators(MessageStreams::result());
    MessageStreams::result() << std::endl;
    return 0;
  }
  else {
    MessageStreams::verbose() << "points2symmetries: error while reading point configuration."
			      << std::endl;
    return 1;
  }
}

// eof points2symmetries.cc
