////////////////////////////////////////////////////////////////////////////////
// 
// CheckPoint.hh 
//
//    produced: 2024-04-12 jr
//
////////////////////////////////////////////////////////////////////////////////
#ifndef CHECKPOINT_HH
#define CHECKPOINT_HH

#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <filesystem>

#include "Signal.hh"
#include "Global.hh"
#include "CommandlineOptions.hh"
#include "ContainerIO.hh"

namespace topcom {

  // the following class can be used to organize the interrupt
  // of enumeration and the output of intermediate results:
  class CheckPoint {
  private:
    long               _countdown;
    long               _old_count;
    int                _dump_no;
    std::fstream       _dump_str;
    std::ostringstream _filename_str;
  public:
    inline CheckPoint();
    inline CheckPoint(const CheckPoint& cp);
    inline CheckPoint& operator=(const CheckPoint& cp);

    // for sanity checks:
    inline int dump_no() const;

    // return a file stream for the class to write its intermediate result to:
    inline std::fstream& dump_stream();

    // dump only according to frequency settings:
    bool decide_dump(const size_type count);
    void open_dump();
    void close_dump();
  };

  inline CheckPoint::CheckPoint() :
    _countdown(CommandlineOptions::dump_frequency()),
    _old_count(0),
    _dump_no(0) {}
  inline CheckPoint::CheckPoint(const CheckPoint& cp) :
    _countdown(cp._countdown),
    _old_count(cp._old_count),
    _dump_no(cp._dump_no) {}
  inline CheckPoint& CheckPoint::operator=(const CheckPoint& cp) {
    if (this == &cp) {
      return *this;
    }
    _countdown = cp._countdown;
    _old_count = cp._old_count; 
    _dump_no   = cp._dump_no;
    return *this;
  }

  // for sanity checks:
  inline int CheckPoint::dump_no() const { return _dump_no; }

  // return a file stream for the class to write its intermediate result to:
  inline std::fstream& CheckPoint::dump_stream() { return _dump_str; }


  
}; // namespace topcom



#endif

// eof CommandlineOptions.hh
