////////////////////////////////////////////////////////////////////////////////
// 
// CheckPoint.cc
//
//    produced: 2024-04-15 jr
// 
////////////////////////////////////////////////////////////////////////////////

#include "CheckPoint.hh"

namespace topcom {

  // dump only according to frequency settings:
  bool CheckPoint::decide_dump(const size_type count) {
    MessageStreams::debug() << message::lock
			    << "deciding about checkpoint ..." << '\n'
			    << "... countdown before call: " << _countdown
			    << " ..." << std::endl
			    << message::unlock;
    _countdown -= (count - _old_count);
    _old_count = count;
    MessageStreams::debug() << message::lock
			    << "... countdown after call: " << _countdown
			    << " ..." << std::endl
			    << message::unlock;
    if (_countdown <= 0) {
      MessageStreams::debug() << message::lock
			    << "... yes: checkpointing - master is waiting for interrupt completion ..." << std::endl;
      _countdown = CommandlineOptions::dump_frequency();
      MessageStreams::debug() << message::lock
			      << "... done" << std::endl
			      << message::unlock;
      return true;
    }
    else {
      MessageStreams::debug() << message::lock
			      << "no: skipping checkpointing this time" << std::endl
			      << message::unlock;
      return false;
    }
  }
  
  void CheckPoint::open_dump() {
    MessageStreams::verbose() << message::lock;
    MessageStreams::verbose().print_dumpseparator();
    if (Signal::signal_received()) {
      MessageStreams::verbose() << "### irregular checkpoint by external termination signal:" << std::endl;
    }
    else {
      MessageStreams::verbose() << "### regular checkpoint by settings from command line option: " << std::endl;
    }
    _filename_str << CommandlineOptions::dump_file() << "." << _dump_no % CommandlineOptions::dump_rotations();
    _dump_str.open(_filename_str.str().c_str(), std::ios::out | std::ios::trunc);
    MessageStreams::verbose() << "### dump file "
			      << _dump_no
			      << ":\n"
			      << "### "
			      << _filename_str.str().c_str() << std::endl;
    MessageStreams::verbose().print_dumpseparator();
    MessageStreams::verbose() << message::unlock;
  }
  
  void CheckPoint::close_dump() {
    _dump_str.close();
    
    // for convenience, create a symlink named by the dump file name without
    // the running number pointing to the latest fully saved checkpoint:
    if (std::filesystem::exists(CommandlineOptions::dump_file())) {
      std::filesystem::remove(CommandlineOptions::dump_file());
    }
    std::filesystem::create_symlink(_filename_str.str().c_str(),
				    CommandlineOptions::dump_file());
    ++_dump_no;
    _filename_str.str("");
    _filename_str.clear();
  }

}; // namespace topcom
  
// eof CheckPoint.cc
