# Contributing to toml++

Contributions are very welcome! Either by [reporting issues] or submitting pull requests.
If you wish to submit a PR, please be aware that:

-   The single-header file `toml.hpp` is generated by a script; make your changes in the files in
    `include`, **not** in `toml.hpp`.
-   Your changes should compile warning-free on at least one of:
    -   GCC 8 or higher
    -   Clang 8 or higher
    -   MSVC 19.2X (Visual Studio 2019) or higher
-   You should regenerate the single-header file as part of your PR (a CI check will fail if you don't).

<br>

## Regenerating toml.hpp

1. Make your changes as necessary
    - If you've added a new header file that isn't going to be transitively included by one of the
      others, add an include directive to `include/toml++/toml.h`
2. Install the prerequisite python packages: `pip3 install -r tools/requirements.txt`
3. Run `tools/generate_single_header.py`

<br>

## Building and running the tests

Testing is done using [Catch2].

### Testing on Windows with Visual Studio

Install [Visual Studio] and [Test Adapter for Catch2], then open `toml++.sln` and build the
projects in the `tests` solution folder. Visual Studio's Test Explorer should pick these up and
allow you to run the tests directly.

If test discovery fails you can usually fix it by enabling
`Auto Detect runsettings Files` (settings gear icon > `Configure Run Settings`).

### Testing on Linux (and WSL)

```bash
# install ninja, meson, locales (first time only)
sudo apt update && sudo apt install -y locales python3 python3-pip ninja-build
sudo pip3 install meson
sudo locale-gen 'en_US.utf8' \
                'ja_JP.utf8' \
                'de_DE.utf8' \
                'it_IT.utf8' \
                'tr_TR.utf8' \
                'fi_FI.utf8' \
                'fr_FR.utf8' \
                'zh_CN.utf8'

# create the build configs (first time only)
meson setup build-debug   --buildtype=debug   -Ddevel=true
meson setup build-release --buildtype=release   -Ddevel=true

# run the tests
cd build-debug && ninja && ninja test               \
    && cd ../build-release && ninja && ninja test   \
    && cd ..
```

> ℹ&#xFE0F; Pass `-Duse_vendored_libs=false` to Meson if you wish to use the system-installed version
> of Catch2 rather than the vendored one.

<br>

## Testing with the [toml-test] suite

As an optional extra you may wish to test against the 'official' test TOML test suite, [BurntSushi/toml-test]. See the
instructions at [toml-test/README](./toml-test/README.md). Note that the toml++ tests already consume tests from the
offical suite via a C++ code-generation script so you are not expected to take this extra step as part of contributing
to the library.

[visual studio]: https://visualstudio.microsoft.com/vs/
[test adapter for catch2]: https://marketplace.visualstudio.com/items?itemName=JohnnyHendriks.ext01
[reporting issues]: https://github.com/marzer/tomlplusplus/issues
[catch2]: https://github.com/catchorg/Catch2
[toml-test]: https://github.com/BurntSushi/toml-test
[burntsushi/toml-test]: https://github.com/BurntSushi/toml-test
