use core:lang;
use core:io;
use lang:bs:macro;

class NoVariable extends Exception {

	Str variable;

	init(Str variable) {
		init { variable = variable; }
	}

	void message(StrBuf out) : override {
		out << "No variable named " << variable << " is defined.";
	}
}

class VarList {

	Str->Int values;

	void put(Str name, Int value) {
		values.put(name, value);
	}

	Int get(Str name) {
		if (x = values.at(name)) {
			x;
		} else {
			throw NoVariable(name);
		}
	}
}

void eval(Str expr) on Compiler {
	Parser<SStmtList> parser;
	parser.parse(expr, Url());
	if (parser.hasError())
		throw parser.error();

	SStmtList tree = parser.tree();

	VarList variables;
	Array<Int> results = tree.transform(variables);
	print("Results: ${results}");
}

void main() on Compiler {
	eval("a = 20, b = a - 10, a + b, a - b");
}
