// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use atk_sys;
use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use std::fmt;
use std::mem;
use CoordType;

glib_wrapper! {
    pub struct Image(Interface<atk_sys::AtkImage>);

    match fn {
        get_type => || atk_sys::atk_image_get_type(),
    }
}

pub const NONE_IMAGE: Option<&Image> = None;

pub trait AtkImageExt: 'static {
    fn get_image_description(&self) -> Option<GString>;

    fn get_image_locale(&self) -> Option<GString>;

    fn get_image_position(&self, coord_type: CoordType) -> (i32, i32);

    fn get_image_size(&self) -> (i32, i32);

    fn set_image_description(&self, description: &str) -> bool;
}

impl<O: IsA<Image>> AtkImageExt for O {
    fn get_image_description(&self) -> Option<GString> {
        unsafe {
            from_glib_none(atk_sys::atk_image_get_image_description(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_image_locale(&self) -> Option<GString> {
        unsafe {
            from_glib_none(atk_sys::atk_image_get_image_locale(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_image_position(&self, coord_type: CoordType) -> (i32, i32) {
        unsafe {
            let mut x = mem::uninitialized();
            let mut y = mem::uninitialized();
            atk_sys::atk_image_get_image_position(
                self.as_ref().to_glib_none().0,
                &mut x,
                &mut y,
                coord_type.to_glib(),
            );
            (x, y)
        }
    }

    fn get_image_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::uninitialized();
            let mut height = mem::uninitialized();
            atk_sys::atk_image_get_image_size(
                self.as_ref().to_glib_none().0,
                &mut width,
                &mut height,
            );
            (width, height)
        }
    }

    fn set_image_description(&self, description: &str) -> bool {
        unsafe {
            from_glib(atk_sys::atk_image_set_image_description(
                self.as_ref().to_glib_none().0,
                description.to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for Image {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Image")
    }
}
