#! /usr/bin/env perl

# Test removal of diacritic symbols:

use strict;
use warnings;
use utf8;

use lib 'lib';
use RestfulDB::Charman qw(remove_diacritics);

binmode( STDOUT, "utf8" );

my @cases = (
    "Sąžininga žąsis",
    "Saulius Gražulis",
    "Александр Иванович",
    "ÆæĲĳŒœ",
    "ÐĐðđĦħ",
    "ıĸĿŁŀł",
    "ŊŉŋØøſ",
    "ÞŦþŧ",
);

local $\ = "\n";

foreach my $value (@cases) {
    print remove_diacritics( $value );
}
