## RabbitMQ 3.6.11

RabbitMQ `3.6.11` is a maintenance release.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading)
for general documentation on upgrades.

⚠️ This release [changes how nodes compute the amount of RAM they use](https://groups.google.com/forum/#!topic/rabbitmq-users/TVZt45O3WzU) (and report). Previously the value was underreported.
We recommend monitoring — or at least manually sampling — the [RSS of
the Erlang VM](http://www.linfo.org/ps.html) running RabbitMQ, comparing it to the value reported in the management UI
to compute the delta. Then adjust configured [VM high memory watermark](https://www.rabbitmq.com/alarms.html) an
possibly provisioning more RAM as needed.

This release has no other known incompatibilities with versions 3.6.7 through 3.6.10.
See the upgrade and compatibility sections in the [3.6.7 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7) if upgrading from an earlier release.

⚠️  This is the first release that [supports Erlang/OTP 20](https://groups.google.com/forum/#!searchin/rabbitmq-users/OTP$2020%7Csort:relevance/rabbitmq-users/_imbAavBYjY/ninEKhMYAgAJ).


### Core Server

#### Bug Fixes

 * Node RAM consumption calculation strategy [has changed](https://groups.google.com/forum/#!topic/rabbitmq-users/TVZt45O3WzU)
   to a more precise one. Previously the value **was underreported**. It is possible to switch to the behavior in earlier versions
   if desired. This will **affect monitoring charts** and possibly **require bumping VM memory high watermark**
   or provisioning more RAM.

   GitHub issue: [rabbitmq-server#1223](https://github.com/rabbitmq/rabbitmq-server/issues/1223), [rabbitmq-server#1270](https://github.com/rabbitmq/rabbitmq-server/pull/1270)


 * Erlang/OTP 20 is [now supported](https://groups.google.com/forum/#!searchin/rabbitmq-users/OTP$2020%7Csort:relevance/rabbitmq-users/_imbAavBYjY/ninEKhMYAgAJ).

   GitHub issues: [rabbitmq-server#1243](https://github.com/rabbitmq/rabbitmq-server/issues/1243), [rabbitmq-server#1246](https://github.com/rabbitmq/rabbitmq-server/pull/1246), [rabbitmq-federation#58](https://github.com/rabbitmq/rabbitmq-federation/pull/58), [rabbitmq-management-agent#47](https://github.com/rabbitmq/rabbitmq-management-agent/pull/47), [rabbitmq-management#415](https://github.com/rabbitmq/rabbitmq-management/pull/415), [rabbitmq-stomp#115](https://github.com/rabbitmq/rabbitmq-stomp/issues/115)

 * `supervisor2`: supervisor could fail to restart failed child processes in some cases.
    This could affect multiple plugins, e.g. federation.

    Contributed by Aliaksey Artamonau (Couchbase).

   GitHub issues: [rabbitmq-common#201](https://github.com/rabbitmq/rabbitmq-common/pull/201),
                  [rabbitmq-server#1238](https://github.com/rabbitmq/rabbitmq-server/pull/1238)

 * Memory used by binary heap ("binaries") was reduced for some scenarios that involve mirrored queues.

   GitHub issue: [rabbitmq-common#208](https://github.com/rabbitmq/rabbitmq-common/issues/208)

 * Exclusive queues were not cleaned up when node failed or was considered unavailable by one of its
   peers.

   GitHub issue: [rabbitmq-server#1323](https://github.com/rabbitmq/rabbitmq-server/issues/1323)

 * `rabbitmq-service.bat start` and `rabbitmq-service.bat stop` did not report access violation
   errors.

   GitHub issue: [rabbitmq-server#1324](https://github.com/rabbitmq/rabbitmq-server/issues/1324)

 * When high VM memory watermarked is set to a value greater than 1.0,
   `1.0` will be used as effective value now instead of the default (`0.4`).

   GitHub issue: [rabbitmq-server#1285](https://github.com/rabbitmq/rabbitmq-server/issues/1285)

#### Enhancements

 * Total amount of RAM as seen by a node now can be overridden via config file.

   GitHub issue: [rabbitmq-server#1224](https://github.com/rabbitmq/rabbitmq-server/issues/1224)

 * Default value of `RABBITMQ_DISTRIBUTION_BUFFER_SIZE` is now `128000`. This makes inter-node communication
   throughput more stable on 1 GBbit/s (or greater) network links.

   GitHub issue: [rabbitmq-server#1306](https://github.com/rabbitmq/rabbitmq-server/issues/1306)

 * Plugins that are already expanded (unarhived from `.ez` archives on node boot) won't be
   expanded again.

   Contributed by Alex Lebedeff (Mirantis).

   GitHub issue: [rabbitmq-server#1226](https://github.com/rabbitmq/rabbitmq-server/pull/1226)


### Management plugin

#### Enhancements

 * Listing queues, exchanges, vhosts via HTTP API is now more efficient for common cases
   (e.g. when pagination is not used or only a subset of fields is requested).

   GitHub issue: [rabbitmq-management#402](https://github.com/rabbitmq/rabbitmq-management/issues/402)

 * Inter-node cluster link traffic information was missing.

   GitHub issue: [rabbitmq-management#434](https://github.com/rabbitmq/rabbitmq-management/issues/434)

 * Exclusive queues didn't have feature markers in the UI.

   GitHub issue: [rabbitmq-management#459](https://github.com/rabbitmq/rabbitmq-management/issues/459)

 * queue leader locator now has a feature marker in the UI.

   GitHub issue: [rabbitmq-management#468](https://github.com/rabbitmq/rabbitmq-management/pull/468)

 * It is now possible to pre-configure user permission at the time of its creation.

   GitHub issue: [rabbitmq-management#441](https://github.com/rabbitmq/rabbitmq-management/issues/441)

 * `rabbitmqadmin` now supports `--ssl-insecure` (`-k`), serving the same purpose as `-k` in curl

   GitHub issue: [rabbitmq-management#452](https://github.com/rabbitmq/rabbitmq-management/issues/452)

 * `rabbitmqadmin` now supports setting HTTP API endpoint hostname, port, username, and password
    using a URI.

    GitHub issue: [rabbitmq-management#437](https://github.com/rabbitmq/rabbitmq-management/issues/437)

 * HTTP API requests now are less likely to produce log noise.

    GitHub issue: [rabbitmq-web-dispatch#27](https://github.com/rabbitmq/rabbitmq-web-dispatch/issues/27)

#### Bug Fixes

  * queue leader migration no longer leaves statistics database records behind.

    GitHub issue: [rabbitmq-management#427](https://github.com/rabbitmq/rabbitmq-management/issues/427)

  * Consumer argument serialisation to JSON was fixed.

    GitHub issue: [rabbitmq-management#424](https://github.com/rabbitmq/rabbitmq-management/issues/424)

  * It is now again possible to create a user without a password (or password hash).
    Such users won't be able to sign in with [internal authentication backend](https://www.rabbitmq.com/access-control.html)
    but can be used with external authentication mechanisms (x509 certificates) and backends
    (LDAP, HTTP, etc).

    GitHib issue: [rabbitmq-management#383](https://github.com/rabbitmq/rabbitmq-management/issues/383)

  * Pagination combined with a user-provided set of columns returned no results.

    GitHub issue: [rabbitmq-management#404](https://github.com/rabbitmq/rabbitmq-management/issues/404)

  * Regular expressions used for filtering were not correctly escaped.

    GitHub issue: [rabbitmq-management#419](https://github.com/rabbitmq/rabbitmq-management/issues/419)

  * `rabbitmqadmin` now handles float rates.

    GitHub issue: [rabbitmq-management#457](https://github.com/rabbitmq/rabbitmq-management/issues/457)

  * `rabbitmqadmin` now ignores `SIGPIPE` signals and much less likely to terminate when its output is piped to
    another process.

    GitHub issue: [rabbitmq-management#438](https://github.com/rabbitmq/rabbitmq-management/issues/438)

  * HTTP requests with unintialised fields are less likely to crash log event handler.

    GitHub issue: [rabbitmq-web-dispatch#27](https://github.com/rabbitmq/rabbitmq-web-dispatch/issues/27)


### Federation Plugin

#### Bug Fixes

 * Federation links now recover better in certain scenarios, e.g. when one side of a link could be reset.

    GitHub issue: [rabbitmq-federation#59](https://github.com/rabbitmq/rabbitmq-federation/issues/59)


### STOMP Plugin

#### Bug Fixes

 * Erlang/OTP 20 is [now supported](https://groups.google.com/forum/#!searchin/rabbitmq-users/OTP$2020%7Csort:relevance/rabbitmq-users/_imbAavBYjY/ninEKhMYAgAJ).

   GitHub issue: [rabbitmq-stomp#115](https://github.com/rabbitmq/rabbitmq-stomp/issues/115)


### MQTT Plugin

#### Enhancements

 * No-op MQTT message retainer.

   GitHub issue: [rabbitmq-mqtt#136](https://github.com/rabbitmq/rabbitmq-mqtt/issues/136)

#### Bug Fixes

 * MQTT connection processes now use connection log level.

   GitHub issue: [rabbitmq-mqtt#142](https://github.com/rabbitmq/rabbitmq-mqtt/issues/142)


### Consistent Hashing Exchange

#### Bug Fixes

 * Bucket distribution is now consistent (doesn't change) between plugin and node restarts
   (assuming bindings haven't changed).

   GitHub issue: [rabbitmq-consistent-hash-exchange#32](https://github.com/rabbitmq/rabbitmq-consistent-hash-exchange/issues/32)


### Top Plugin

#### Bug Fixes

 * `rabbitmq-top` now gracefully covers scenarios when it is enabled only on a subset of cluster nodes.

   GitHub issue: [rabbitmq-top#23](https://github.com/rabbitmq/rabbitmq-top/issues/23)

 * Node drop down on ETS table tab redirected to the processes tab.

   GitHub issue: [rabbitmq-top#24](https://github.com/rabbitmq/rabbitmq-top/issues/24)


### Message Timestamp Plugin

#### Enhancements

  * Timestamp in milliseconds is also injected as a header (unless the header is present).

    GitHub issue: [rabbitmq-message-timestamp#16](https://github.com/rabbitmq/rabbitmq-message-timestamp/issues/16)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained.
When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.11.tar.gz`.
