% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest-auto.R
\name{unnest_auto}
\alias{unnest_auto}
\title{Automatically call \code{unnest_wider()} or \code{unnest_longer()}}
\usage{
unnest_auto(data, col)
}
\arguments{
\item{data}{A data frame.}

\item{col}{<\code{\link[=tidyr_tidy_select]{tidy-select}}> List-column to unnest.}
}
\description{
\code{unnest_auto()} picks between \code{unnest_wider()} or \code{unnest_longer()}
by inspecting the inner names of the list-col:
\itemize{
\item If all elements are unnamed, it uses
\code{unnest_longer(indices_include = FALSE)}.
\item If all elements are named, and there's at least one name in
common across all components, it uses \code{unnest_wider()}.
\item Otherwise, it falls back to \code{unnest_longer(indices_include = TRUE)}.
}

It's handy for very rapid interactive exploration but I don't recommend
using it in scripts, because it will succeed even if the underlying data
radically changes.
}
\keyword{internal}
