% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather.R
\name{gather}
\alias{gather}
\title{Gather columns into key-value pairs}
\usage{
gather(
  data,
  key = "key",
  value = "value",
  ...,
  na.rm = FALSE,
  convert = FALSE,
  factor_key = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{key, value}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:defusing-advanced]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{A selection of columns. If empty, all variables are
selected. You can supply bare variable names, select all
variables between x and z with \code{x:z}, exclude y with \code{-y}. For
more options, see the \code{\link[dplyr:select]{dplyr::select()}} documentation. See also
the section on selection rules below.}

\item{na.rm}{If \code{TRUE}, will remove rows from output where the
value column is \code{NA}.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link[=type.convert]{type.convert()}} on the key column. This is useful if the column
types are actually numeric, integer, or logical.}

\item{factor_key}{If \code{FALSE}, the default, the key values will be
stored as a character vector. If \code{TRUE}, will be stored as a factor,
which preserves the original ordering of the columns.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Development on \code{gather()} is complete, and for new code we recommend
switching to \code{pivot_longer()}, which is easier to use, more featureful, and
still under active development.
\code{df \%>\% gather("key", "value", x, y, z)} is equivalent to
\code{df \%>\% pivot_longer(c(x, y, z), names_to = "key", values_to = "value")}

See more details in \code{vignette("pivot")}.
}
\section{Rules for selection}{


Arguments for selecting columns are passed to \code{\link[tidyselect:vars_select]{tidyselect::vars_select()}}
and are treated specially. Unlike other verbs, selecting functions make a
strict distinction between data expressions and context expressions.
\itemize{
\item A data expression is either a bare name like \code{x} or an expression
like \code{x:y} or \code{c(x, y)}. In a data expression, you can only refer
to columns from the data frame.
\item Everything else is a context expression in which you can only
refer to objects that you have defined with \verb{<-}.
}

For instance, \code{col1:col3} is a data expression that refers to data
columns, while \code{seq(start, end)} is a context expression that
refers to objects from the contexts.

If you need to refer to contextual objects from a data expression, you can
use \code{all_of()} or \code{any_of()}. These functions are used to select
data-variables whose names are stored in a env-variable. For instance,
\code{all_of(a)} selects the variables listed in the character vector \code{a}.
For more details, see the \code{\link[tidyselect:language]{tidyselect::select_helpers()}} documentation.
}

\examples{
# From https://stackoverflow.com/questions/1181060
stocks <- tibble(
  time = as.Date("2009-01-01") + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)

gather(stocks, "stock", "price", -time)
stocks \%>\% gather("stock", "price", -time)

# get first observation for each Species in iris data -- base R
mini_iris <- iris[c(1, 51, 101), ]
# gather Sepal.Length, Sepal.Width, Petal.Length, Petal.Width
gather(mini_iris, key = "flower_att", value = "measurement",
       Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
# same result but less verbose
gather(mini_iris, key = "flower_att", value = "measurement", -Species)
}
