% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-condition.R
\name{capture_condition}
\alias{capture_condition}
\alias{capture_error}
\alias{capture_expectation}
\alias{capture_message}
\alias{capture_warning}
\alias{capture_messages}
\alias{capture_warnings}
\title{Capture conditions, including messages, warnings, expectations, and errors.}
\usage{
capture_condition(code, entrace = FALSE)

capture_error(code, entrace = FALSE)

capture_expectation(code, entrace = FALSE)

capture_message(code, entrace = FALSE)

capture_warning(code, entrace = FALSE)

capture_messages(code)

capture_warnings(code)
}
\arguments{
\item{code}{Code to evaluate}

\item{entrace}{Whether to add a \link[rlang:trace_back]{backtrace} to
the captured condition.}
}
\value{
Singular functions (\code{capture_condition}, \code{capture_expectation} etc)
return a condition object. \code{capture_messages()} and \code{capture_warnings}
return a character vector of message text.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#superseded'><img src='figures/lifecycle-superseded.svg' alt='Superseded lifecycle'></a>}}{\strong{Superseded}}

These functions allow you to capture the side-effects of a function call
including printed output, messages and warnings. We no longer recommend
that you use these functions, instead relying on the \code{\link[=expect_message]{expect_message()}}
and friends to bubble up unmatched conditions. If you just want to silence
unimportant warnings, use \code{\link[=suppressWarnings]{suppressWarnings()}}.
}
\examples{
f <- function() {
  message("First")
  warning("Second")
  message("Third")
}

capture_message(f())
capture_messages(f())

capture_warning(f())
capture_warnings(f())

# Condition will capture anything
capture_condition(f())
}
\keyword{internal}
