% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svy_median.R, R/wtd_cor.R, R/wtd_se.R
\name{survey_median}
\alias{survey_median}
\alias{weighted_correlation}
\alias{weighted_correlation.default}
\alias{weighted_correlation.formula}
\alias{weighted_se}
\title{Weighted statistics for variables}
\usage{
survey_median(x, design)

weighted_correlation(data, ...)

\method{weighted_correlation}{default}(data, x, y, weights, ci.lvl = 0.95, ...)

\method{weighted_correlation}{formula}(formula, data, ci.lvl = 0.95, ...)

weighted_se(x, weights = NULL)
}
\arguments{
\item{x}{(Numeric) vector or a data frame. For \code{survey_median()} or \code{weighted_ttest()},
the bare (unquoted) variable name, or a character vector with the variable name.}

\item{design}{An object of class \code{\link[survey]{svydesign}}, providing
a specification of the survey design.}

\item{data}{A data frame.}

\item{...}{Currently not used.}

\item{y}{Optional, bare (unquoted) variable name, or a character vector with
the variable name.}

\item{weights}{Bare (unquoted) variable name, or a character vector with
the variable name of the numeric vector of weights. If \code{weights = NULL},
unweighted statistic is reported.}

\item{ci.lvl}{Confidence level of the interval.}

\item{formula}{A formula of the form \code{lhs ~ rhs1 + rhs2} where \code{lhs} is a
numeric variable giving the data values and \code{rhs1} a factor with two
levels giving the corresponding groups and \code{rhs2} a variable with weights.}
}
\value{
The weighted (test) statistic.
}
\description{
\code{weighted_se()} computes weighted standard errors of a variable or for
all variables of a data frame. \code{survey_median()} computes the median for
a variable in a survey-design (see [\verb{survey::svydesign()]}).
\code{weighted_correlation()} computes a weighted correlation for a two-sided
alternative hypothesis.
}
\examples{
\dontshow{if (requireNamespace("survey")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(efc)
weighted_se(efc$c12hour, abs(runif(n = nrow(efc))))

# survey_median ----
# median for variables from weighted survey designs
data(nhanes_sample)

des <- survey::svydesign(
  id = ~SDMVPSU,
  strat = ~SDMVSTRA,
  weights = ~WTINT2YR,
  nest = TRUE,
  data = nhanes_sample
)
survey_median(total, des)
survey_median("total", des)
\dontshow{\}) # examplesIf}
}
