% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{SetQuantile}
\alias{SetQuantile}
\title{Find the Quantile of Data}
\usage{
SetQuantile(cutoff, data)
}
\arguments{
\item{cutoff}{The cutoff to turn into a quantile}

\item{data}{The data to turn find the quantile of}
}
\value{
The numerical representation of the quantile
}
\description{
Converts a quantile in character form to a number regarding some data.
String form for a quantile is represented as a number prefixed with
\dQuote{q}; for example, 10th quantile is \dQuote{q10} while 2nd quantile is
\dQuote{q2}. Will only take a quantile of non-zero data values
}
\examples{
set.seed(42)
SetQuantile('q10', sample(1:100, 10))

}
\concept{utilities}
