% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinLoss.R
\name{pinLoss}
\alias{pinLoss}
\title{Pinball loss function}
\usage{
pinLoss(y, mu, qu, add = TRUE)
}
\arguments{
\item{y}{points at which the loss is evaluated.}

\item{mu}{location parameter of the pinball loss.}

\item{qu}{quantile level of the loss.}

\item{add}{if TRUE the losses at which quantile level will be added up.}
}
\value{
A numeric vector or matrix of evaluate losses.
}
\description{
Evaluates the pinball loss.
}
\examples{
n <- 1000
x <- seq(0, 4, length.out = n)
plot(x, pinLoss(x, rep(2, n), qu = 0.9, add = FALSE), type = 'l', ylab = "loss")

}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>.
}
