% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-factor.R
\name{rvar_factor}
\alias{rvar_factor}
\alias{rvar_ordered}
\title{Factor random variables of arbitrary dimension}
\usage{
rvar_factor(
  x = factor(),
  dim = NULL,
  dimnames = NULL,
  nchains = NULL,
  with_chains = FALSE,
  ...
)

rvar_ordered(
  x = ordered(NULL),
  dim = NULL,
  dimnames = NULL,
  nchains = NULL,
  with_chains = FALSE,
  ...
)
}
\arguments{
\item{x}{(multiple options) The object to convert to an \code{rvar}:
\itemize{
\item A vector of draws from a distribution.
\item An array where the first dimension represents draws from a distribution.
The resulting \code{\link{rvar}} will have dimension \code{dim(x)[-1]}; that is,
everything except the first dimension is used for the shape of the
variable, and the first dimension is used to index draws from the
distribution (see \strong{Examples}). Optionally,
if \code{with_chains == TRUE}, the first dimension indexes the iteration and the
second dimension indexes the chain (see \code{with_chains}).
\item An \code{rvar}.
}}

\item{dim}{(integer vector) One or more integers giving the maximal indices
in each dimension to override the dimensions of the \code{\link{rvar}} to be created
(see \code{\link[=dim]{dim()}}). If \code{NULL} (the default), \code{dim} is determined by the input.
\strong{NOTE:} This argument controls the dimensions of the \code{\link{rvar}}, not the
underlying array, so you cannot change the number of draws using this
argument.}

\item{dimnames}{(list) Character vectors giving the names in each dimension
to override the names of the dimensions of the \code{\link{rvar}} to be created (see
\code{\link[=dimnames]{dimnames()}}). If \code{NULL} (the default), this is determined by the input.
\strong{NOTE:} This argument controls the names of the dimensions of the
\code{\link{rvar}}, not the underlying array.}

\item{nchains}{(positive integer) The number of chains. The if \code{NULL} (the default),
\code{1} is used unless \code{x} is already an \code{\link{rvar}}, in which case the number of
chains it has is used.}

\item{with_chains}{(logical) Does \code{x} include a dimension for chains?
If \code{FALSE} (the default), chains are not included, the first dimension of
the input array should index draws, and the \code{nchains} argument can be
used to determine the number of chains. If \code{TRUE}, the \code{nchains} argument
is ignored and the second dimension of \code{x} is used to index chains.
Internally, the array will be converted to a format without the chain index.
Ignored when \code{x} is already an \code{\link{rvar}}.}

\item{...}{
  Arguments passed on to \code{\link[base:factor]{base::factor}}
  \describe{
    \item{\code{levels}}{an optional vector of the unique values (as character strings)
    that \code{x} might have taken.  The default is the unique set of
    values taken by \code{\link[base]{as.character}(x)}, sorted into
    increasing order \emph{of \code{x}}.  Note that this set can be
    specified as smaller than \code{sort(unique(x))}.}
    \item{\code{labels}}{\emph{either} an optional character vector of
    labels for the levels (in the same order as \code{levels} after
    removing those in \code{exclude}), \emph{or} a character string of
    length 1.  Duplicated values in \code{labels} can be used to map
    different values of \code{x} to the same factor level.}
    \item{\code{exclude}}{a vector of values to be excluded when forming the
    set of levels.  This may be factor with the same level set as \code{x}
    or should be a \code{character}.}
    \item{\code{ordered}}{logical flag to determine if the levels should be regarded
    as ordered (in the order given).}
    \item{\code{nmax}}{an upper bound on the number of levels; see \sQuote{Details}.}
  }}
}
\value{
An object of class \code{"rvar_factor"} representing a \code{factor}-like random variable.
}
\description{
Random variables backed by \link{factor}-like arrays of arbitrary dimension.
}
\details{
A subtype of \code{\link[=rvar]{rvar()}} that represents a (possibly multidimensional) sample of
a \link{factor} or an \link{ordered} factor. It is otherwise very similar to the basic \code{\link[=rvar]{rvar()}}:
it is backed by a multidimensional array with draws as the first dimension.
The primary difference is that the backing array has class \code{"factor"} (for \code{\link[=rvar_factor]{rvar_factor()}})
or \code{c("ordered", "factor")} (for \code{\link[=rvar_ordered]{rvar_ordered()}}). If you
pass a \link{factor} or \link{ordered} factor to \code{\link[=rvar]{rvar()}} it will automatically return
an object with the classes \code{"rvar_factor"} or \code{c("rvar_ordered", "rvar_factor")}.

See \code{\link[=rvar]{rvar()}} for more details on the internals of the random variable datatype.
}
\examples{
set.seed(1234)

# To create a "scalar" `rvar_factor`, pass a one-dimensional array or a vector
# whose length (here `4000`) is the desired number of draws:
x <- rvar(sample(c("a","a","a","b","c"), 4000, replace = TRUE))
x

# Create random vectors by adding an additional dimension:
x_array <- array(c(
    sample(c("a","a","a","b","c"), 4000, replace = TRUE),
    sample(c("a","a","b","c","c"), 4000, replace = TRUE),
    sample(c("b","b","b","b","c"), 4000, replace = TRUE),
    sample(c("d","d","b","b","c"), 4000, replace = TRUE)
  ), dim = c(4000, 4))
rvar_factor(x_array)

# You can also create ordered factors
rvar_ordered(x_array)

# arguments of factor() and ordered() are passed down by the constructor
# e.g. we can reorder levels of an ordered factor:
rvar_ordered(x_array, levels = c("d","c","b","a"))

# Unlike base factors, rvar factors can be matrices or arrays:
rvar_factor(x_array, dim = c(2, 2))

# If the input to rvar_factor() is an array with a `"levels"` attribute, it
# will use those as the levels of the factor
y_array <- t(array(rbinom(3000, 1, c(0.1, 0.5, 0.9)) + 1, dim = c(3, 1000)))
rvar(y_array)
# with levels
attr(y_array, "levels") = c("a", "b")
rvar_factor(y_array)

}
\seealso{
\code{\link[=as_rvar_factor]{as_rvar_factor()}} to convert objects to \code{rvar_factor}s. See \code{\link[=rdo]{rdo()}}, \code{\link[=rfun]{rfun()}}, and
\code{\link[=rvar_rng]{rvar_rng()}} for higher-level interfaces for creating \code{rvar}s.
}
