% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_docs_callback}
\alias{pr_set_docs_callback}
\title{Set the \code{callback} to tell where the API visual documentation is located}
\usage{
pr_set_docs_callback(pr, callback = getOption("plumber.docs.callback", NULL))
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{callback}{a callback function for taking action on the docs url.}
}
\value{
The Plumber router with the new docs callback setting.
}
\description{
When set, it will be called with a character string corresponding
to the API visual documentation url. This allows RStudio to open \code{swagger} docs when a
Plumber router \code{\link[=pr_run]{pr_run()}} method.
}
\details{
If using \code{\link[=options_plumber]{options_plumber()}}, the value must be set before initializing your Plumber router.
}
\examples{
\dontrun{
pr() \%>\%
  pr_set_docs_callback(function(url) { message("API location: ", url) }) \%>\%
  pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
  pr_run()
}
}
