% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_mice.R
\name{model_parameters.mira}
\alias{model_parameters.mira}
\title{Parameters from multiply imputed repeated analyses}
\usage{
\method{model_parameters}{mira}(
  model,
  ci = 0.95,
  exponentiate = FALSE,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{An object of class \code{mira}.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the the coefficients (and related confidence intervals). This is typical for, say, logistic regressions, or more generally speaking: for models with log or logit link. \strong{Note:} standard errors are also transformed (by multiplying the standard errors with the exponentiated coefficients), to mimic behaviour of other software packages, such as Stata.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to adjust p-values. See \code{\link[stats]{p.adjust}} for details.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Format models of class \code{mira}, obtained from \code{mice::width.mids()}.
}
\details{
\code{model_parameters()} for objects of class \code{mira} works
  similar to \code{summary(mice::pool())}, i.e. it generates the pooled summary
  of multiple imputed repeated regression analyses.
}
\examples{
library(parameters)
if (require("mice")) {
  data(nhanes2)
  imp <- mice(nhanes2)
  fit <- with(data = imp, exp = lm(bmi ~ age + hyp + chl))
  model_parameters(fit)
}
\dontrun{
# model_parameters() also works for models that have no "tidy"-method in mice
if (require("mice") && require("gee")) {
  data(warpbreaks)
  set.seed(1234)
  warpbreaks$tension[sample(1:nrow(warpbreaks), size = 10)] <- NA
  imp <- mice(warpbreaks)
  fit <- with(data = imp, expr = gee(breaks ~ tension, id = wool))

  # does not work:
  # summary(pool(fit))

  model_parameters(fit)
}
}



# and it works with pooled results
if (require("mice")) {
  data("nhanes2")
  imp <- mice(nhanes2)
  fit <- with(data = imp, exp = lm(bmi ~ age + hyp + chl))
  pooled <- pool(fit)

  model_parameters(pooled)
}
}
