% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.mpoly.R
\name{print.mpoly}
\alias{print.mpoly}
\title{Pretty printing of multivariate polynomials.}
\usage{
\method{print}{mpoly}(x, varorder, order, stars = FALSE, silent =
  FALSE, ..., plus_pad = 2L, times_pad = 1L)
}
\arguments{
\item{x}{an object of class mpoly}

\item{varorder}{the order of the variables}

\item{order}{a total order used to order the monomials in the printing}

\item{stars}{print the multivariate polynomial in the more computer-friendly
asterisk notation (default FALSE)}

\item{silent}{logical; if TRUE, suppresses output}

\item{...}{additional parameters to go to \code{\link[base:cat]{base::cat()}}}

\item{plus_pad}{number of spaces to the left and right of plus sign}

\item{times_pad}{number of spaces to the left and right of times sign}
}
\value{
Invisible string of the printed object.
}
\description{
This is the major function used to view multivariate polynomials.
}
\examples{

mp("-x^5 - 3 y^2 + x y^3 - 1")


(p <- mp("2 x^5  -  3 y^2  +  x y^3"))
print(p) # same
print(p, silent = TRUE)
s <- print(p, silent = TRUE)
s

print(p, order = "lex") # -> 2 x^5  +  x y^3  -  3 y^2
print(p, order = "lex", varorder = c("y","x")) # -> y^3 x  -  3 y^2  +  2 x^5
print(p, varorder = c("y","x")) # -> y^3 x  -  3 y^2  +  2 x^5

# this is mostly used internally
print(p, stars = TRUE)
print(p, stars = TRUE, times_pad = 0L)
print(p, stars = TRUE, times_pad = 0L, plus_pad = 1L)
print(p, stars = TRUE, times_pad = 0L, plus_pad = 0L)
print(p, plus_pad = 1L)

}
