% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{testing_fromlog}
\alias{testing_fromlog}
\title{Test configurations given in \code{.Rdata} file}
\usage{
testing_fromlog(
  logFile,
  testNbElites,
  testIterationElites,
  testInstancesDir,
  testInstancesFile,
  testInstances
)
}
\arguments{
\item{logFile}{Path to the \code{.Rdata} file produced by \pkg{irace}.}

\item{testNbElites}{Number of (final) elite configurations to test. Overrides
the value found in \code{logFile}.}

\item{testIterationElites}{(\code{logical(1)}) If \code{FALSE}, only the final
\code{testNbElites} configurations are tested; otherwise, also test the best
configurations of each iteration. Overrides the value found in \code{logFile}.}

\item{testInstancesDir}{Directory where testing instances are located, either absolute or relative to current directory.}

\item{testInstancesFile}{File containing a list of test instances and optionally additional parameters for them.}

\item{testInstances}{Character vector of the instances to be used in the \code{targetRunner} when executing the testing.}
}
\value{
Boolean. \code{TRUE} if the testing ended successfully otherwise, \code{FALSE}.
}
\description{
\code{testing_fromlog} executes the testing of the target algorithm configurations
found by an \pkg{irace} execution.
}
\details{
The function \code{testing_fromlog} loads the \code{logFile} and obtains the
testing setup and configurations to be tested.  Within the \code{logFile}, the
variable \code{scenario$testNbElites} specifies how many final elite
configurations to test and \code{scenario$testIterationElites} indicates
whether test the best configuration of each iteration. The values may be
overridden by setting the corresponding arguments in this function.  The
set of testing instances must appear in \code{scenario[["testInstances"]]}.
}
\seealso{
\code{\link[=defaultScenario]{defaultScenario()}} to provide a default scenario for \pkg{irace}.
\code{\link[=testing_fromfile]{testing_fromfile()}} provides a different interface for testing.
}
\author{
Manuel López-Ibáñez and Leslie Pérez Cáceres
}
\concept{running}
