% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googledrive-package.R, R/utils-ui.R
\name{googledrive-configuration}
\alias{googledrive-configuration}
\alias{local_drive_quiet}
\alias{with_drive_quiet}
\title{googledrive configuration}
\usage{
local_drive_quiet(env = parent.frame())

with_drive_quiet(code)
}
\arguments{
\item{env}{The environment to use for scoping}

\item{code}{Code to execute quietly}
}
\description{
Some aspects of googledrive behaviour can be controlled via an option.
}
\section{Auth}{


Read about googledrive's main auth function, \code{\link[=drive_auth]{drive_auth()}}. It is powered
by the gargle package, which consults several options:
\itemize{
\item Default Google user or, more precisely, \code{email}: see
\code{\link[gargle:gargle_options]{gargle::gargle_oauth_email()}}
\item Whether or where to cache OAuth tokens: see
\code{\link[gargle:gargle_options]{gargle::gargle_oauth_cache()}}
\item Whether to prefer "out-of-band" auth: see
\code{\link[gargle:gargle_options]{gargle::gargle_oob_default()}}
\item Application Default Credentials: see \code{\link[gargle:credentials_app_default]{gargle::credentials_app_default()}}
}
}

\section{Messages}{


The \code{googledrive_quiet} option can be used to suppress messages from
googledrive. By default, googledrive always messages, i.e. it is \emph{not}
quiet.

Set \code{googledrive_quiet} to \code{TRUE} to suppress messages, by one of these
means, in order of decreasing scope:
\itemize{
\item Put \code{options(googledrive_quiet = TRUE)} in a start-up file, such as
\code{.Rprofile}, or at the top of your R script
\item Use \code{local_drive_quiet()} to silence googledrive in a specific scope\preformatted{foo <- function() \{
  ...
  local_drive_quiet()
  drive_this(...)
  drive_that(...)
  ...
\}
}
\item Use \code{with_drive_quiet()} to run a small bit of code silently\preformatted{with_drive_quiet(
  drive_something(...)
)
}
}

\code{local_drive_quiet()} and \code{with_drive_quiet()} follow the conventions of the
the withr package (\url{https://withr.r-lib.org}).
}

\examples{
\dontshow{if (drive_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# message: "Created Drive file"
(x <- drive_create("drive-quiet-demo", type = "document"))

# message: "File updated"
x <- drive_update(x, starred = TRUE)
drive_reveal(x, "starred")

# suppress messages for a small amount of code
with_drive_quiet(
  x <- drive_update(x, name = "drive-quiet-works")
)
x$name

# message: "File updated"
x <- drive_update(x, media = drive_example_local("chicken.txt"))

# suppress messages within a specific scope, e.g. function
unstar <- function(y) {
  local_drive_quiet()
  drive_update(y, starred = FALSE)
}
x <- unstar(x)
drive_reveal(x, "starred")

# clean up
drive_rm(x)
\dontshow{\}) # examplesIf}
}
