% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxpath.R
\name{cox.fit}
\alias{cox.fit}
\title{Fit a Cox regression model with elastic net regularization for a single
value of lambda}
\usage{
cox.fit(
  x,
  y,
  weights,
  lambda,
  alpha = 1,
  offset = rep(0, nobs),
  thresh = 1e-10,
  maxit = 1e+05,
  penalty.factor = rep(1, nvars),
  exclude = c(),
  lower.limits = -Inf,
  upper.limits = Inf,
  warm = NULL,
  from.cox.path = FALSE,
  save.fit = FALSE,
  trace.it = 0
)
}
\arguments{
\item{x}{Input matrix, of dimension \code{nobs x nvars}; each row is an
observation vector. If it is a sparse matrix, it is assumed to be unstandardized.
It should have attributes \code{xm} and \code{xs}, where \code{xm(j)} and
\code{xs(j)} are the centering and scaling factors for variable j respsectively.
If it is not a sparse matrix, it is assumed that any standardization needed
has already been done.}

\item{y}{Survival response variable, must be a Surv or stratifySurv object.}

\item{weights}{Observation weights. \code{cox.fit} does NOT standardize
these weights.}

\item{lambda}{A single value for the \code{lambda} hyperparameter.}

\item{alpha}{See glmnet help file}

\item{offset}{See glmnet help file}

\item{thresh}{Convergence threshold for coordinate descent. Each inner
coordinate-descent loop continues until the maximum change in the objective
after any coefficient update is less than thresh times the null deviance.
Default value is \code{1e-10}.}

\item{maxit}{Maximum number of passes over the data; default is \code{10^5}.
(If a warm start object is provided, the number of passes the warm start object
performed is included.)}

\item{penalty.factor}{See glmnet help file}

\item{exclude}{See glmnet help file}

\item{lower.limits}{See glmnet help file}

\item{upper.limits}{See glmnet help file}

\item{warm}{Either a \code{glmnetfit} object or a list (with name \code{beta}
containing coefficients) which can be used as a warm start. Default is
\code{NULL}, indicating no warm start. For internal use only.}

\item{from.cox.path}{Was \code{cox.fit()} called from \code{cox.path()}?
Default is FALSE.This has implications for computation of the penalty factors.}

\item{save.fit}{Return the warm start object? Default is FALSE.}

\item{trace.it}{Controls how much information is printed to screen. If
\code{trace.it=2}, some information about the fitting procedure is printed to
the console as the model is being fitted. Default is \code{trace.it=0}
(no information printed). (\code{trace.it=1} not used for compatibility with
\code{glmnet.path}.)}
}
\value{
An object with class "coxnet", "glmnetfit" and "glmnet". The list
returned contains more keys than that of a "glmnet" object.
\item{a0}{Intercept value, \code{NULL} for "cox" family.}
\item{beta}{A \code{nvars x 1} matrix of coefficients, stored in sparse matrix
format.}
\item{df}{The number of nonzero coefficients.}
\item{dim}{Dimension of coefficient matrix.}
\item{lambda}{Lambda value used.}
\item{dev.ratio}{The fraction of (null) deviance explained. The deviance
calculations incorporate weights if present in the model. The deviance is
defined to be 2*(loglike_sat - loglike), where loglike_sat is the log-likelihood
for the saturated model (a model with a free parameter per observation).
Hence dev.ratio=1-dev/nulldev.}
\item{nulldev}{Null deviance (per observation). This is defined to be
2*(loglike_sat -loglike(Null)). The null model refers to the 0 model.}
\item{npasses}{Total passes over the data.}
\item{jerr}{Error flag, for warnings and errors (largely for internal
debugging).}
\item{offset}{A logical variable indicating whether an offset was included
in the model.}
\item{call}{The call that produced this object.}
\item{nobs}{Number of observations.}
\item{warm_fit}{If \code{save.fit=TRUE}, output of C++ routine, used for
warm starts. For internal use only.}
\item{family}{Family used for the model, always "cox".}
\item{converged}{A logical variable: was the algorithm judged to have
converged?}
\item{boundary}{A logical variable: is the fitted value on the boundary of
the attainable values?}
\item{obj_function}{Objective function value at the solution.}
}
\description{
Fit a Cox regression model via penalized maximum likelihood for a single
value of lambda. Can deal with (start, stop] data and strata, as well as
sparse design matrices.
}
\details{
WARNING: Users should not call \code{cox.fit} directly. Higher-level
functions in this package call \code{cox.fit} as a subroutine. If a
warm start object is provided, some of the other arguments in the function
may be overriden.

\code{cox.fit} solves the elastic net problem for a single, user-specified
value of lambda. \code{cox.fit} works for Cox regression models, including
(start, stop] data and strata. It solves the problem using iteratively
reweighted least squares (IRLS). For each IRLS iteration, \code{cox.fit}
makes a quadratic (Newton) approximation of the log-likelihood, then calls
\code{elnet.fit} to minimize the resulting approximation.

In terms of standardization: \code{cox.fit} does not standardize \code{x}
and \code{weights}. \code{penalty.factor} is standardized so that they sum
up to \code{nvars}.
}
