% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.R
\name{percent_rank}
\alias{percent_rank}
\alias{cume_dist}
\title{Proportional ranking functions}
\usage{
percent_rank(x)

cume_dist(x)
}
\arguments{
\item{x}{A vector to rank

By default, the smallest values will get the smallest ranks. Use \code{\link[=desc]{desc()}}
to reverse the direction so the largest values get the smallest ranks.

Missing values will be given rank \code{NA}. Use \code{coalesce(x, Inf)} or
\code{coalesce(x, -Inf)} if you want to treat them as the largest or smallest
values respectively.

To rank by multiple columns at once, supply a data frame.}
}
\value{
A numeric vector containing a proportion.
}
\description{
These two ranking functions implement two slightly different ways to
compute a percentile. For each \code{x_i} in \code{x}:
\itemize{
\item \code{cume_dist(x)} counts the total number of values less than
or equal to \code{x_i}, and divides it by the number of observations.
\item \code{percent_rank(x)} counts the total number of values less than
\code{x_i}, and divides it by the number of observations minus 1.
}

In both cases, missing values are ignored when counting the number
of observations.
}
\examples{
x <- c(5, 1, 3, 2, 2)

cume_dist(x)
percent_rank(x)

# You can understand what's going on by computing it by hand
sapply(x, function(xi) sum(x <= xi) / length(x))
sapply(x, function(xi) sum(x < xi)  / (length(x) - 1))
# The real computations are a little more complex in order to
# correctly deal with missing values
}
\seealso{
Other ranking functions: 
\code{\link{ntile}()},
\code{\link{row_number}()}
}
\concept{ranking functions}
