% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash_sha1}
\alias{hash_sha1}
\alias{hash_raw_sha1}
\alias{hash_obj_sha1}
\alias{hash_file_sha1}
\title{SHA-1 hash}
\usage{
hash_sha1(x)

hash_raw_sha1(x)

hash_obj_sha1(x, serialize_version = 2)

hash_file_sha1(paths)
}
\arguments{
\item{x}{Character vector. If not a character vector, then
\code{\link[=as.character]{as.character()}} is used to try to coerce it into one. \code{NA} entries
will have an \code{NA} hash.}

\item{serialize_version}{Workspace format version to use, see
\code{\link[base:serialize]{base::serialize()}}.}

\item{paths}{Character vector of file names.}
}
\value{
\code{hash_sha1()} returns aharacter vector of hexadecimal
SHA-1 hashes.

\code{hash_raw_sha1()} returns a character scalar.

\code{hash_obj_sha1()} returns a character scalar.

\code{hash_file_sha1()} returns a character vector of SHA-1
hashes.
}
\description{
Calculate the SHA-1 hash of each element of a character vector.
}
\details{
\code{hash_raw_sha1()} calculates the SHA-1 hash of the bytes
of a raw vector.

\code{hash_obj_sha1()} calculates the SHA-1 hash of an R
object. The object is serialized into a binary vector first.

\code{hash_file_sha1()} calculates the SHA-1 hash of one or
more files.
}
\examples{
hash_sha1(c("foo", NA, "bar", ""))
}
\seealso{
Other hash functions: 
\code{\link{hash_animal}()},
\code{\link{hash_emoji}()},
\code{\link{hash_md5}()},
\code{\link{hash_sha256}()}
}
\concept{hash functions}
