% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_nchar}
\alias{ansi_nchar}
\title{Count number of characters in an ANSI colored string}
\usage{
ansi_nchar(x, type = c("chars", "bytes", "width"), ...)
}
\arguments{
\item{x}{Character vector, potentially ANSO styled, or a vector to be
coarced to character.}

\item{type}{Whether to count characters, bytes, or calculate the
display width of the string. Passed to \code{\link[base:nchar]{base::nchar()}}.}

\item{...}{Additional arguments, passed on to \code{\link[base:nchar]{base::nchar()}}
after removing ANSI escape sequences.}
}
\value{
Numeric vector, the length of the strings in the character
vector.
}
\description{
This is a color-aware counterpart of \code{\link[base:nchar]{base::nchar()}},
which does not do well, since it also counts the ANSI control
characters.
}
\examples{
str <- paste(
  col_red("red"),
  "default",
  col_green("green")
)

cat(str, "\n")
nchar(str)
ansi_nchar(str)
nchar(ansi_strip(str))
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
