% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\name{readRcc}
\alias{readRcc}
\title{Read an .RCC file}
\usage{
readRcc(rcc, removeSpikeInLabels = TRUE)
}
\arguments{
\item{rcc}{Path to the .RCC file.}

\item{removeSpikeInLabels}{Logical. If TRUE (the default), RNA \dQuote{spike-in} input labels (if any)
in the GeneName for positive and negative control probes will be removed.}
}
\value{
A list where each element holds the contents of one part of the .RCC file
(Header, Sample_Attributes, Lane_Attributes, Code_Summary, etc) as a
vector or data frame.
}
\description{
Parse an .RCC file into a list with each part of the file (Header,
                Sample_Attributes, Lane_Attributes, Code_Summary, etc) stored as a vector
                or data frame.
}
\examples{
rcc <- system.file("extdata", "RCC", "20140604_C1-unstim_C1-unstim_01.RCC", package="NanoStringQCPro")
rcc.ls <- readRcc(rcc)

}
\author{
Robert Ziman
}
