% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitTimeSeries.R
\name{fitMultipleTimeSeries}
\alias{fitMultipleTimeSeries}
\title{Discover differentially abundant time intervals for all bacteria}
\usage{
fitMultipleTimeSeries(obj, lvl = NULL, B = 1, featureOrder = NULL, ...)
}
\arguments{
\item{obj}{metagenomeSeq MRexperiment-class object.}

\item{lvl}{Vector or name of column in featureData of MRexperiment-class object for aggregating counts (if not OTU level).}

\item{B}{Number of permutations to perform.}

\item{featureOrder}{Hierarchy of levels in taxonomy as fData colnames}

\item{...}{Options for \code{\link{fitTimeSeries}}, except feature.}
}
\value{
List of lists of matrices of time point intervals of interest, Difference in abundance area and p-value, fit, area permutations.

A list of lists for which each includes:
\itemize{
 \item{timeIntervals - Matrix of time point intervals of interest, area of differential abundance, and pvalue.}
 \item{data  - Data frame of abundance, class indicator, time, and id input.}
 \item{fit - Data frame of fitted values of the difference in abundance, standard error estimates and timepoints interpolated over.}
 \item{perm - Differential abundance area estimates for each permutation.}
 \item{call - Function call.}
}
}
\description{
Calculate time intervals of significant differential abundance over all
bacteria of a particularly specified level (lvl). If not lvl is specified,
all OTUs are analyzed. Warning, function can take a while
}
\examples{

data(mouseData)
res = fitMultipleTimeSeries(obj=mouseData,lvl='phylum',class="status",
          id="mouseID",time="relativeTime",B=1)

}
\seealso{
\code{\link{cumNorm}} \code{\link{fitSSTimeSeries}} \code{\link{fitTimeSeries}}
}
