% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startUpload.R
\name{startUpload}
\alias{startUpload}
\title{Start an upload}
\usage{
startUpload(
  project,
  asset,
  version,
  files,
  links = NULL,
  deduplicate = TRUE,
  probation = FALSE,
  url = restUrl(),
  token = accessToken(),
  directory = NULL
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.
This should not contain \code{/} or start with \code{..}.}

\item{version}{String containing the version name.
This should not contain \code{/} or start with \code{..}.}

\item{files}{Character vector containing the paths of the files to be uploaded.
These should be relative to the version's \code{directory}. 

Alternatively, a data frame where each row corresponds to a file and contains information about those files.
This data frame should contain the following fields:
\itemize{
\item \code{path}, a string containing the relative path of the file inside the version's subdirectory.
\item \code{size}, a non-negative integer specifying the size of the file in bytes.
\item \code{md5sum}, a string containing the hex-encoded MD5 checksum of the file.
\item (optional) \code{dedup}, a logical indicating whether deduplication should be attempted for each file.
}}

\item{links}{A data frame where each row corresponds to a linked-from file and contains the link destination for that file.
This data frame should contain the following fields:
\itemize{
\item \code{from.path}, a string containing the relative path of the file inside the version's subdirectory.
\item \code{to.project}, a string containing the project of the list destination.
\item \code{to.asset}, a string containing the asset of the list destination.
\item \code{to.version}, a string containing the version of the list destination.
\item \code{to.path}, a string containing the path of the list destination.
}}

\item{deduplicate}{Logical scalar indicating whether the backend should attempt deduplication of \code{files} in the immediately previous version.
Only has an effect if \code{files} is not a data frame or if the \code{dedup} field is missing.}

\item{probation}{Logical scalar indicating whether to perform a probational upload.
Such uploads must be approved by the project owner before they are considered official.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to a user that is authorized to upload to the specified \code{project}.}

\item{directory}{String containing the path to a directory containing the \code{files} to be uploaded.
This directory is assumed to correspond to a version of an asset.
It only has an effect if \code{files} is a character vector, as it is used to determine the MD5 checksums and sizes.
If \code{NULL}, \code{directory} is set to the current working directory.}
}
\value{
List containing:
\itemize{
\item \code{file_urls}, a list of lists containing information about each file to be uploaded.
This is used by \code{\link{uploadFiles}}.
\item \code{complete_url}, a string containing the completion URL, to be used by \code{\link{completeUpload}}.
\item \code{abort_url}, a string specifying the abort URL, to be used by \code{\link{abortUpload}}.
\item \code{session_token}, a string for authenticating to the newly initialized upload session.
}
}
\description{
Start an upload of a new version of an asset, or a new asset of a project.
}
\examples{
tmp <- tempfile()
dir.create(tmp)
write(file=file.path(tmp, "blah.txt"), LETTERS)
dir.create(file.path(tmp, "foo"))
write(file=file.path(tmp, "foo", "bar.txt"), 1:10)

if (interactive()) {
    blob <- startUpload(
        project="test-R", 
        asset="upload-start-check", 
        version="v1", 
        files=list.files(tmp, recursive=TRUE),
        directory=tmp
    )
    print(blob)

    abortUpload(blob) # just cleaning up after we're done.
}

}
\seealso{
\code{\link{uploadFiles}}, to actually upload the files.

\code{\link{completeUpload}}, to indicate that the upload is completed.

\code{\link{abortUpload}}, to abort an upload in progress.

\code{\link{prepareDirectoryUpload}}, to create \code{files} and \code{links} from a directory.
}
\author{
Aaron Lun
}
