# Contributing

## Developer guide

A [complete developer guide](https://docs.qgis.org/latest/en/docs/developers_guide/index.html) is also available to explain the development process, the unit testing system and more!

You may also want to consult the build process for QGIS which is fully detailed in the [install guide](INSTALL.md).

## Bug reporting and bug fixing

You can help us **by submitting bug reports or fixing bugs** in the [QGIS bug tracker](https://github.com/qgis/QGIS/issues/).

## New features and enhancements

If you wish to contribute patches you can:

1. [fork the project](https://help.github.com/forking/)
1. make your changes
1. commit to your repository
1. and then [create a pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/).

 The development team can then review your contribution and commit it upstream as appropriate.

If you commit a new feature, add `[FEATURE]` to your commit message AND give a clear description of the new feature. The label `Needs documentation` will be added by maintainers and will automatically create an issue on the QGIS-Documentation repo, where you or others should write documentation about it.

For large-scale changes, you can open a [QEP (QGIS Enhancement Proposal)](https://github.com/qgis/QGIS-Enhancement-Proposals). QEPs are used in the process of creating and discussing new enhancements or policy for QGIS.

## Translations

Please help translate QGIS to your language. At this moment about forty languages are already available in the Desktop user interface and about eighty languages are available in transifex ready to be translated.

The [translation](https://qgis.org/en/site/getinvolved/translate.html) process is managed by the [Translation Team](https://qgis.org/en/site/getinvolved/governance/governance.html#gui-translation) and all the activities are done under the [Transifex](https://www.transifex.com/qgis/) platform.

## Other ways to contribute

If you are not a developer, there are many other possibilities that do not require programming skills to help QGIS to evolve. Check our [project homepage for more information](https://qgis.org/en/site/getinvolved/index.html).
