'''OpenGL extension EXT.multisampled_render_to_texture2

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.multisampled_render_to_texture2 to provide a more 
Python-friendly API

Overview (from the spec)
	
	The <attachment> parameters for FramebufferTexture2DMultisampleEXT is no
	longer required to be COLOR_ATTACHMENT0.  The attachment parameter now
	matches what is allowed in FramebufferTexture2D.  This means values like
	GL_COLOR_ATTACHMENTi, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT, or
	GL_DEPTH_STENCIL_ATTACHMENT may be used.
	After the application has rendered into the mutisampled buffer, the application
	should be careful to not trigger an implicit flush by performing a client side
	read of the buffer (readpixels, copyteximage, blitframebuffer, etc) before any
	subsequent rendering which uses the contents of the buffer. This may cause the
	attachment to be downsampled before the following draw, which would potentially
	cause corruption.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/multisampled_render_to_texture2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.multisampled_render_to_texture2 import *
from OpenGL.raw.GLES2.EXT.multisampled_render_to_texture2 import _EXTENSION_NAME

def glInitMultisampledRenderToTexture2EXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION