'''OpenGL extension NV.memory_object_sparse

This module customises the behaviour of the 
OpenGL.raw.GL.NV.memory_object_sparse to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds sparse support to EXT_memory_object extension.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/memory_object_sparse.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.memory_object_sparse import *
from OpenGL.raw.GL.NV.memory_object_sparse import _EXTENSION_NAME

def glInitMemoryObjectSparseNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION