'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH IBLSS 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B IBLSS
\- iButtonLink SmartSlave
.SH SYNOPSIS
.SS Wall-TH Humidity and Temperature Sensor.
.PP
.B FE
[.]XXXXXXXX2X00[XX][/[
.B TH/humidity
|
.B TH/latesthumidity
|
.B TH/temperature
|
.B TH/latesttemp
|
.B TH/led
|
.B firmware
|
.B subtype
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I FE
.SH SPECIAL PROPERTIES
.SS TH/humidity
.I read-only, floating point
.br
.I Humidity
read by the chip at high resolution (~13 bits). Unit is % relative humidity. Negative values indicate a condensing condition.
Conversion takes about one second.
.SS TH/latesthumidity
.I read-only, floating point
.br
Latest measured humidity. Reading this node will never trigger a combined humidity/temperature conversion. Intended for use after a previous read of the
.B TH/temperature
node or in conjunction with
.B /simultaneous/iblss.
.SS TH/temperature
.I read-only, floating point
.br
.I Temperature
read by the chip at high resolution (~13 bits). Units are selected from the invoking command line. See
.B owfs(1)
or
.B owhttpd(1)
for choices. Default is Celsius.
Conversion takes about one second.
.SS TH/latesttemp
.I read-only, floating point
.br
Latest measured temperature. Reading this node will never trigger a combined humidity/temperature conversion. Intended for use after a previous read of the
.B TH/humidity
node or in conjunction with
.B /simultaneous/iblss.
.SS TH/led
.I write-only, yes-no
.br
Switches the indicator LED on/off.
.SS firmware
.I read-only, ascii
.br
Firmware version of the Smart Slave displayed as major.major number. Firmware versions of the SS-WALL-TH before 1.4 had known issues with humidity reporting.
.SS subtype
.I read-only, ascii
.br
Subtype of the Smart Slave. Currently only possible value is "TH" signifying an SS-WALL-TH drywall temperature/humidity sensor.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
https://www.ibuttonlink.com/products/ss-wall-th
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille <paul.alfille@gmail.com>
Jan Kandziora <jjj@gmx.de>
