'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH DS2423 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2423
\- 4kbit 1-Wire RAM with Counter
.SH SYNOPSIS
RAM and counters.
.PP
.B 1D
[.]XXXXXXXXXXXX[XX][/[
.B counter.[A|B|ALL]
|
.B memory
|
.B pages/page.[0-15|ALL]
|
.B pages/count.[0-15|ALL]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 1D
.SH SPECIAL PROPERTIES
.SS counter.A counter.B counter.ALL
.I read-only, unsigned integer
.br
Debounced external counter. Associated with RAM
.I page.14
and
.I page.15
Note: counter increments only. It is reset when the chip loses power.
.br
.I ALL
returns the two values, separated by a comma. They are read sequentially.
.P
The property was called
.I counters
prior to OWFS version 2.9p1 and the old name is invisibly recognized for backwards compatibility.
.SS memory
.I read-write, binary
.br
512 bytes of memory.
.SS pages/page.0 ... pages/page.15 pages/page.ALL
.I read-write, binary
.br
Memory is split into 16 pages of 32 bytes each. Memory is RAM, contents are lost when power is lost.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS pages/count.0 ... pages/count.15 pages/count.ALL
.I read-only, unsigned integer
.br

Write access to each page of memory. Actually only
.I page.12
and
.I page.13
have write counters.
.br
.I page14
and
.I page.15
\'s counters are associated with the external
.I counters.A
and
.I counters.B
triggers.
.br
The value 0xFFFFFFFF is returned for
.I pages/count.0
through
.I pages/count.11
.br
.I ALL
is an aggregate of the counters, comma separated. Each page is accessed sequentially.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2423
The
.B DS2423 (3)
is used for its counters. The internal counters (associated with pages 12 and 13) can detect memory tampering.
.PP
The external counters A and B page been used in circuit design, such as a wind anometer.
.I OWFS
system handles this automatically.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2423.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
