
# NAME

osmium-tags-count - count keys/tags


# SYNOPSIS

**osmium tags-count** \[*OPTIONS*\] *OSM-FILE* [*TAG-EXPRESSION*...]\
**osmium tags-count** \[*OPTIONS*\] \--expressions=*FILE* *OSM-FILE*


# DESCRIPTION

Count how often keys or tags appear in the input file. If the only command line
argument is an OSM file, all keys in this file are counted. If there are one or
more tag expressions on the command line, only the keys and tags matching those
expressions are counted.

See the **TAG EXPRESSIONS** section for a description of the expression format.

The output has one line per key/tag found. Each line contains the count, the
tag key, and the tag value (if matching tags) separated by TAB characters.
Tag keys and values are surrounded by double quotes. Any double quotes in the
keys and values are doubled.


# OPTIONS

-e FILE, \--expressions=FILE
:   Read expressions from the specified file, one per line. Empty lines are
    ignored. Everything after the comment character (#) is also ignored. See
    the **TAG EXPRESSIONS** section for further details.

-m COUNT, \--min-count=COUNT
:   The minimum count that should be in the output. Used when you are only
    interested in common keys/tags.

-M COUNT, \--max-count=COUNT
:   The maximum count that should be in the output. Used when you are only
    interested in rare keys/tags.

-s SORT, \--sort=SORT
:   Sort order. Order by "count-asc", "count-desc", "name-asc", or "name-desc".
    Default is "count-desc".

-t, \--object-type=TYPE
:   Read only objects of given type (*node*, *way*, *relation*).
    By default all types are read. This option can be given multiple times.

@MAN_COMMON_OPTIONS@
@MAN_PROGRESS_OPTIONS@
@MAN_INPUT_OPTIONS@

# OUTPUT OPTIONS

-o, \--output=FILE
:   Name of the output file. Default is '-' (STDOUT).

-O, \--overwrite
:   Allow an existing output file to be overwritten. Normally **osmium** will
    refuse to write over an existing file.


# TAG EXPRESSIONS

A filter expression specifies one or more keys and/or tags that should be
counted in the data.

Some examples:

amenity
:   Matches the key "amenity".

highway=primary
:   Matches the tag with key "highway" and value "primary".

highway!=primary
:   Matches any tag with key "highway" and a value other than "primary".

type=multipolygon,boundary
:   Matches any tag with key "type" and value "multipolygon" or "boundary".

name,name:de=Kastanienallee,Kastanienstrasse
:   Matches any tag with the key "name" or "name:de" with the value
    "Kastanienallee" or "Kastanienstrasse".

addr:\*
:   Matches tags with keys starting with "addr:"

name=\*Paris
:   Matches all tags with key "name" and a value that contains the word
    "Paris".

If there is no equal sign ("=") in the expression only keys are matched and
values can be anything. If there is an equal sign ("=") in the expression, the
key is to the left and the value to the right. An exclamation sign ("!") before
the equal sign means: A tag with that key, but not the value(s) to the right of
the equal sign. A leading or trailing asterisk ("\*") can be used for substring
or prefix matching, respectively. Commas (",") can be used to separate several
keys or values.

All filter expressions are case-sensitive. There is no way to escape the
special characters such as "=", "\*" and ",". You can not mix
comma-expressions and "\*"-expressions.

The filter expressions specified in a file and/or on the command line are
matched in the order they are given. To achieve best performance, put
expressions expected to match more often first.


# DIAGNOSTICS

**osmium tags-count** exits with exit code

0
  ~ if everything went alright,

1
  ~ if there was an error processing the data, or

2
  ~ if there was a problem with the command line arguments.


# MEMORY USAGE

**osmium tags-count** keeps all counters in memory. For a large OSM file
and unrestricted keys or, worse, tags, this can use quite a lot of memory.
(Counting all tags on a full planet file will use about 16 GByte RAM.)

Use the filter expressions to restrict the counting to the keys or tags
you are actually interested in.


# EXAMPLES

Count all keys in Spain and display most common keys first:

    osmium tags-count spain.osm.pbf

Count all building keys in Madrid:

    osmium tags-count madrid.osm.pbf building

Count all building tags on ways in Madrid, order by name:

    osmium tags-count -t way --sort=name-asc madrid.osm.pbf 'building=*'

Count all relation types in Sevilla that appear at least 100 times:

    osmium tags-count -t relation -m 100 sevilla.osm.pbf 'type=*'

Count all tags in the input file. Note that this might need quite a lot of
memory!

    osmium tags-count input.osm.pbf '*=*'

# SEE ALSO

* **osmium**(1), **osmium-file-formats**(5)
* [Osmium website](https://osmcode.org/osmium-tool/)
* [Taginfo](https://github.com/taginfo/taginfo/)

