/*******************************************************************************
 * MIT License
 * 
 * Copyright (c) 2018 Antonin Delpeuch
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 ******************************************************************************/

package org.openrefine.wikibase.schema;

import org.testng.annotations.Test;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;

import org.openrefine.wikibase.testing.JacksonSerializationTest;

public class WbItemConstantTest extends WbExpressionTest<ItemIdValue> {

    private WbItemConstant constant = new WbItemConstant("Q42", "Douglas Adams");

    @Test
    public void testSerialize() {
        JacksonSerializationTest.canonicalSerialization(WbExpression.class, constant,
                "{\"type\":\"wbitemconstant\",\"qid\":\"Q42\",\"label\":\"Douglas Adams\"}");
    }

    @Test
    public void testEvaluate() {
        evaluatesTo(Datamodel.makeWikidataItemIdValue("Q42"), constant);
    }

    @Test
    public void testValidate() {
        hasNoValidationError(constant);
        hasValidationError("No entity id provided", new WbItemConstant(null, "my label"));
        hasValidationError("No entity label provided", new WbItemConstant("Q23", null));
        hasValidationError("Invalid entity id format: 'invalid format'", new WbItemConstant("invalid format", "my label"));
    }
}
