/*
 * Copyright (C)2005-2019 Haxe Foundation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

// This file is generated from mozilla\TextTrack.webidl. Do not edit!

package js.html;

/**
	This interface also inherits properties from `EventTarget`.

	Documentation [TextTrack](https://developer.mozilla.org/en-US/docs/Web/API/TextTrack) by [Mozilla Contributors](https://developer.mozilla.org/en-US/docs/Web/API/TextTrack$history), licensed under [CC-BY-SA 2.5](https://creativecommons.org/licenses/by-sa/2.5/).

	@see <https://developer.mozilla.org/en-US/docs/Web/API/TextTrack>
**/
@:native("TextTrack")
extern class TextTrack extends EventTarget {
	
	/**
		Returns a `DOMString` indicating what kind of text track the `TextTrack` describes. The value must be one of those in the TextTrackKind enum.
	**/
	var kind(default,null) : TextTrackKind;
	
	/**
		A human-readable `DOMString` which contains the text track's label, if one is present; otherwise, this is an empty string (`""`), in which case a custom label may need to be generated by your code using other attributes of the track, if the track's label needs to be exposed to the user.
	**/
	var label(default,null) : String;
	
	/**
		A `DOMString` which specifies the text language in which the text track's contents is written. The value must adhere to the format specified in the Tags for Identifying Languages (BCP 47) document from the IETF, just like the HTML `lang` attribute. For example, this can be `"en-US"` for United States English or `"pt-BR"` for Brazilian Portuguese.
	**/
	var language(default,null) : String;
	
	/**
		A `DOMString` which identifies the track, if it has one. If it doesn't have an ID, then this value is an empty string (`""`). If the `TextTrack` is associated with a `track` element, then the track's ID matches the element's ID.
	**/
	var id(default,null) : String;
	
	/**
		Returns a `DOMString` which indicates the track's in-band metadata track dispatch type. needs details
	**/
	var inBandMetadataTrackDispatchType(default,null) : String;
	
	/**
		A `DOMString` specifying the track's current mode. Changing this property's value changes the track's current mode to match. Permitted values are listed under Text track mode constants.
	**/
	var mode : TextTrackMode;
	
	/**
		A `TextTrackCueList` which contains all of the track's cues.
	**/
	var cues(default,null) : TextTrackCueList;
	
	/**
		A `TextTrackCueList` object listing the currently active set of text track cues. Track cues are active if the current playback position of the media is between the cues' start and end times.
	**/
	var activeCues(default,null) : TextTrackCueList;
	
	/**
		A `EventHandler` specifying a function to be called when a `cuechange` event occurs. Handling these events lets you know when cues are entered and exited. A given text cue appears when the cue is entered and disappears when the cue is exited.
	**/
	var oncuechange : haxe.Constraints.Function;
	
	function addCue( cue : VTTCue ) : Void;
	/** @throws DOMError */
	function removeCue( cue : VTTCue ) : Void;
}