// generated by ../../../../tools/tube_transfer.py
// tube: JJECC83S
// plate current function: triode
// mu: 98.3
// kx: 1.45
// kg1: 1722.8
// kg2: 0
// kp: 749.4
// kvb: 131.2
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_JJECC83S[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	249.99944335464136,249.99943114245013,249.99941866241159,249.9994059086539,249.99939287517668,
	249.99937955584812,249.99936594440217,249.99935203443545,249.99933781940442,249.9993232926222,
	249.99930844725543,249.99929327632125,249.99927777268377,249.9992619290509,249.99924573797088,
	249.99922919182876,249.99921228284293,249.9991950030614,249.99917734435806,249.99915929842896,
	249.99914085678827,249.99912201076458,249.99910275149654,249.99908306992887,249.99906295680813,
	249.99904240267838,249.99902139787673,249.9989999325287,249.99897799654394,249.99895557961122,
	249.99893267119367,249.99890926052393,249.99888533659902,249.99886088817522,249.99883590376294,
	249.99881037162123,249.9987842797523,249.99875761589593,249.99873036752376,249.99870252183348,
	249.99867406574276,249.9986449858832,249.9986152685941,249.9985848999161,249.99855386558457,
	249.9985221510231,249.99848974133664,249.99845662130446,249.99842277537314,249.99838818764945,
	249.9983528418927,249.99831672150734,249.99827980953518,249.9982420886474,249.99820354113675,
	249.99816414890898,249.9981238934746,249.99808275594026,249.99804071699998,249.99799775692605,
	249.99795385556,249.9979089923032,249.99786314610714,249.99781629546385,249.99776841839582,
	249.99771949244573,249.99766949466616,249.99761840160875,249.99756618931355,249.99751283329772,
	249.99745830854417,249.9974025894901,249.997345650015,249.99728746342873,249.99722800245883,
	249.9971672392382,249.99710514529207,249.99704169152488,249.9969768482066,249.9969105849592,
	249.99684287074263,249.99677367384018,249.99670296184416,249.9966307016406,249.9965568593943,
	249.99648140053284,249.99640428973098,249.99632549089395,249.9962449671412,249.99616268078913,
	249.99607859333383,249.99599266543333,249.99590485688938,249.99581512662908,249.99572343268582,
	249.99562973218013,249.99553398129993,249.9954361352802,249.99533614838262,249.99523397387455,
	249.99512956400733,249.9950228699948,249.99491384199052,249.99480242906498,249.9946885791825,
	249.99457223917713,249.99445335472842,249.9943318703366,249.99420772929705,249.99408087367453,
	249.99395124427662,249.99381878062667,249.99368342093632,249.99354510207706,249.9934037595518,
	249.99325932746507,249.9931117384934,249.99296092385444,249.99280681327565,249.9926493349625,
	249.9924884155657,249.99232398014806,249.99215595215028,249.9919842533565,249.99180880385848,
	249.99162952201988,249.99144632443878,249.99125912591043,249.9910678393885,249.99087237594574,
	249.9906726447341,249.99046855294338,249.99026000575972,249.99004690632282,249.9898291556823,
	249.98960665275322,249.98937929427083,249.98914697474402,249.98890958640817,249.98866701917663,
	249.9884191605918,249.9881658957746,249.98790710737313,249.98764267551033,249.98737247773045,
	249.98709638894468,249.98681428137525,249.98652602449863,249.98623148498763,249.9859305266522,
	249.98562301037907,249.98530879406997,249.98498773257904,249.98465967764852,249.98432447784327,
	249.98398197848405,249.98363202157952,249.9832744457565,249.98290908618927,249.98253577452715,
	249.9821543388207,249.98176460344655,249.98136638903048,249.98095951236925,249.98054378635072,
	249.98011901987215,249.9796850177575,249.97924158067232,249.97878850503756,249.9783255829413,
	249.97785260204907,249.97736934551196,249.97687559187318,249.97637111497318,249.97585568385193,
	249.97532906265025,249.97479101050868,249.97424128146454,249.97367962434703,249.97310578267025,
	249.972519494524,249.97192049246289,249.97130850339272,249.9706832484553,249.9700444429107,
	249.96939179601716,249.9687250109091,249.9680437844725,249.96734780721803,249.96663676315168,
	249.96591032964324,249.965168177292,249.96440996979,249.96363536378297,249.96284400872827,
	249.96203554675074,249.96120961249528,249.96036583297712,249.95950382742942,249.95862320714758,
	249.95772357533139,249.95680452692375,249.95586564844686,249.95490651783507,249.95392670426543,
	249.95292576798406,249.95190326013093,249.9508587225602,249.9497916876581,249.94870167815753,
	249.94758820694935,249.9464507768903,249.94528888060782,249.9441020003014,249.94288960754045,
	249.9416511630589,249.94038611654625,249.939093906435,249.93777395968485,249.9364256915627,
	249.93504850541996,249.933641792465,249.93220493153325,249.9307372888522,249.9292382178037,
	249.92770705868182,249.92614313844723,249.92454577047752,249.92291425431353,249.9212478754021,
	249.91954590483437,249.91780759908065,249.91603219972058,249.91421893317016,249.91236701040359,
	249.91047562667205,249.90854396121784,249.9065711769843,249.90455642032214,249.90249882069077,
	249.90039749035634,249.89825152408497,249.896059998832,249.8938219734271,249.89153648825504,
	249.88920256493242,249.88681920597998,249.8843853944909,249.88190009379477,249.87936224711768,
	249.87677077723745,249.87412458613554,249.87142255464434,249.8686635420904,249.86584638593365,
	249.86296990140278,249.8600328811258,249.8570340947581,249.85397228860478,249.85084618524078,
	249.84765448312578,249.8443958562164,249.84106895357436,249.83767239897026,249.8342047904854,
	249.83066470010831,249.82705067332935,249.8233612287311,249.81959485757605,249.81575002339088,
	249.81182516154786,249.80781867884343,249.8037289530743,249.79955433261,249.7952931359641,
	249.79094365136237,249.78650413630905,249.78197281715097,249.77734788863995,249.77262751349343,
	249.76780982195368,249.76289291134557,249.75787484563352,249.75275365497745,249.74752733528786,
	249.742193847781,249.73675111853333,249.73119703803616,249.7255294607511,249.71974620466517,
	249.71384505084816,249.7078237430093,249.70167998705733,249.69541145066077,249.68901576281144,
	249.68249051338955,249.67583325273193,249.66904149120364,249.66211269877232,249.65504430458708,
	249.64783369656146,249.64047822096052,249.6329751819937,249.6253218414126,249.61751541811495,
	249.60955308775448,249.60143198235815,249.59314918994994,249.58470175418296,249.57608667397884,
	249.56730090317706,249.55834135019222,249.54920487768146,249.53988830222215,249.5303883940003,
	249.52070187650975,249.5108254262638,249.50075567251864,249.4904891970099,249.4800225337028,
	249.469352168556,249.4584745393004,249.44738603523277,249.43608299702598,249.42456171655422,
	249.41281843673679,249.40084935139834,249.388650605148,249.37621829327693,249.3635484616755,
	249.3506371067706,249.3374801754833,249.32407356520824,249.31041312381433,249.29649464966863,
	249.2823138916829,249.2678665493836,249.25314827300707,249.2381546636187,249.222881273258,
	249.20732360510956,249.1914771137009,249.17533720512705,249.1588992373033,249.14215852024554,
	249.12511031638005,249.107749840882,249.0900722620441,249.07207270167473,249.05374623552763,
	249.03508789376167,249.01609266143302,248.99675547901808,248.9770712429697,248.95703480630505,
	248.9366409792264,248.91588452977567,248.89476018452126,248.87326262927922,248.8513865098678,
	248.8291264328958,248.80647696658497,248.78343264162663,248.75998795207207,248.73613735625716,
	248.71187527776112,248.6871961063993,248.6620941992496,248.63656388171276,248.61059944860622,
	248.5841951652914,248.55734526883325,248.5300439691939,248.50228545045692,248.47406387208497,
	248.44537337020776,248.4162080589418,248.3865620317399,248.35642936277108,248.32580410832898,
	248.29468030826897,248.26305198747352,248.2309131573438,248.1982578173176,248.1650799564129,
	248.1313735547954,248.09713258536962,248.0623510153925,248.02702280810834,247.99114192440382,
	247.9547023244827,247.91769796955833,247.88012282356283,247.8419708548724,247.80323603804652,
	247.7639123555808,247.72399379967098,247.68347437398805,247.642348095462,247.60060899607365,
	247.55825112465206,247.51526854867765,247.47165535608812,247.42740565708652,247.3825135859495,
	247.3369733028349,247.29077899558624,247.24392488153367,247.19640520928863,247.1482142605323,
	247.0993463517945,247.0497958362229,246.9995571053404,246.94862459078988,246.89699276606308,
	246.84465614821477,246.79160929955816,246.7378468293422,246.68336339540767,246.62815370582186,
	246.5722125204898,246.51553465274122,246.45811497089127,246.3999483997742,246.34102992224857,
	246.2813545806729,246.22091747835083,246.15971378094326,246.09773871784878,246.03498758354897,
	245.97145573891925,245.90713861250322,245.8420317017502,245.77613057421507,245.70943086871904,
	245.64192829647118,245.57361864215002,245.504497764944,245.43456159955053,245.36380615713333,
	245.29222752623681,245.2198218736581,245.1465854452751,245.07251456683142,244.9976056446769,
	244.92185516646416,244.84525970180076,244.76781590285685,244.689520504928,244.61037032695378,
	244.53036227199138,244.44949332764514,244.36776056645135,244.28516114621908,244.2016923103267,
	244.11735138797528,244.032135794398,243.94604303102693,243.85907068561716,243.77121643232843,
	243.68247803176553,243.5928533309772,243.5023402634146,243.41093684884984,243.3186411932547,
	243.22545148864145,243.13136601286473,243.03638312938685,242.94050128700619,242.84371901954984,
	242.74603494553156,242.64744776777505,242.54795627300456,242.44755933140226,242.34625589613512,
	242.24404500284984,242.14092576913896,242.0368973939777,241.9319591571329,241.82611041854486,
	241.71935061768352,241.61167927287892,241.503095980628,241.39360041487797,241.28319232628738,
	241.17187154146612,241.05963796219478,240.94649156462478,240.8324323984602,240.7174605861217,
	240.60157632189433,240.4847798710595,240.3670715690119,240.24845182036344,240.12892109803337,
	240.00847994232717,239.88712896000348,239.76486882333165,239.6417002691391,239.51762409785061,
	239.3926411725197,239.26675241785262,239.1399588192271,239.01226142170486,238.88366132903968,
	238.75415970268193,238.62375776077948,238.49245677717656,238.36025808041018,238.22716305270632,
	238.0931731289749,237.95828979580526,237.82251459046225,237.68584909988385,237.54829495968065,
	237.40985385313766,237.27052751021947,237.13031770657844,236.98922626256754,236.84725504225713,
	236.70440595245708,236.56068094174412,236.41608199949505,236.27061115492603,236.1242704761389,
	235.977062069174,235.82898807707048,235.6800506789344,235.53025208901477,235.37959455578755,
	235.2280803610487,235.07571181901548,234.9224912754376,234.7684211067166,234.61350371903578,
	234.45774154749924,234.30113705528103,234.1436927327844,233.98541109681113,233.8262946897416,
	233.66634607872493,233.50556785488024,233.34396263250832,233.18153304831452,233.01828176064208,
	232.85421144871697,232.68932481190356,232.52362456897168,232.35711345737445,232.1897942325379,
	232.02166966716126,231.852742550529,231.68301568783366,231.51249189951076,231.34117402058394,
	231.1690649000221,230.99616740010748,230.82248439581522,230.64801877420342,230.47277343381532,
	230.29675128409139,230.11995524479346,229.94238824543936,229.7640532247482,229.58495313009686,
	229.40509091698726,229.2244695485238,229.04309199490203,228.86096123290727,228.6780802454237,
	228.4944520209543,228.3100795531503,228.12496584035105,227.9391138851338,227.7525266938737,
	227.56520727631298,227.3771586451403,227.18838381557947,226.99888580498782,226.80866763246337,
	226.617732318462,226.42608288442278,226.23372235240345,226.04065374472333,225.8468800836164,
	225.65240439089175,225.45722968760356,225.26135899372858,225.0647953278524,224.8675417068636,
	224.66960114565597,224.4709766568387,224.27167125045406,224.07168793370266,223.87102971067674,
	223.6696995821004,223.4677005450769,223.2650355928436,223.0617077145334,222.8577198949439,
	222.65307511431183,222.447776348096,222.24182656676507,222.03522873559317,221.8279858144605,
	221.62010075766136,221.41157651371728,221.20241602519653,220.99262222853974,220.78219805389048,
	220.5711464249324,220.3594702587312,220.14717246558232,219.9342559488639,219.72072360489494,
	219.50657832279856,219.29182298437027,219.07646046395124,218.86049362830616,218.64392533650616,
	218.42675843981596,218.2089957815859,217.99064019714834,217.77169451371802,217.55216155029748,
	217.3320441175859,217.1113450178923,216.89006704505306,216.66821298435295,216.44578561245012,
	216.2227876973052,215.99922199811348,215.7750912652416,215.5503982401667,215.32514565542007,
	215.0993362345337,214.87297269199047,214.64605773317706,214.418594054341,214.19058434254995,
	213.9620312756549,213.73293752225604,213.5033057416712,213.27313858390838,213.04243868964,
	212.8112086901807,212.5794512074677,212.34716885404404,212.1143642330442,211.88103993818288,
	211.64719855374605,211.41284265458472,211.17797480611122,210.9425975642982,210.7067134756797,
	210.47032507735503,210.23343489699516,209.99604545285104,209.758159253765,209.51977879918368,
	209.2809065791741,209.04154507444147,208.80169675634986,208.56136408694445,208.32054951897678,
	208.07925549593205,207.8374844520582,207.59523881239815,207.3525209928237,207.10933340007188,
	206.86567843178338,206.62155847654387,206.3769759139267,206.13193311453892,205.88643244006875,
	205.64047624333594,205.3940668683443,205.14720665033667,204.89989791585214,204.65214298278607,
	204.40394416045223,204.15530374964763,203.90622404272005,203.65670732363785,203.4067558680625,
	203.15637194342415,202.90555780899973,202.6543157159934,202.40264790762092,202.15055661919598,
	201.89804407822004,201.6451125044753,201.39176411012025,201.13800109978956,200.88382567069613,
	200.6292400127374,200.37424630860497,200.1188467338975,199.863043457238,199.60683864039467,
	199.3502344384054,199.09323299970717,198.83583646626883,198.57804697372902,198.3198666515381,
	198.06129762310505,197.80234200594924,197.54300191185692,197.2832794470433,197.02317671231978,
	196.7626958032668,196.50183881041244,196.24060781941705,195.9790049112641,195.71703216245734,
	195.45469164522473,195.19198542772932,194.9289155742871,194.66548414559256,194.40169319895153,
	194.1375447885229,193.87304096556727,193.6081837787056,193.34297527418605,193.07741749616025,
	192.81151248696918,192.54526228743927,192.27866893718857,192.01173447494415,191.7444609388701,
	191.47685036690768,191.20890479712747,190.94062626809387,190.6720168192426,190.40307849127203,
	190.13381332654828,189.864223369525,189.59431066717832,189.3240772694575,189.0535252297517,
	188.782656605374,188.51147345806302,188.2399778545024,187.96817186685962,187.69605757334446,
	187.4236370587877,187.15091241524104,186.87788574259937,186.60455914924526,186.33093475271775,
	186.05701468040522,185.78280107026416,185.50829607156405,185.2335018456599,184.95842056679305,
	184.68305442292188,184.40740561658248,184.13147636578148,183.85526890492181,183.57878548576215,
	183.30202837841205,183.02499987236354,182.74770227756056,182.47013792550766,182.19230917041958,
	181.91421839041266,181.63586798874013,181.35726039507216,181.0783980668229,180.79928349052585,
	180.51991918325908,180.240307694122,179.96045160576597,179.6803535359798,179.40001613933245,
	179.1194421088748,178.83863417790204,178.55759512177946,178.27632775983247,177.99483495730428,
	177.71311962738207,177.43118473329474,177.14903329048425,176.8666683688518,176.58409309508292,
	176.30131065505194,176.01832429630957,175.73513733065457,175.45175313679485,175.1681751630914,
	174.88440693040585,174.6004520350315,174.3163141517265,174.031997036845,173.74750453157017,
	173.4628405652507,173.1780091588439,172.8930144284674,172.60786058906152,172.32255195816458,
	172.03709295980363,171.75148812850207,171.46574211340638,171.17985968253387,170.89384572714295,
	170.6077052662276,170.321443451137,170.03506557032196,169.7485770542094,169.46198348020414,
	169.1752905778204,168.88850423394186,168.60163049820991,168.31467558854146,168.02764589677258,
	167.7405479944293,167.45338863862224,167.16617477806335,166.87891355920172,166.59161233247562,
	166.30427865867605,166.01692031541793,165.72954530371314,165.44216185463898,165.15477843609622,
	164.8674037596478,164.58004678743018,164.29271673912774,164.00542309899893,163.7181756229433,
	163.43098434559585,163.14385958743483,162.85681196188827,162.56985238242171,162.28299206959002,
	161.99624255803334,161.70961570339745,161.42312368915464,161.13677903330364,160.85059459492098,
	160.56458358053857,160.2787595503186,159.99313642399554,159.70772848655366,159.42255039360685,
	159.13761717644638,158.85294424671937,158.56854740070105,158.28444282312051,158.00064709050065,
	157.71717717396916,157.43405044149824,157.15128465952898,156.86889799393526,156.58690901028157,
	156.30533667332963,156.02420034574604,155.743519785966,155.46331514516663,155.1836069633043,
	154.90441616417186,154.6257640494321,154.3476722915858,154.07016292583523,153.7932583408043,
	153.51698126808253,153.2413547705604,152.96640222952857,152.69214733051743,152.41861404785828,
	152.14582662795127,151.87380957123253,151.60258761283657,151.33218570195854,151.0626289799258,
	150.79394275699562,150.52615248790443,150.25928374619951,149.99336219739305,149.7284135709863,
	149.46446363142013,149.2015381480133,148.93966286396315,148.67886346448557,148.41916554418313,
	148.16059457373433,147.90317586600693,147.64693454170236,147.39189549464547,147.13808335683885,
	146.88552246340686,146.6342368175558,146.38425005568232,146.13558541276365,145.88826568816404,
	145.64231321199162,145.39774981214225,145.15459678216047,144.9128748500493,144.67260414815513,
	144.43380418424846,144.19649381391795,143.96069121438603,143.72641385984969,143.4936784984394,
	143.26250113088273,143.03289699094728,142.8048805277302,142.57846538984916,142.35366441157976,
	142.13048960097407,141.90895212998257,141.68906232659225,141.47082966898213,141.25426278168584,
	141.0393694337431,140.82615653880896,140.61463015718212,140.4047954997042,140.19665693347324,
	139.99021798930744,139.7854813708878,139.58244896550204,139.38112185630783,139.18150033602663,
	138.98358392197775,138.78737137235763,138.5928607036676,138.40004920919196,138.20893347842673,
	138.01950941736035,137.83177226950667,137.64571663759284,137.4613365058062,137.2786252625057,
	137.09757572330676,136.9181801544516,136.74043029637969,136.5643173874174,136.38983218750965,
	136.21696500192053,136.04570570483446,135.87604376279265,135.70796825790677,135.54146791079282,
	135.37653110317572,135.21314590011843,135.05130007183263,134.89098111503506,134.73217627381553,
	134.57487255998726,134.419056772895,134.2647155186591,134.11183522883726,133.9604021784905,
	133.81040250364123,133.6618222181151,133.51464722976192,133.36886335605206,133.22445633904817,
	133.08141185975373,132.93971555184274,132.79935301477536,132.66030982630775,132.52257155440378,
	132.38612376855963,132.25095205055203,132.1170420046226,131.98437926711136,131.85294951555323,
	131.72273847725234,131.59373193734913,131.46591574639496,131.3392758274515,131.2137981827289,
	131.08946889978122,130.96627415727258,130.84420023033258,130.72323349551556,130.60336043538052,
	130.48456764270705,130.36684182436255,130.25016980483704,130.1345385294598,130.01993506731256,
	129.906346613854,129.79376049326942,129.68216416055924,129.57154520337917,129.46189134364576,
	129.35319043891874,129.24543048357341,129.1385996097731,129.03268608825465,128.92767832893625,
	128.82356488135866,128.72033443497,128.617975819263,128.51647800377444,128.41583009795525,
	128.31602135091975,128.21704115108176,128.11887902568634,128.02152464024246,127.92496779786565,
	127.82919843853568,127.73420663825397,127.63998260824532,127.54651669385275,127.45379937361962,
	127.36182125818773,127.27057308917044,127.18004573797992,127.09023020461171,127.0011176163916,
	126.91269922668798,126.82496641359386,126.73791067858168,126.65152364513422,126.56579705735462,
	126.48072277855839,126.39629278985021,126.31249918868777,126.22933418743521,126.14679011190866,
	126.06485939991482,125.9835345997863,125.90280836891375,125.82267347227767,125.7431227809808,
	125.66414927078316,125.58574602063997,125.50790621124547,125.43062312358178,125.35389013747563,
	125.27770073016273,125.20204847486129,125.12692703935541,125.05233018458924,124.97825176327179,
	124.90468571849466,124.8316260823616,124.75906697463114,124.68700260137321,124.6154272536392,
	124.54433530614652,124.47372121597809,124.4035795212962,124.33390484007214,124.26469186883092,
	124.19593538141183,124.12763022774453,124.05977133264139,123.99235369460527,123.9253723846542,
	123.85882254516143,123.79269938871217,123.72699819697614,123.66171431959668,123.59684317309572,
	123.53238023979488,123.46832106675298,123.40466126471888,123.34139650710112,123.27852252895241,
	123.2160351259707,123.15393015351512,123.09220352563811,123.03085121413224,122.96986924759268,
	122.90925371049454,122.84900074228528,122.7891065364917,122.72956733984161,122.67037945139998,
	122.61153922171938,122.55304305200438,122.49488739328996,122.43706874563367,122.37958365732145,
	122.32242872408659,122.26560058834208,122.20909593842597,122.15291150785943,122.09704407461771,
	122.04149046041334,121.98624752999166,121.93131219043848,121.87668139049971,121.8223521199126,
	121.76832140874853,121.71458632676742,121.66114398278282,121.60799152403857,121.55512613559581,
	121.50254503973105,121.45024549534422,121.39822479737762,121.34648027624434,121.29500929726738,
	121.24380926010186,121.19287759829976,121.14221177861309,121.09180930058382,121.04166769600053,
	120.99178452839347,120.9421573925384,120.89278391396881,120.84366174849706,120.79478858174357,
	120.74616212867441,120.6977801331467,120.64964036746223,120.6017406319287,120.55407875442853,
	120.50665258999543,120.45946002039781,120.41249895373008,120.36576732401069,120.31926309078693,
	120.27298423874711,120.22692877733898,120.18109474039503,120.13548018576404,120.09008319494939,
	120.0449018727528,119.99993434692543,119.95517876782361,119.91063330807164,119.86629616222956,
	119.82216554646716,119.77823969824325,119.73451687599051,119.69099535880565,119.64767344614513,
	119.6045494575256,119.56162173222974,119.5188886290172,119.47634852583998,119.4339998195631,
	119.39184092568975,119.3498702780911,119.30808632874059,119.26648754745298,119.22507242162736,
	119.18383945599483,119.14278717237012,119.10191410940759,119.06121882236113,119.02069988284809,
	118.98035587861722,118.94018541332034,118.90018710628789,118.86035959230803,118.82070152140967,
	118.78121155864874,118.74188838389811,118.70273069164112,118.66373719076817,118.62490660437695,
	118.58623766957561,118.54772913728945,118.50937977207052,118.47118835191034,118.43315366805585,
	118.39527452482804,118.35754973944374,118.31997814184005,118.28255857450175,118.24528989229157,
	118.2081709622829,118.17120066359544,118.13437788723307,118.09770153592494,118.06117052396843,
	118.02478377707496,117.98854023221813,117.95243883748432,117.91647855192554,117.88065834541457,
	117.84497719850262,117.80943410227886,117.77402805823228,117.73875807811596,117.70362318381305,
	117.66862240720491,117.63375479004168,117.59901938381412,117.56441524962831,117.52994145808138,
	117.49559708913989,117.46138123201963,117.4272929850673,117.39333145564426,117.35949576001175,
	117.32578502321797,117.2921983789869,117.25873496960867,117.22539394583183,117.19217446675695,
	117.15907569973199,117.12609682024922,117.09323701184364,117.06049546599294,117.02787138201894,
	116.99536396699044,116.96297243562773,116.93069601020808,116.89853392047314,116.86648540353723,
	116.83454970379746,116.80272607284465,116.77101376937588,116.73941205910839,116.70792021469437,
	116.67653751563726,116.64526324820942,116.61409670537032,116.58303718665852,116.55208399822848,
	116.52123645259407,116.49049386867419,116.45985557168551,116.4293208930679,116.39888917041105,
	116.36855974738184,116.33833197365284,116.30820520483205,116.2781788023932,116.24825213360754,
	116.21842457147605,116.1886954946631,116.1590642874306,116.12953033957358,116.10009304635606,
	116.07075180844825,116.04150603186451,116.01235512790205,115.98329851308081,115.95433560908361,
	115.92546584269763,115.89668864575656,115.86800345508338,115.839409712434,115.81090686444185,
	115.78249436256293,115.75417166302189,115.72593822675852,115.69779351937525,115.66973701108532,
	115.6417681766614,115.61388649538519,115.58609145099764,115.55838253164953,115.53075922985327,
	115.50322104243492,115.47576747048672,115.44839801932079,115.42111219842302,115.39390952140761,
	115.36678950597252,115.33975167385489,115.31279555078778,115.28592066645689,115.25912655445813,
	115.23241275225578,115.205778801141,115.17922424619086,115.15274863622825,115.12635152378202,
	115.10003246504753,115.07379101984806,115.04762675159635,115.0215392272569,114.99552801730856,
	114.9695926957079,114.94373283985259,114.91794803054563,114.89223785195978,114.86660189160273,
	114.84103974028233,114.8155509920726,114.79013524428001,114.76479209741007,114.73952115513464,
	114.7143220242594,114.68919431469178,114.66413763940929,114.63915161442827,114.6142358587732,
	114.58938999444585,114.5646136463955,114.53990644248891,114.51526801348125,114.49069799298681,
	114.46619601745044,114.44176172611922,114.41739476101455,114.39309476690441,114.36886139127616,
	114.34469428430943,114.3205930988497,114.29655749038176,114.27258711700385,114.24868163940182,
	114.22484072082398,114.20106402705576,114.1773512263951,114.15370198962788,114.13011599000372,
	114.1065929032122,114.08313240735893,114.05973418294262,114.0363979128316,114.01312328224128,
	113.98990997871157,113.96675769208444,113.94366611448216,113.92063494028538,113.89766386611163,
	113.87475259079416,113.85190081536082,113.82910824301338,113.80637457910707,113.78369953113003,
	113.76108280868355,113.73852412346213,113.71602318923372,113.69357972182073,113.67119343908048,
	113.64886406088652,113.62659130910974,113.6043749076,113.58221458216785,113.5601100605662,
	113.53806107247276,113.51606734947205,113.49412862503817,113.47224463451734,113.45041511511079,
	113.42863980585804,113.406918447595,113.38525078304026,113.36363655662008,113.34207551456122,
	113.32056740484686,113.29911197720078,113.27770898307165,113.25635817561765,113.23505930969104,
	113.21381214182335,113.19261643020985,113.17147193469536,113.15037841675918,113.12933563950081,
	113.10834336762551,113.08740136743026,113.06650940678956,113.04566725514181,113.02487468347529,
	113.00413146431487,112.98343737170846,112.96279218121359,112.94219566988455,112.92164761625924,
	112.90114780034624,112.88069600361219,112.86029200896917,112.8399356007623,112.8196265647572,
	112.79936468812815,112.77914975944566,112.75898156866474,112.738859907113,112.71878456747908,
	112.69875534380083,112.67877203145417,112.6588344271415,112.63894232888062,112.61909553599357,
	112.59929384909576,112.57953707008488,112.55982500213038,112.5401574496627,112.52053421836273,
	112.50095511515143,112.48141994817942,112.46192852681686,112.4424806616433,112.42307616443766,
	112.40371484816825,112.38439652698315,112.36512101620033,112.34588813229801,112.3266976929054,
	112.30754951679288,112.28844342386307,112.26937923514146,112.25035677276703,112.23137585998357,
	112.21243632113053,112.19353798163415,112.17468066799876,112.15586420779798,112.13708842966619,
	112.11835316329004,112.09965823939986,112.08100348976147,112.06238874716782,112.04381384543078,
	112.02527861937314,112.0067829048204,111.98832653859299,111.96990935849833,111.95153120332289,
	111.93319191282473,111.9148913277257,111.89662928970374,111.87840564138571,111.86022022633956,
	111.84207288906734,111.82396347499757,111.80589183047839,111.78785780273357,111.76986124000936,
	111.75190199132372,111.7339799066318,111.7160948367731,111.6982466334646,111.68043514929403,
	111.66266023771311,111.6449217530312,111.62721955040836,111.60955348584913,111.59192341619601,
	111.57432919912304,111.55677069312952,111.5392477575338,111.52176025246699,111.50430803886678,
	111.48689097847162,111.46950893381431,111.45216176821633,111.43484934578179,111.41757153139153,
	111.4003281906974,111.38311919011645,111.36594439682526,111.3488036787543,111.33169690458217,
	111.31462394373031,111.29758466635732,111.28057894335352,111.26360664633565,111.24666764762985,
	111.22976182032194,111.21288903814806,111.19604917558235,111.17924210810476,111.16246771065273,
	111.1457258607083,111.12901643520462,111.11233931204539,111.09569436984165,111.07908148785138,
	111.06250054600369,111.04595142488829,111.02943400575052,111.01294817048668,110.99649380163937,
	110.98007078239286,110.96367899656842,110.94731832861994,110.93098866362918,110.91468988730158,
	110.89842188596154,110.8821845465482,110.8659777566111,110.84980140430574,110.83365537838932,
	110.81753956821665,110.80145386373573,110.78539815548379,110.76937233458287,110.75337629273609,
	110.73740992222328,110.72147311589707,110.70556576717885,110.68968777005499,110.67383901907259,
	110.65801940933592,110.6422288365023,110.62646719677839,110.6107343869164,110.59503030421037,
	110.57935484653815,110.56370791218494,110.54808940008509,110.53249920966306,110.51693724086662,
	110.50140339416359,110.48589757053797,110.47041967148677,110.45496959901621,110.43954725563849,
	110.42415254436823,110.40878536871912,110.39344563270058,110.37813324081436,110.36284809805127,
	110.3475901098879,110.33235918228328,110.31715522167576,110.30197813497978,110.28682782958256,
	110.2717042133411,110.25660719457908,110.24153668208356,110.22649258510212,110.21147481333968,
	110.19648327695546,110.18151788656014,110.16657855321273,110.15166518841758,110.13677770412167,
	110.12191601271141,110.10708002701008,110.09226966027474,110.07748482619337,110.06272543888231,
	110.0479914128832,110.03328266316038,110.01859910509809,110.00394065449774,109.98930722757514,
	109.97469874095803,109.96011511168325,109.94555625719406,109.9310220953377,109.9165125443627,
	109.90202752291621,109.88756695004163,109.87313074517598,109.8587188281474,109.84433111917257,
	109.82996753885443,109.81562800817959,109.80131244851579,109.78702078160975,109.77275292958458,
	109.75850881493749,109.74428836053728,109.7300914896222,109.71591812579751,109.70176819303325,
	109.68764161566179,109.67353831837575,109.65945822622567,109.6454012646177,109.63136735931153,
	109.61735643641809,109.60336842239732,109.58940324405619,109.57546082854633,109.56154110336205,
	109.54764399633817,109.5337694356478,109.51991734980054,109.50608766764014,109.49228031834254,
	109.47849523141392,109.46473233668846,109.45099156432654,109.43727284481271,109.42357610895358,
	109.40990128787604,109.39624831302513,109.38261711616231,109.36900762936332,109.35541978501648,
	109.34185351582065,109.32830875478341,109.31478543521916,109.30128349074747,109.2878028552909,
	109.27434346307345,109.26090524861863,109.24748814674773,109.234092092578,109.22071702152091,
	109.20736286928037,109.19402957185095,109.18071706551628,109.16742528684716,109.15415417267268,
	109.14090366018532,109.12767368678247,109.11446419016714,109.10127510832113,109.08810637950353,
	109.07495794224894,109.06182973536608,109.04872169793586,109.03563376931014,109.02256588910983,
	109.00951799722354,108.99649003380596,108.98348193927609,108.97049365431621,108.9575251198698,
	108.94457627714041,108.93164706758986,108.91873743293704,108.90584731515622,108.89297665647568,
	108.88012539937611,108.86729348658933,108.85448086109682,108.84168746612809,108.82891324515951,
	108.81615814191281,108.80342210035359,108.79070506469009,108.77800697937161,108.76532778908732,
	108.75266743876489,108.74002587356888,108.7274030388998,108.71479888039242,108.70221334391464,
	108.68964637556611,108.677097921677,108.6645679288065,108.65205634374183,108.63956311349669,
	108.62708818531019,108.6146315066454,108.60219302518826,108.58977268884627,108.57737044574726,
	108.56498624423817,108.55262003288375,108.54027176046547,108.52794137598036,108.51562882863954,
	108.50333406786736,108.49105704330003,108.47879770478454,108.4665560023774,108.45433188634361,
	108.44212530715544,108.42993621549122,108.41776456223444,108.40561029847241,108.39347337549515,
	108.38135374479447,108.3692513580627,108.35716616719156,108.34509812427139,108.33304718158958,
	108.32101329162991,108.30899640707135,108.29699648078693,108.28501346584282,108.27304731549714,
	108.26109798319911,108.24916542258778,108.23724958749136,108.2253504319258,108.21346791009402,
	108.20160197638496,108.18975258537236,108.17791969181398,108.16610325065056,108.15430321700474,
	108.14251954618027,108.13075219366087,108.11900111510943,108.10726626636692,108.09554760345159,
	108.08384508255794,108.07215866005578,108.06048829248931,108.04883393657632,108.03719554920707,
	108.02557308744359,108.01396650851864,108.0023757698348,107.99080082896376,107.97924164364521,
	107.96769817178613,107.95617037145983,107.94465820090511,107.93316161852543,107.92168058288792,
	107.91021505272276,107.89876498692213,107.88733034453948,107.87591108478863,107.86450716704296,
	107.85311855083474,107.841745195854,107.830387061948,107.81904410912028,107.80771629752984,
	107.7964035874905,107.78510593947,107.77382331408906,107.76255567212094,107.7513029744904,
	107.7400651822729,107.72884225669418,107.71763415912902,107.70644085110085,107.69526229428085,
	107.6840984504871,107.67294928168414,107.66181474998189,107.65069481763513,107.6395894470427,
	107.6284986007468,107.61742224143218,107.6063603319256,107.59531283519493,107.58427971434864,
	107.57326093263478,107.56225645344078,107.55126624029215,107.5402902568523,107.52932846692161,
	107.51838083443673,107.50744732347015,107.49652789822908,107.48562252305526,107.47473116242395,
	107.4638537809435,107.45299034335456,107.4421408145294,107.43130515947135,107.42048334331415,
	107.40967533132134,107.39888108888543,107.3881005815275,107.37733377489647,107.3665806347685,
	107.35584112704622,107.34511521775842,107.33440287305913,107.32370405922724,107.31301874266563,
	107.30234688990095,107.29168846758263,107.28104344248241,107.270411781494,107.25979345163209,
	107.24918842003204,107.2385966539492,107.22801812075828,107.21745278795301,107.20690062314523,
	107.19636159406454,107.18583566855773,107.1753228145881,107.16482300023509,107.1543361936935,
	107.14386236327306,107.13340147739797,107.12295350460619,107.11251841354895,107.10209617299027,
	107.09168675180646,107.08129011898525,107.0709062436258,107.06053509493779,107.05017664224096,
	107.03983085496472,107.02949770264749,107.01917715493627,107.00886918158608,106.9985737524595,
	106.98829083752621,106.97802040686221,106.96776243064973,106.95751687917647,106.94728372283511,
	106.93706293212307,106.92685447764157,106.91665833009561,106.90647446029324,106.89630283914506,
	106.88614343766393,106.87599622696422,106.86586117826167,106.85573826287259,106.84562745217995,
	106.83552871776588,106.82544203121417,106.81536736423944,106.80530468865484,106.79525397637146,
	106.7852151993979,106.77518832983982,106.76517333989962,106.75517020187581,106.74517888816257,
	106.73519937124962,106.72523162372134,106.71527561825673,106.70533132762868,106.69539872470376,
	106.68547778244168,106.67556847389486,106.66567077220813,106.65578465061813,106.6459100824531,
	106.63604704113226,106.62619550016551,106.61635543315309,106.60652681378502,106.59670961584082,
	106.58690381318904,106.5771093797868,106.56732628967967,106.55755451700081,106.54779403597111,
	106.5380448208983,106.52830684617702,106.51858008628801,106.50886451579805,106.49916010935935,
	106.48946684170942,106.47978468767042,106.47011362214896,106.46045362013564,106.45080465670476,
	106.44116670701385,106.4315397463034,106.42192374989646,106.41231869319823,106.40272455169575,
	106.39314130095757,106.38356891663321,106.37400737445313,106.36445665022805,106.35491671984876,
	106.34538755928585,106.33586914458914,106.32636145188746,106.31686445738839,106.30737813737771,
	106.29790246821928,106.28843742635449,106.27898298830216,106.26953913065796,106.26010583009423,
	106.25068306335966,106.2412708072788,106.23186903875198,106.22247773475469,106.21309687233753,
	106.20372642862576,106.19436638081892,106.18501670619064,106.17567738208821,106.16634838593241,
	106.15702969521698,106.14772128750845,106.13842314044591,106.12913523174049,106.11985753917517,
	106.11059004060452,106.10133271395438,106.0920855372213,106.08284848847272,106.07362154584622,
	106.06440468754954,106.05519789186,106.04600113712455,106.03681440175912,106.02763766424854,
	106.01847090314625,106.0093140970739,106.00016722472114,105.99103026484536,105.9819031962713,
	105.97278599789091,105.9636786486629,105.95458112761263,105.94549341383173,105.93641548647777,
	105.92734732477423,105.91828890800993,105.90924021553883,105.90020122677997,105.89117192121695,
	105.88215227839775,105.87314227793453,105.86414189950318,105.85515112284335,105.84616992775783,
	105.83719829411258,105.8282362018364,105.8192836309205,105.81034056141847,105.80140697344595,
	105.79248284718027,105.78356816286038,105.77466290078641,105.76576704131945,105.75688056488156,
	105.74800345195519,105.73913568308305,105.73027723886788,105.72142809997227,105.7125882471183,
	105.70375766108731,105.69493632271966,105.68612421291472,105.67732131263024,105.66852760288235,
	105.6597430647453,105.65096767935125,105.64220142788992,105.63344429160844,105.62469625181116,
	105.61595728985927,105.60722738717078,105.5985065252201,105.58979468553795,105.581091849711,
	105.5723979993818,105.56371311624842,105.55503718206435,105.54637017863816,105.5377120878333,
	105.52906289156803,105.52042257181498,105.51179111060108,105.50316849000735,105.49455469216853,
	105.48594969927308,105.4773534935628,105.46876605733267,105.46018737293075,105.45161742275772,
	105.44305618926697,105.43450365496415,105.42595980240701,105.41742461420542,105.4088980730208,
	105.4003801615662,105.39187086260607,105.38337015895576,105.37487803348178,105.36639446910125,
	105.35791944878181,105.34945295554155,105.34099497244858,105.33254548262101,105.32410446922665,
	105.31567191548285,105.30724780465637,105.29883212006322,105.29042484506816,105.28202596308489,
	105.27363545757568,105.26525331205123,105.25687951007038,105.24851403524012,105.24015687121513,
	105.23180800169796,105.22346741043845,105.2151350812338,105.20681099792841,105.1984951444135,
	105.19018750462709,105.18188806255372,105.17359680222444,105.16531370771636,105.15703876315278,
	105.14877195270284,105.14051326058123,105.1322626710483,105.12402016840967,105.11578573701614,
	105.10755936126358,105.0993410255926,105.09113071448841,105.08292841248084,105.07473410414396,
	105.06654777409595,105.05836940699912,105.05019898755943,105.04203650052658,105.03388193069367,
	105.02573526289726,105.0175964820169,105.0094655729753,105.00134252073784,104.99322731031266,
	104.98511992675047
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	249.99944335464136,249.99943114245013,249.99941866241159,249.9994059086539,249.99939287517668,
	249.99937955584812,249.99936594440217,249.99935203443545,249.99933781940442,249.9993232926222,
	249.99930844725543,249.99929327632125,249.99927777268377,249.9992619290509,249.99924573797088,
	249.99922919182876,249.99921228284293,249.9991950030614,249.99917734435806,249.99915929842896,
	249.99914085678827,249.99912201076458,249.99910275149654,249.99908306992887,249.99906295680813,
	249.99904240267838,249.99902139787673,249.9989999325287,249.99897799654394,249.99895557961122,
	249.99893267119367,249.99890926052393,249.99888533659902,249.99886088817522,249.99883590376294,
	249.99881037162123,249.9987842797523,249.99875761589593,249.99873036752376,249.99870252183348,
	249.99867406574276,249.9986449858832,249.9986152685941,249.9985848999161,249.99855386558457,
	249.9985221510231,249.99848974133664,249.99845662130446,249.99842277537314,249.99838818764945,
	249.9983528418927,249.99831672150734,249.99827980953518,249.9982420886474,249.99820354113675,
	249.99816414890898,249.9981238934746,249.99808275594026,249.99804071699998,249.99799775692605,
	249.99795385556,249.9979089923032,249.99786314610714,249.99781629546385,249.99776841839582,
	249.99771949244573,249.99766949466616,249.99761840160875,249.99756618931355,249.99751283329772,
	249.99745830854417,249.9974025894901,249.997345650015,249.99728746342873,249.99722800245883,
	249.9971672392382,249.99710514529207,249.99704169152488,249.9969768482066,249.9969105849592,
	249.99684287074263,249.99677367384018,249.99670296184416,249.9966307016406,249.9965568593943,
	249.99648140053284,249.99640428973098,249.99632549089395,249.9962449671412,249.99616268078913,
	249.99607859333383,249.99599266543333,249.99590485688938,249.99581512662908,249.99572343268582,
	249.99562973218013,249.99553398129993,249.9954361352802,249.99533614838262,249.99523397387455,
	249.99512956400733,249.9950228699948,249.99491384199052,249.99480242906498,249.9946885791825,
	249.99457223917713,249.99445335472842,249.9943318703366,249.99420772929705,249.99408087367453,
	249.99395124427662,249.99381878062667,249.99368342093632,249.99354510207706,249.9934037595518,
	249.99325932746507,249.9931117384934,249.99296092385444,249.99280681327565,249.9926493349625,
	249.9924884155657,249.99232398014806,249.99215595215028,249.9919842533565,249.99180880385848,
	249.99162952201988,249.99144632443878,249.99125912591043,249.9910678393885,249.99087237594574,
	249.9906726447341,249.99046855294338,249.99026000575972,249.99004690632282,249.9898291556823,
	249.98960665275322,249.98937929427083,249.98914697474402,249.98890958640817,249.98866701917663,
	249.9884191605918,249.9881658957746,249.98790710737313,249.98764267551033,249.98737247773045,
	249.98709638894468,249.98681428137525,249.98652602449863,249.98623148498763,249.9859305266522,
	249.98562301037904,249.98530879406997,249.98498773257907,249.9846596776485,249.98432447784327,
	249.98398197848405,249.98363202157952,249.9832744457565,249.98290908618927,249.98253577452715,
	249.9821543388207,249.98176460344655,249.98136638903048,249.98095951236928,249.98054378635072,
	249.98011901987215,249.9796850177575,249.97924158067232,249.97878850503756,249.9783255829413,
	249.97785260204907,249.97736934551193,249.97687559187318,249.97637111497318,249.97585568385193,
	249.97532906265025,249.97479101050868,249.97424128146454,249.97367962434703,249.97310578267025,
	249.97251949452402,249.97192049246289,249.97130850339272,249.97068324845534,249.9700444429107,
	249.96939179601716,249.96872501090917,249.96804378447254,249.96734780721803,249.9666367631517,
	249.9659103296433,249.965168177292,249.96440996979004,249.963635363783,249.9628440087283,
	249.96203554675077,249.9612096124953,249.96036583297717,249.95950382742944,249.9586232071476,
	249.9577235753314,249.95680452692378,249.95586564844686,249.95490651783513,249.95392670426543,
	249.95292576798408,249.951903260131,249.95085872256027,249.94979168765815,249.9487016781576,
	249.9475882069494,249.94645077689037,249.94528888060788,249.94410200030148,249.9428896075405,
	249.941651163059,249.94038611654634,249.93909390643512,249.93777395968496,249.93642569156282,
	249.93504850542004,249.93364179246518,249.93220493153345,249.93073728885238,249.92923821780388,
	249.927707058682,249.92614313844746,249.92454577047772,249.92291425431372,249.92124787540232,
	249.9195459048346,249.91780759908085,249.91603219972086,249.91421893317045,249.91236701040387,
	249.91047562667237,249.9085439612182,249.90657117698467,249.9045564203225,249.9024988206912,
	249.9003974903568,249.89825152408542,249.89605999883247,249.89382197342758,249.89153648825558,
	249.889202564933,249.88681920598057,249.88438539449152,249.88190009379548,249.87936224711842,
	249.87677077723822,249.87412458613636,249.8714225546452,249.86866354209127,249.86584638593462,
	249.86296990140377,249.86003288112693,249.85703409475926,249.85397228860606,249.85084618524203,
	249.84765448312714,249.84439585621794,249.8410689535759,249.83767239897196,249.8342047904872,
	249.8306647001102,249.82705067333134,249.8233612287332,249.8195948575783,249.81575002339324,
	249.81182516155036,249.80781867884616,249.80372895307715,249.79955433261298,249.79529313596726,
	249.79094365136575,249.78650413631266,249.78197281715478,249.777347888644,249.77262751349775,
	249.76780982195822,249.7628929113504,249.75787484563867,249.75275365498285,249.74752733529363,
	249.74219384778712,249.7367511185398,249.73119703804304,249.72552946075834,249.71974620467296,
	249.71384505085638,249.70782374301803,249.70167998706654,249.69541145067058,249.68901576282184,
	249.68249051340058,249.67583325274364,249.66904149121603,249.66211269878545,249.65504430460106,
	249.64783369657624,249.6404782209762,249.63297518201028,249.62532184143024,249.61751541813356,
	249.60955308777432,249.60143198237915,249.59314918997225,249.58470175420658,249.5760866740039,
	249.5673009032036,249.55834135022036,249.54920487771122,249.53988830225376,249.53038839403382,
	249.5207018765453,249.51082542630147,249.50075567255854,249.49048919705223,249.48002253374761,
	249.46935216860348,249.4584745393507,249.44738603528612,249.43608299708248,249.42456171661405,
	249.4128184368002,249.40084935146555,249.38865060521917,249.37621829335237,249.3635484617554,
	249.35063710685523,249.337480175573,249.3240735653032,249.31041312391488,249.29649464977516,
	249.28231389179567,249.26786654950305,249.25314827313366,249.23815466375268,249.22288127339985,
	249.20732360525977,249.19147711385992,249.17533720529545,249.15889923748156,249.14215852043424,
	249.12511031657976,249.1077498410935,249.09007226226794,249.07207270191168,249.05374623577833,
	249.03508789402701,249.01609266171377,248.99675547931525,248.97707124328417,248.95703480663772,
	248.9366409795784,248.91588453014808,248.8947601849152,248.87326262969597,248.85138651030866,
	248.82912643336206,248.80647696707814,248.78343264214826,248.75998795262365,248.73613735684043,
	248.7118752783779,248.68719610705145,248.6620941999391,248.63656388244172,248.61059944937688,
	248.58419516610599,248.55734526969437,248.53004397010403,248.50228545141886,248.4740638731015,
	248.445373371282,248.41620806007688,248.38656203293934,248.35642936403832,248.32580410966773,
	248.2946803096832,248.26305198896742,248.2309131589217,248.19825781898422,248.165079958173,
	248.13137355665413,248.0971325873324,248.06235101746498,248.02702281029644,247.99114192671385,
	247.95470232692134,247.9176979721325,247.8801228262799,247.84197085774005,247.80323604107295,
	247.76391235877446,247.72399380304094,247.68347437754375,247.64234809921342,247.60060900003126,
	247.55825112882684,247.5152685530812,247.47165536073265,247.42740566198486,247.38251359111513,
	247.33697330828198,247.2907790013296,247.24392488758897,247.19640521567237,247.14821426726175,
	247.09934635888783,247.04979584369912,246.99955711321974,246.94862459909322,246.89699277481273,
	246.8446561574339,246.79160930927125,246.7378468395749,246.68336340618683,246.6281537171758,
	246.57221253244828,246.5155346653354,246.4581149841539,246.39994841373954,246.34102993695276,
	246.28135459615385,246.2209174946482,246.15971379809875,246.0977387359061,246.03498760255403,
	245.97145575892017,245.90713863355052,245.84203172389695,245.77613059751678,245.70943089323387,
	245.64192832226036,245.57361866927758,245.50449779347716,245.4345616295597,245.36380618869237,
	245.29222755942314,245.21982190855283,245.1465854819633,245.07251460540226,244.99760568522368,
	244.9218552090848,244.84525974659786,244.76781594993784,244.6895205544054,244.61037037894548,
	244.53036232662097,244.44949338504205,244.36776062675108,244.28516120956346,244.2016923768644,
	244.1173514578619,244.03213586779643,243.9460431081079,243.85907076655917,243.7712165173185,
	243.68247812099935,243.59285342465964,243.5023403617601,243.41093695208278,243.31864130161,
	243.22545160236476,243.13136613221332,243.03638325462973,242.9405014184249,242.84371915743893,
	242.7460350901991,242.64744791954337,242.5479564322107,242.447559498399,242.34625607129118,
	242.244045186551,242.14092596178855,242.03689759599757,241.93195936896407,241.82611064064855,
	241.7193508505419,241.6116795169961,241.5030962365311,241.39360068311788,241.28319260744004,
	241.17187183613345,241.05963827100604,240.9464918882376,240.8324327375619,240.71746094143055,
	240.6015766941609,240.48478026106812,240.36707197758219,240.24845224835175,240.12892154633445,
	240.00848041187575,239.88712945177616,239.76486933834863,239.64170080846617,239.517624662601,
	239.39264176385618,239.26675303698985,239.1399594674336,239.01226210030543,238.88366203941806,
	238.75416044628298,238.62375853911215,238.4924575918165,238.3602589330027,238.22716394496933,
	238.0931740627021,237.95829077286933,237.82251561281842,237.6858501695733,237.54829607883423,
	237.40985502397984,237.27052873507228,237.1303189878657,236.98922760281923,236.8472564441139,
	236.7044074186751,236.56068247519988,236.41608360319063,236.27061283199447,236.12427222984977,
	235.9770639029392,235.82898999445047,235.68005268364428,235.53025418493118,235.37959674695534,
	235.2280826516882,235.07571421352995,234.92249377842097,234.76842372296161,234.6135064535426,
	234.45774440548402,234.3011400421852,234.1436958542843,233.98541435882777,233.82629809845128,
	233.6663496405699,233.50557157658008,233.3439665210716,233.18153711105103,233.01828600517547,
	232.85421588299832,232.68932944422494,232.52362940798062,232.3571185120891,232.18979951236233,
	232.02167518190205,231.85274831041212,231.6830217035221,231.51249818212287,231.34118058171268,
	231.169071751755,230.99617455504756,230.82249186710237,230.64802657553724,230.47278157947832,
	230.2967597889738,230.11996412441857,229.94239751598994,229.76406290309433,229.58496323382477,
	229.40510146442907,229.22448055878905,229.04310348790995,228.86097322942075,228.67809276708473,
	228.49446509032055,228.3100931937334,228.1249800766563,227.93912874270202,227.75254219932404,
	227.56522345738813,227.37717553075333,227.1884014358626,226.99890419134314,226.80868681761586,
	226.61775233651446,226.42610377091341,226.23374414436532,226.04067648074675,225.84690380391345,
	225.65242913736395,225.45725550391197,225.26138592536665,225.06482342222245,224.86757101335573,
	224.66963171573065,224.47100854411264,224.27170451078956,224.07172262530085,223.8710658941743,
	223.66973732067058,223.46773990453434,223.2650766417539,223.061750524327,222.85776454003422,
	222.6531216722191,222.44782489957535,222.24187719594045,222.03528153009628,221.82804086557604,
	221.6201581604775,221.41163636728282,221.20247843268442,220.99268729741704,220.78226589609565,
	220.57121715705944,220.35954400222172,220.1472493469251,219.93433609980303,219.720807162646,
	219.50666543027415,219.29191379041418,219.0765551235827,218.86059230297386,218.6440281943525,
	218.42686565595244,218.20910753837947,217.99075668451937,217.77181592945095,217.55228810036346,
	217.33217601647883,217.1114824889791,216.89021032093729,216.66836230725403,216.44594123459763,
	216.22294988134914,215.99939101755183,215.7752674048643,215.55058179651886,215.3253369372832,
	215.09953556342668,214.87318040269116,214.64627417426505,214.4188195887621,214.1908193482041,
	213.96227614600775,213.73319266697513,213.50357158728877,213.2734155745101,213.0427272875824,
	212.81150937683745,212.57976448400632,212.34749524223363,212.11470427609686,211.8813942016285,
	211.64756762634278,211.4132271492666,211.17837536097375,210.9430148436243,210.70714817100702,
	210.47077790858654,210.23390661355464,209.99653683488555,209.75867111339574,209.52031198180762,
	209.2814619648184,209.04212357917248,208.80229933373911,208.56199172959398,208.32120326010622,
	208.0799364110293,207.83819366059768,207.59597747962758,207.3532903316236,207.11013467288953,
	206.86651295264562,206.62242761315034,206.37788108982795,206.13287581140202,205.8874142000345,
	205.64149867147083,205.3951316351913,205.14831549456864,204.9010526470324,204.65334548423957,
	204.40519639225246,204.1566077517237,203.90758193808847,203.6581213217643,203.4082282683587,
	203.15790513888496,202.90715428998635,202.6559780741686,202.40437884004146,202.15235893256988,
	201.89992069333388,201.64706646079935,201.39379857059734,201.14011935581624,200.88603114730296,
	200.6315362739762,200.37663706315152,200.1213358408781,199.86563493228863,199.60953666196173,
	199.35304335429822,199.09615733391126,198.83888092603104,198.58121645692438,198.3231662543301,
	198.06473264791052,197.80591796971962,197.5467245546888,197.2871547411304,197.02721087126008,
	196.7668952917385,196.50621035423347,196.2451584160022,195.98374184049598,195.72196299798676,
	195.4598242662172,195.19732803107468,194.93447668729064,194.67127263916538,194.40771830132005,
	194.14381609947645,193.8795684712657,193.61497786706684,193.3500467508763,193.08477760120985,
	192.81917291203766,192.55323519375386,192.2869669741821,192.02037079961784,191.75344923590916,
	191.48620486957753,191.2186403089793,190.95075818551015,190.68256115485343,190.4140518982742,
	190.14523312396042,189.8761075684132,189.60667799788712,189.33694720988314,189.06691803469545,
	188.79659333701403,188.5259760175847,188.25506901492912,187.9838753071259,187.7123979136553,
	187.44063989730972,187.16860436617117,186.89629447565895,186.62371343064905,186.3508644876676,
	186.07775095716022,185.80437620584073,185.5307436591197,185.256856803617,184.98271918975917,
	184.70833443446512,184.43370622392183,184.15883831645283,183.88373454548147,183.60839882259177,
	183.3328351406891,183.05704757726298,182.78104029775443,182.50481755903016,182.22838371296587,
	181.95174321014073,181.67490060364582,181.39786055300763,181.12062782822935,180.84320731395155,
	180.56560401373417,180.28782305446126,180.00986969086966,179.73174931020395,179.45346743699733,
	179.17502973798034,178.89644202711756,178.6177102707729,178.3388405930031,178.0598392809796,
	177.78071279053762,177.50146775185215,177.2221109752385,176.94264945707593,176.6630903858542,
	176.38344114832603,176.103709335796,175.82390275049718,175.5440294120835,175.2640975642183,
	174.98411568125687,174.704092475013,174.42403690160413,174.14395816836384,173.86386574081303,
	173.58376934967825,173.30367899794464,173.02360496793094,172.74355782837154,172.46354844148948,
	172.18358797004427,171.90368788433506,171.62385996914006,171.34411633057047,171.06446940281637,
	170.78493195476017,170.5055170964317,170.22623828527762,169.94710933221603,169.6681444074463,
	169.38935804598012,169.11076515286265,168.83238100804599,168.55422127087937,168.276301984178,
	167.9986395778298,167.7212508719,167.44415307919104,167.16736380721454,166.8909010595314,
	166.61478323641438,166.33902913478894,166.06365794740535,165.78868926119617,165.51414305477428,
	165.24003969502468,164.96639993274638,164.69324489730005,164.4205960902198,164.1484753777478,
	163.87690498225416,163.60590747250572,163.33550575275146,163.06572305059467,162.79658290362661,
	162.5281091448006,162.26032588652947,161.99325750349578,161.72692861416857,161.46136406102707,
	161.196588889498,160.93262832562033,160.66950775245724,160.4072526852839,160.1458887455861,
	159.885441633913,159.62593710163557,159.36740092166943,159.10985885822902,158.85333663568832,
	158.59785990663102,158.34345421917908,158.090144983698,157.83795743898236,157.5869166180309,
	157.33704731352836,157.08837404315315,156.84092101483702,156.59471209210494,156.34977075962578,
	156.10612008910726,155.8637827056685,155.6227807548235,155.38313587020855,155.14486914218233,
	154.9080010874274,154.67255161967458,154.43854002166847,154.2059849184859,153.97490425231177,
	153.7453152587704,153.51723444489966,153.29067756884922,153.06565962137196,152.8421948091694,
	152.62029654014003,152.39997741057059,152.18124919429755,151.96412283385655,151.74860843362663,
	151.53471525496445,151.32245171331434,151.11182537726975,150.9028429695519,150.6955103698619,
	150.48983261955524,150.28581392807806,150.0834576810993,149.88276645026426,149.68374200449105,
	149.48638532272557,149.29069660806647,149.09667530316855,148.90432010682989,148.71362899166635,
	148.52459922277603,148.33722737729573,148.1515093647506,147.96744044810157,147.7850152653931,
	147.6042278519089,147.42507166274277,147.24753959569784,147.07162401442642,146.89731677173074,
	146.72460923294528,146.55349229932628,146.38395643138017,146.21599167206318,146.04958766979263,
	145.8847337012122,145.72141869365953,145.55963124728783,145.399359656799,145.24059193274732,
	145.08331582238156,144.92751882999212,144.77318823673787,144.62031111992945,144.46887437174894,
	144.3188647173906,144.1702687326098,144.02307286066966,143.8772634286798,143.73282666332221,
	143.5897487059624,143.4480156271471,143.3076134404904,143.1685281159534,143.03074559252352,
	142.89425179030096,142.75903262200205,142.62507400388955,142.4923618661417,142.36088216267208,
	142.23062088041414,142.10156404808336,141.97369774443305,141.84700810601728,141.72148133447678,
	141.59710370336367,141.4738615645207,141.35174135403003,141.23072959774896,141.11081291644675,
	140.99197803055947,140.87421176457815,140.75750105108528,140.6418329344554,140.5271945742344,
	140.41357324821172,140.30095635520132,140.1893314175429,140.0786860833394,139.9690081284423,
	139.86028545819877,139.75250610897183,139.64565824944702,139.53973018173588,139.43471034228813,
	139.33058730262383,139.22734976987104,139.1249865872644,139.02348673424555,138.92283932667652,
	138.82303361678976,138.72405899304107,138.62590497984678,138.52856123721216,138.43201756025954,
	138.336263878662,138.24129025599046,138.14708688897923,138.05364410671748,137.9609523697715,
	137.86900226924283,137.77778452576914,137.6872899884705,137.59750963384758,137.50843456463514,
	137.42005600861543,137.3323653173948,137.24535396514835,137.15901354733495,137.0733357793867,
	136.98831249537542,136.90393564665962,136.82019730051402,136.73708963874512,136.65460495629404,
	136.57273565983007,136.49147426633613,136.4108134016891,136.33074579923544,136.25126429836556,
	136.17236184308695,136.0940314805989,136.01626635986906,135.93905973021404,135.86240493988487,
	135.78629543465806,135.71072475643427,135.6356865418445,135.56117452086517,135.48718251544298,
	135.41370443813014,135.34073429073032,135.26826616295673,135.19629423110194,135.1248127567207,
	135.05381608532588,134.98329864509765,134.91325494560706,134.8436795765537,134.77456720651753,
	134.70591258172578,134.63771052483506,134.56995593372812,134.5026437803262,134.43576910941673,
	134.3693270374967,134.30331275163152,134.2377215083292,134.17254863243105,134.1077895160171,
	134.0434396173279,133.9794944597016,133.91594963052694,133.8528007802113,133.79004362116507,
	133.72767392680043,133.66568753054642,133.6040803248784,133.5428482603634,133.4819873447197,
	133.4214936418919,133.3613632711405,133.3015924061459,133.2421772741271,133.1831141549747,
	133.1243993803978,133.06602933308525,133.00800044588024,132.9503092009692,132.8929521290834,
	132.83592580871462,132.77922686534345,132.72285197068078,132.66679784192215,132.61106124101426,
	132.55563897393466,132.50052788998312,132.44572488108508,132.39122688110754,132.337030865186,
	132.28313384906338,132.22953288844016,132.17622507833576,132.12320755246074,132.0704774826003,
	132.0180320780078,131.96586858480939,131.91398428541845,131.86237649796064,131.81104257570857,
	131.75997990652638,131.7091859123241,131.65865804852166,131.60839380352132,131.5583906981906,
	131.50864628532813,131.45915814926633,131.4099239052229,131.36094119892556,131.31220770611043,
	131.263721132056,131.21547921112506,131.167479706315,131.11972040881568,131.07219913757484,
	131.02491373887142,130.97786208589596,130.9310420783385,130.88445164198342,130.83808872831156,
	130.79195131410887,130.7460374010822,130.70034501548147,130.65487220772843,130.60961705205193,
	130.56457764612927,130.5197521107338,130.47513858938888,130.4307352480271,130.386540274656,
	130.34255187902937,130.2987682923237,130.25518776682097,130.21180857559608,130.16862901221,
	130.1256473904082,130.08286204382406,130.04027132568717,129.99787360853693,129.95566728394076,
	129.913650762217,129.8718224721627,129.83018086078596,129.78872439304251,129.74745155157711,
	129.70636083646895,129.66545076498147,129.6247198713164,129.5841667063717,129.54378983750388,
	129.50358784829368,129.46355933831651,129.4237029229158,129.38401723298057,129.34450091472678,
	129.3051526294819,129.26597105347332,129.22695487762,129.18810280732788,129.1494135622882,
	129.1108858762795,129.07251849697246,129.0343101857386,128.99625971746096,128.95836588034894,
	128.92062747575568,128.88304331799833,128.8456122341811,128.8083330640217,128.77120465967997,
	128.73422588558947,128.69739561829195,128.66071274627416,128.62417616980744,128.58778480078968,
	128.5515375625902,128.5154333898964,128.4794712285635,128.44365003546645,128.40796877835365,
	128.3724264357039,128.33702199658467,128.30175446051342,128.26662283732037,128.23162614701366,
	128.1967634196469,128.16203369518843,128.12743602339242,128.09296946367263,128.0586330849775,
	128.02442596566723,127.99034719339325,127.95639586497884,127.92257108630197,127.88887197218,
	127.8552976462557,127.82184724088567,127.78851989702963,127.75531476414218,127.72223100006556,
	127.6892677709244,127.65642425102202,127.62369962273787,127.59109307642734,127.55860381032204,
	127.52623103043237,127.49397395045116,127.46183179165884,127.42980378282994,127.39788916014103,
	127.36608716708007,127.33439705435688,127.30281807981514,127.27134950834579,127.23999061180103,
	127.20874066891055,127.17759896519813,127.14656479289988,127.11563745088368,127.08481624456954,
	127.05410048585125,127.02348949301916,126.99298259068412,126.9625791097023,126.93227838710133,
	126.90207976600733,126.87198259557304,126.84198623090701,126.81209003300351,126.78229336867399,
	126.75259561047892,126.72299613666101,126.69349433107901,126.66408958314274,126.63478128774894,
	126.60556884521787,126.57645166123102,126.54742914676937,126.51850071805302,126.48966579648103,
	126.46092380857255,126.43227418590853,126.40371636507436,126.37524978760318,126.34687389992008,
	126.31858815328698,126.2903920037482,126.262284912077,126.23426634372255,126.2063357687578,
	126.1784926618281,126.15073650210032,126.12306677321274,126.09548296322575,126.0679845645729,
	126.04057107401297,126.01324199258242,125.98599682554851,125.95883508236311,125.93175627661708,
	125.90475992599532,125.87784555223223,125.85101268106797,125.82426084220519,125.79758956926631,
	125.77099839975136,125.7444868749965,125.71805454013275,125.69170094404579,125.66542563933567,
	125.63922818227749,125.61310813278249,125.58706505435926,125.56109851404717,125.53520808249661,
	125.50939333375219,125.4836538453382,125.45798919819116,125.43239897662478,125.40688276829428,
	125.38144016416206,125.35607075846309,125.33077414867132,125.30554993546615,125.28039772269938,
	125.25531711736275,125.23030772955558,125.20536917245308,125.18050106227506,125.15570301825473,
	125.1309746626082,125.10631562050422,125.08172552003431,125.05720399218328,125.03275067079998,
	125.00836519256882,124.98404719698088,124.95979632630625,124.93561222556609,124.91149454250518,
	124.88744292756503,124.863457033857,124.83953651713584,124.81568103577374,124.79189025073444,
	124.76816382554776,124.7445014262844,124.72090272153115,124.69736738236618,124.67389508233497,
	124.65048549742598,124.62713830604739,124.60385318900316,124.58062982947024,124.55746791297564,
	124.5343671273736,124.51132716282348,124.48834771176756,124.46542846890928,124.4425691311915,
	124.41976939777544,124.39702897001933,124.37434755145776,124.35172484778103,124.32916056681478,
	124.30665441849996,124.28420611487272,124.26181537004506,124.23948190018515,124.21720542349821,
	124.19498566020762,124.17282233253577,124.15071516468605,124.12866388282401,124.10666821505949,
	124.08472789142859,124.06284264387591,124.04101220623704,124.01923631422127,123.99751470539427,
	123.97584711916136,123.9542332967506,123.9326729811962,123.9111659173222,123.88971185172616,
	123.8683105327633,123.84696171053041,123.82566513685032,123.80442056525632,123.78322775097698,
	123.76208645092065,123.7409964236608,123.7199574294209,123.69896923006004,123.6780315890581,
	123.65714427150155,123.63630704406923,123.61551967501829,123.5947819341703,123.57409359289738,
	123.55345442410886,123.53286420223749,123.51232270322637,123.4918297045157,123.47138498502973,
	123.45098832516386,123.43063950677205,123.41033831315384,123.39008452904226,123.36987794059117,
	123.3497183353633,123.32960550231789,123.309539231799,123.28951931552328,123.26954554656879,
	123.24961771936287,123.229735629671,123.20989907458538,123.19010785251355,123.17036176316745,
	123.15066060755231,123.13100418795578,123.11139230793724,123.09182477231694,123.07230138716562,
	123.052821959794,123.03338629874236,123.01399421377042,122.9946455158471,122.97534001714068,
	122.95607753100859,122.93685787198784,122.91768085578511,122.89854629926715,122.87945402045146,
	122.86040383849654,122.84139557369275,122.82242904745301,122.80350408230362,122.78462050187522,
	122.76577813089384,122.74697679517195,122.72821632159975,122.70949653813648,122.69081727380153,
	122.67217835866632,122.65357962384554,122.635020901489,122.61650202477303,122.59802282789266,
	122.57958314605315,122.56118281546226,122.54282167332202,122.52449955782095,122.50621630812633,
	122.48797176437627,122.46976576767227,122.45159816007148,122.43346878457916,122.41537748514146,
	122.3973241066378,122.37930849487365,122.36133049657344,122.3433899593732,122.32548673181361,
	122.30762066333286,122.28979160425982,122.27199940580708,122.25424392006414,122.23652499999064,
	122.21884249940963,122.20119627300109,122.18358617629517,122.16601206566581,122.14847379832419,
	122.13097123231253,122.11350422649747,122.09607264056407,122.07867633500952,122.06131517113694,
	122.04398901104936,122.02669771764354,122.00944115460423,121.99221918639803,121.97503167826764,
	121.95787849622594,121.9407595070504,121.92367457827714,121.90662357819551,121.88960637584229,
	121.87262284099623,121.85567284417256,121.83875625661749,121.82187295030288,121.80502279792074,
	121.78820567287806,121.7714214492916,121.75467000198239,121.73795120647098,121.72126493897198,
	121.70461107638918,121.68798949631048,121.67140007700276,121.65484269740729,121.63831723713449,
	121.6218235764593,121.6053615963162,121.58893117829463,121.5725322046342,121.55616455821998,
	121.53982812257782,121.52352278186994,121.50724842089022,121.49100492505966,121.47479218042203,
	121.45861007363935,121.44245849198755,121.42633732335202,121.4102464562234,121.39418577969325,
	121.37815518344979,121.3621545577737,121.34618379353397,121.3302427821837,121.31433141575612,
	121.29844958686043,121.2825971886778,121.26677411495734,121.2509802600122,121.23521551871565,
	121.21947978649708,121.20377295933831,121.1880949337696,121.17244560686594,121.1568248762433,
	121.14123264005485,121.12566879698736,121.11013324625732,121.09462588760759,121.07914662130361,
	121.06369534812987,121.04827196938633,121.03287638688502,121.01750850294648,121.00216822039621,
	120.98685544256138,120.97157007326744,120.95631201683469,120.9410811780749,120.92587746228804,
	120.91070077525913,120.89555102325471,120.88042811301982,120.86533195177472,120.85026244721172,
	120.83521950749196,120.82020304124252,120.80521295755295,120.79024916597251,120.77531157650698,
	120.76040009961568,120.7455146462084,120.73065512764255,120.71582145572005,120.70101354268452,
	120.68623130121836,120.67147464443983,120.65674348590022,120.64203773958101,120.62735731989109,
	120.61270214166382,120.59807212015457,120.58346717103768,120.56888721040382,120.55433215475743,
	120.53980192101386,120.52529642649672,120.5108155889355,120.49635932646254,120.48192755761085,
	120.46752020131125,120.45313717686146,120.43877840403856,120.42444380292221,120.4101332940096,
	120.39584679818317,120.3815842367083,120.36734553123085,120.35313060377473,120.33893937673936,
	120.32477177289755,120.31062771539301,120.296507127738,120.28240993381097,120.26833605785438,
	120.2542854244723,120.24025795862823,120.22625358564274,120.21227223119132,120.19831382130216,
	120.18437828235398,120.17046554107363,120.15657552453428,120.14270816015298,120.12886337568868,
	120.11504109924002,120.10124125924331,120.08746378447042,120.07370860402662,120.05997564734882,
	120.04626484420297,120.03257612468273,120.01890941920698,120.00526465851799,119.99164177367938,
	119.97804069607429,119.9644613574033,119.95090368968253,119.93736762524185,119.92385309672271,
	119.91036003707652,119.89688837956267,119.88343805774659,119.87000900549803,119.85660115698923,
	119.8432144466929,119.8298488093807,119.81650418012126,119.80318049427844,119.78987768750956,
	119.77659569576373,119.76333445527999,119.75009390258562,119.73687397449449,119.72367460810524,
	119.71049574079976,119.69733731024134,119.68419925437307,119.67108151141628,119.65798401986872,
	119.64490671850308,119.63184954636527,119.61881244277296,119.6057953473138,119.59279819984401,
	119.57982094048664,119.5668635096302,119.55392584792692,119.5410078962914,119.52810959589891,
	119.51523088818405,119.50237171483906,119.48953201781246,119.47671173930756,119.46391082178096,
	119.45112920794101,119.43836684074653,119.42562366340519,119.41289961937228,119.40019465234906,
	119.38750870628152,119.37484172535899,119.36219365401256,119.3495644369139,119.33695401897383,
	119.32436234534092,119.31178936140016,119.29923501277167,119.28669924530924,119.27418200509918,
	119.26168323845883,119.2492028919354,119.23674091230463,119.2242972465694,119.21187184195863,
	119.1994646459259,119.18707560614821,119.17470467052468,119.16235178717544,119.15001690444028,
	119.13769997087743,119.12540093526248,119.11311974658695,119.10085635405726,119.08861070709345,
	119.0763827553281,119.06417244860504,119.05197973697815,119.03980457071047,119.02764690027267,
	119.0155066763422,119.00338384980198,118.99127837173937,118.97919019344506,118.96711926641183,
	118.95506554233364,118.94302897310428,118.93100951081654,118.91900710776096,118.90702171642472,
	118.8950532894909,118.88310177983689,118.87116714053379,118.85924932484511,118.84734828622582,
	118.83546397832139,118.82359635496657,118.81174537018451,118.79991097818576,118.78809313336721,
	118.77629179031103,118.76450690378388,118.75273842873564,118.74098632029873,118.72925053378685,
	118.71753102469432,118.70582774869479,118.69414066164052,118.68246971956144,118.67081487866396,
	118.65917609533031,118.64755332611753,118.63594652775649,118.62435565715096,118.61278067137677,
	118.60122152768098,118.58967818348069,118.57815059636249,118.56663872408137,118.55514252455988,
	118.54366195588723,118.53219697631852,118.52074754427375,118.50931361833706,118.49789515725577,
	118.48649211993967,118.47510446546003,118.4637321530489,118.45237514209812,118.4410333921587,
	118.42970686293977,118.41839551430796,118.4070993062865,118.39581819905435,118.38455215294556,
	118.37330112844836,118.36206508620432,118.35084398700772,118.33963779180468,118.32844646169237,
	118.31726995791824,118.30610824187933,118.29496127512145,118.28382901933838,118.27271143637122,
	118.2616084882075,118.25052013698067,118.23944634496914,118.22838707459563,118.21734228842644,
	118.2063119491707,118.19529601967976,118.18429446294633,118.17330724210386,118.16233432042577,
	118.15137566132489,118.14043122835248,118.1295009851979,118.11858489568756,118.10768292378465,
	118.09679503358797,118.0859211893317,118.0750613553844,118.06421549624861,118.05338357655991,
	118.04256556108656,118.03176141472859,118.02097110251725,118.01019458961443,117.99943184131189,
	117.98868282303071,117.97794750032061,117.96722583885932,117.95651780445205,117.94582336303066,
	117.93514248065327,117.92447512350346,117.91382125788974,117.903180850245,117.89255386712578,
	117.8819402752117,117.87134004130498,117.86075313232968,117.8501795153312,117.83961915747571,
	117.82907202604953,117.81853808845847,117.80801731222742,117.79750966499971,117.7870151145364,
	117.77653362871601,117.76606517553363,117.75560972310063,117.74516723964386,117.73473769350537,
	117.72432105314158,117.71391728712295,117.70352636413334,117.69314825296948,117.68278292254041,
	117.67243034186698,117.66209048008135,117.6517633064264,117.64144879025525,117.63114690103066,
	117.62085760832458,117.61058088181777,117.60031669129891,117.59006500666453,117.57982579791809,
	117.56959903516996,117.55938468863633,117.54918272863931,117.53899312560596,117.52881585006797,
	117.51865087266141,117.50849816412583,117.49835769530404,117.4882294371415,117.47811336068601,
	117.46800943708706,117.45791763759541,117.44783793356264,117.43777029644077,117.42771469778158,
	117.41767110923637,117.40763950255533,117.39761984958716,117.38761212227872,117.3776162926744,
	117.36763233291572,117.35766021524094,117.34769991198458,117.33775139557703,117.32781463854397,
	117.31788961350613,117.30797629317873,117.29807465037099,117.28818465798597,117.27830628901981,
	117.26843951656146,117.25858431379238,117.24874065398592,117.23890851050692,117.22908785681147,
	117.21927866644633,117.20948091304861,117.19969457034526,117.18991961215285,117.1801560123769,
	117.17040374501177,117.16066278414007,117.1509331039323,117.14121467864648,117.13150748262773,
	117.12181149030803,117.11212667620552,117.10245301492438,117.09279048115442,117.08313904967055,
	117.07349869533259,117.06386939308472,117.05425111795526,117.04464384505611,117.0350475495826,
	117.02546220681299,117.0158877921081,117.00632428091096,116.99677164874655,116.98722987122123,
	116.97769892402258,116.96817878291893,116.95866942375903,116.94917082247179,116.93968295506573,
	116.93020579762877,116.920739326328,116.91128351740898,116.90183834719578,116.89240379209035,
	116.88297982857245,116.873566433199,116.86416358260398,116.85477125349803,116.84538942266815,
	116.83601806697723,116.82665716336389,116.8173066888421,116.80796662050078,116.79863693550355,
	116.78931761108848,116.78000862456753,116.77070995332653,116.76142157482462,116.75214346659409,
	116.74287560624003,116.73361797143994,116.72437053994351,116.71513328957226,116.70590619821928,
	116.69668924384892,116.6874824044964,116.67828565826763,116.66909898333886,116.65992235795629,
	116.65075576043596,116.64159916916336,116.63245256259299,116.62331591924838,116.61418921772147,
	116.60507243667266,116.59596555483013,116.5868685509899,116.5777814040154,116.56870409283712,
	116.55963659645248,116.55057889392543,116.54153096438618,116.5324927870311,116.52346434112211,
	116.5144456059867,116.50543656101756,116.49643718567225,116.487447459473,116.4784673620065,
	116.46949687292336,116.46053597193823,116.45158463882923,116.44264285343789,116.43371059566869,
	116.42478784548895,116.41587458292854,116.40697078807963,116.39807644109638,116.38919152219468,
	116.38031601165201,116.37144988980702,116.3625931370595,116.35374573386983,116.344907660759,
	116.33607889830826,116.32725942715884,116.31844922801177,116.3096482815962,116.30085656879568,
	116.29207407045664,116.28330076751679,116.27453664097233,116.26578167187783,116.2570358413459,
	116.24829913054698,116.23957152070928,116.23085299311815,116.22214352911632,116.21344311010326,
	116.20475171753523,116.19606933292499,116.18739593784142,116.17873151390951,116.17007604280997,
	116.16142950627903,116.15279188610843,116.14416316414486,116.13554332228992,116.12693234249997,
	116.11833020678581,116.10973689721239,116.10115239589871,116.09257668501766,116.08400974679569,
	116.07545156351256,116.06690211750127,116.05836139114777,116.04982936689075,116.04130602722141,
	116.03279135468328,116.02428533187211,116.01578794143542,116.00729916607254,115.99881898853435,
	115.99034739162288,115.9818843581914,115.973429871144,115.96498391343563,115.95654646807148,
	115.94811751810735,115.93969704664886,115.93128503685172,115.92288147192133,115.91448633511261,
	115.90609960972982,115.89772127912629,115.8893513267044,115.8809897359152,115.87263649025839,
	115.86429157328192,115.85595496858214,115.84762665980315,115.8393066306371,115.83099486482367,
	115.82269134614992,115.81439605845033,115.80610898560633,115.79783011154635,115.78955942024545,
	115.78129689572535,115.77304252205403,115.76479628334567,115.75655816376056,115.74832814750465,
	115.7401062188297,115.73189236203291,115.72368656145672,115.7154888014888,115.70729906656173,
	115.69911734115291,115.69094360978431,115.6827778570224,115.67462006747796,115.66647022580578,
	115.65832831670471,115.65019432491731,115.6420682352298,115.63395003247182,115.62583970151631,
	115.61773722727932,115.60964259471986,115.6015557888398,115.59347679468353,115.58540559733797,
	115.5773421819324,115.56928653363826,115.56123863766886,115.55319847927954,115.54516604376714,
	115.53714131647023,115.52912428276855,115.52111492808321,115.51311323787631,115.50511919765087,
	115.49713279295072,115.48915400936022,115.48118283250425,115.47321924804801,115.4652632416968,
	115.45731479919597,115.44937390633072,115.44144054892594,115.43351471284609,115.42559638399511,
	115.41768554831617,115.40978219179156,115.4018863004426,115.39399786032938,115.38611685755072,
	115.37824327824407,115.37037710858519,115.36251833478818,115.35466694310522,115.34682291982656,
	115.33898625128025,115.3311569238321,115.32333492388538,115.315520237881,115.30771285229707,
	115.2999127536488
	}}
};
table1d_imp<2001> tubetable2_JJECC83S[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	1943633466.7628152,1903700931.4244537,1864590824.445094,1826286148.2834516,1788770356.660751,
	1752027143.6745534,1716040522.3751423,1680794928.6430192,1646275115.0810032,1612466014.517785,
	1579353024.3433752,1546921774.5448568,1515158194.501256,1484048512.7498417,1453579255.626634,
	1423737188.3811047,1394509387.8477745,1365883200.0130503,1337846197.8517725,1310386225.1696613,
	1283491393.7318938,1257150039.7085874,1231350773.1533785,1206082390.2276046,1181333956.6392252,
	1157094755.754485,1133354268.8051782,1110102230.260395,1087328566.974705,1065023415.9313543,
	1043177119.138261,1021780214.1705561,1000823444.9882218,980297732.5696739,960194195.2783997,
	940504130.2746443,921219014.1717453,902330499.9998887,883830419.443701,865710769.504202,
	847963699.5622561,830581541.2417336,813556770.8202497,796882029.3858575,780550099.5221535,
	764553919.8849436,748886577.2329158,733541289.1592741,718511427.0732137,703790493.3259847,
	689372119.7575327,675250075.0523883,661418259.2077757,647870690.7933639,634601518.8139557,
	621605005.6233301,608875537.9527549,596407617.9704448,584195856.0019629,572234980.6009016,
	560519823.5631659,549045325.3363754,537806532.6233771,526798591.11807805,516016748.96830165,
	505456350.7012039,495112838.193635,484981746.0234157,475058702.19917226,465339423.91016483,
	455819717.4406849,446495474.5673216,437362673.2056481,428417373.5175464,419655715.36314446,
	411073921.36234564,402668289.5443733,394435194.3588221,386371086.1818495,378472488.83095235,
	370735996.4006995,363158272.9404347,355736053.3104127,348466138.54724663,341345394.6878303,
	334370754.1563439,327539210.8359296,320847822.17425644,314293705.2551471,307874037.1000798,
	301586052.243747,295427042.79498345,289394356.65702784,283485396.0731699,277697617.18721646,
	272028527.96638995,266475688.35571727,261036708.47001114,255709247.1648067,250491011.79319274,
	245379757.40346873,240373284.8872409,235469440.18235964,230666113.9579313,225961240.22841668,
	221352795.584968,216838798.3119613,212417307.44457692,208086422.00173166,203844280.16355205,
	199689058.5334906,195618971.08124945,191632268.75998706,187727238.3080879,183902201.90810025,
	180155516.29005232,176485571.90058032,172890792.42267936,169369633.97239175,165920584.39927956,
	162542162.75702038,159232918.44940093,155991430.89893502,152816308.62837097,149706188.8982544,
	146659737.0269439,143675645.67344764,140752634.57160687,137889449.60546264,135084862.63295224,
	132337670.7093258,129646695.6423275,127010783.50969064,124428804.05799928,121899650.3979211,
	119422238.31205946,116995505.94511078,114618413.25806513,112289941.62509103,110009093.33610654,
	107774891.24776217,105586378.26208779,103442617.03210445,101342689.40720117,99285696.19581191,
	97270756.64105745,95297008.12042943,93363605.75749634,91469722.01194891,89614546.40462741,
	87797285.08510338,86017160.52500647,84273411.20484118,82565291.22780855,80892070.06161207,
	79253032.15341145,77647476.6882475,76074717.24253704,74534081.50246486,73024910.97066377,
	71546560.67842293,70098398.91538796,68679806.95296352,67290178.770508,65928920.80052921,
	64595451.68061926,63289201.973673165,62009613.96181247,60756141.36601003,59528249.140637085,
	58325413.22490179,57147120.32868049,55992867.70107473,54862162.90890742,53754523.64612747,
	52669477.500384,51606561.76857949,50565323.24662699,49545318.03210747,48546111.34302628,
	47567277.32262198,46608398.853839636,45669067.38599907,44748882.758264154,43847453.018877685,
	42964394.264155865,42099330.472390704,41251893.335384846,40421722.10812613,39608463.447539434,
	38811771.262027,38031306.561356395,37266737.31395193,36517738.29906614,35783990.96990585,
	35065183.31433543,34361009.722461686,33671170.85382342,32995373.509536058,32333330.503653333,
	31684760.542307656,31049388.100676816,30426943.30539003,29817161.816788543,29219784.718966976,
	28634558.402858518,28061234.461836036,27499569.58147002,26949325.437572062,26410268.591173638,
	25882170.39076949,25364806.87061428,24857958.6570323,24361410.874440793,23874953.049505994,
	23398379.024816193,22931486.866997223,22474078.782408763,22025961.029758003,21586943.838608734,
	21156841.32732238,20735471.422517523,20322655.781774133,19918219.716434296,19521992.116730753,
	19133805.37807222,18753495.32963675,18380901.16272481,18015865.363092035,17658233.642600883,
	17307854.872281156,16964581.019060124,16628267.080588728,16298771.024281178,15975953.725448832,
	15659678.907902503,15349813.085830355,15046225.505863605,14748788.091528982,14457375.387990728,
	14171864.508296102,13892135.080761846,13618069.197345994,13349551.36292079,13086468.445935545,
	12828709.629792303,12576166.36548747,12328732.324949235,12086303.35545972,11848777.435053056,
	11616054.628897145,11388037.046393216,11164628.799146269,10945735.96003087,10731266.52292832,
	10521130.363304023,10315239.19958112,10113506.555389702,9915847.722570226,9722179.724837016,
	9532421.282291356,9346492.776631726,9164316.217149528,8985815.207242846,8810914.91179749,
	8639542.025186991,8471624.739883328,8307092.715723916,8145877.049912852,7987910.247487934,
	7833126.1924787825,7681460.11966135,7532848.586842509,7387229.447797475,7244541.825659243,
	7104726.086917691,6967723.815986522,6833477.790181825,6701931.955350716,6573031.401848461,
	6446722.341174406,6322952.08296252,6201669.0124861775,6082822.568637909,5966363.222337035,
	5852242.455424022,5740412.739898343,5630827.517710303,5523441.180857356,5418209.051928161,
	5315087.36507836,5214033.247342531,5115004.700360332,5017960.582482629,4922860.591219866,
	4829665.246083646,4738335.871743084,4648834.581563792,4561124.261451407,4475168.554064341,
	4390931.84330121,4308379.239160629,4227476.562874866,4148190.332355325,4070487.747951821,
	3994336.6784832785,3919705.6475738683,3846563.820254588,3774880.989852384,3704627.5651350934,
	3635774.5577361705,3568293.569818642,3502156.7820135476,3437336.941584272,3373807.3508518226,
	3311541.8558467375,3250514.8352006613,3190701.189254057,3132076.329406322,3074616.167664893,
	3018297.106425855,2963096.028449311,2908990.28705007,2855957.6964896433,2803976.522557379,
	2753025.4733527475,2703083.690255087,2654130.7390761357,2606146.601393463,2559111.6660691635,
	2513006.7209318727,2467812.9446372096,2423511.898692727,2380085.5196443037,2337516.1114265854,
	2295786.337869398,2254879.215355132,2214778.105628703,2175466.7087570177,2136929.056228578,
	2099149.5041972455,2062112.7268646746,2025803.7099966453,1990207.7445753212,1955310.4205779172,
	1921097.6208849477,1887555.515315045,1854670.5547780402,1822429.4655511908,1790819.2436713194,
	1759827.149442827,1729440.7020554908,1699647.6743174314,1670436.0874912234,1641794.2062383874,
	1613710.5336663665,1586173.806478155,1559172.9902201775,1532697.274627237,1506736.0690635657,
	1481278.9980579645,1456315.8969274797,1431836.8074939405,1407831.9738861953,1384291.838428456,
	1361207.037613403,1338568.398157166,1316366.9331345824,1294593.8381949053,1273240.4878526377,
	1252298.4318566143,1231759.3916313057,1211615.2567919134,1191858.0817299227,1172480.0822694483,
	1153473.6323904747,1134831.2610198108,1116545.6488874,1098609.625446804,1081016.16585795,
	1063758.3880321211,1046829.5497367907,1030223.0457591017,1013932.4051281804,997951.2883927744,
	982273.4849547466,966892.9104575732,951803.6042264443,936999.7267620405,922475.557283917,
	908225.4913246142,894244.038372536,880525.8195621505,867065.5654117853,853858.1136068057,
	840898.4068281185,828181.4906243797,815702.5113274502,803456.7140103115,791439.4404857701,
	779646.1273464124,768072.3040436017,756713.5910056086,745565.6977937088,734624.4212957061,
	723885.6439556896,713345.3320397717,702999.533936753,692844.3784930253,682876.0733811735,
	673090.9035014426,663485.2294152151,654055.4858105612,644798.1799981243,635709.8904376604,
	626787.2652941728,618027.021022952,609425.9409833859,600980.8740802044,592688.733432551,
	584546.4950694116,576551.1966514481,568699.9362184855,560989.8709621408,553418.2160230173,
	545982.2433122911,538679.2803566286,531506.7091665842,524461.9651274915,517542.5359127571,
	510745.9604187769,504069.82772155333,497511.77605376934,491069.491802822,484740.70852868084,
	478523.206001541,472414.8092588217,466413.38768093515,460516.85408579936,454723.1638413074,
	449030.3139957678,443436.3424256734,437939.3270006435,432537.3847651717,427228.67113663163,
	422011.3791195887,416883.73853571416,411844.0152693165,406890.51052796387,402021.56011792953,
	397235.5337343249,392530.8342653959,387905.89711085096,383359.1895139994,378889.20990718354,
	374494.4872705322,370173.5805035886,365925.07780959556,361747.59609225445,357639.7803646253,
	353600.30316993623,349627.8640142019,345721.1888102224,341879.0293328336,338100.1626852985,
	334383.39077633194,330727.53980790696,327131.45977334236,323594.02396559954,320114.12849560584,
	316690.69182030845,313322.6542804246,310008.97764747834,306748.64468020434,303540.6586898703,
	300384.0431145725,297277.841102153,294221.1151016801,291212.94646329334,288252.4350462102,
	285338.69883477484,282470.87356240605,279648.1123432109,276869.58531122917,274134.4792670522,
	271441.9973317115,268791.3586077116,266181.79784705804,263612.5651260984,261082.92552709905,
	258592.15882641872,256139.55918906655,253724.4348696879,251346.10791961307,249003.91390009457,
	246697.20160142012,244425.33276789958,242187.68182855786,239983.63563338225,237812.59319515544,
	235673.96543656662,233567.17494265607,231491.65571841615,229446.85295143013,227432.22277948484,
	225447.23206304113,223491.35816249266,221564.08872001726,219664.9214460818,217793.36391036678,
	215948.93333709863,214131.15640470444,212339.56904959612,210573.7162741919,208833.15195887315,
	207117.43867797015,205426.1475195803,203758.85790920228,202115.15743709737,200494.6416892541,
	198896.91408197972,197321.58569992118,195768.2751375623,194236.60834402364,192726.21847118053,
	191236.74572498532,189767.8372199067,188319.14683650652,186890.33508197256,185481.06895363715,
	184091.02180540466,182719.8732169494,181367.30886577934,180033.020401902,178716.70532525916,
	177418.06686566467,176136.81386536884,174872.66066406306,173625.3269863402,172394.53783156362,
	171180.0233660422,169981.5188175165,168798.7643718792,167631.5050720811,166479.49071920992,
	165342.4757756324,164220.2192702063,163112.48470554058,162019.03996715538,160939.6572346422,
	159874.11289464842,158822.18745576066,157783.66546515925,156758.335427042,155745.989722816,
	154746.4245329151,153759.43976035222,152784.83895583166,151822.42924447035,150872.0212540877,
	149933.42904497046,149006.47004117907,148090.9649632659,147186.73776242707,146293.61555606002,
	145411.42856466357,144540.01005009015,143679.19625507825,142828.82634409278,141988.74234537894,
	141158.7890942586,140338.81417762255,139528.66787957377,138728.2031282428,137937.2754436883,
	137155.74288692357,136383.4660099871,135620.3078070892,134866.1336667515,134120.811324979,
	133384.21081939962,132656.20444435484,131936.66670694968,131225.47428400407,130522.50597991362,
	129827.64268538458,129140.76733702888,128461.76487780805,127790.52221828575,127126.92819869913,
	126470.87355181914,125822.25086656612,125180.95455240134,124546.88080443435,123919.9275692717,
	123299.9945115599,122686.98298122402,122080.79598138193,121481.33813691743,120888.51566370457,
	120302.23633846302,119722.40946923255,119148.9458664538,118581.75781464709,118020.75904465585,
	117465.86470648162,116916.99134265284,116374.05686215033,115836.9805148547,115305.68286652821,
	114780.08577428675,114260.11236258913,113745.6869996972,113236.73527462661,112733.18397455606,
	112234.96106269331,111741.99565659362,111254.21800690997,110771.55947657456,110293.95252040059,
	109821.33066508344,109353.62848962056,108890.781606107,108432.72664092394,107979.40121630649,
	107530.74393226768,107086.69434889256,106647.19296897981,106212.18122103481,105781.60144259187,
	105355.39686386865,104933.5115917512,104515.89059408788,104102.4796842969,103693.22550627451,
	103288.07551960487,102886.97798505309,102489.88195035487,102096.73723627043,101707.49442291976,
	101322.10483638833,100940.52053558092,100562.69429934579,100188.57961384222,99818.13066015112,
	99451.3023021352,99088.05007452071,98728.33017122529,98372.09943389524,98019.31534067621,
	97669.93599519726,97323.9201157564,96981.2270247315,96641.8166381803,96305.64945564063,
	95972.68655013388,95642.88955835054,95316.22067102721,94992.64262350171,94672.1186864587,
	94354.61265682954,94040.08884889231,93728.51208551506,93419.84768957822,93114.06147555613,
	92811.11974125235,92510.98925969412,92213.63727117881,91919.03147547043,91627.1400241348,
	91337.93151302524,91051.37497490959,90767.4398722225,90486.09608996767,90207.31392874019,
	89931.0640978843,89657.3177087738,89386.04626821885,89117.22167199425,88850.81619848358,
	88586.80250244656,88325.15360889056,88065.84290706797,87808.84414456712,87554.13142152644,
	87301.67918494457,87051.46222309585,86803.45566004851,86557.63495028215,86313.97587340216,
	86072.45452894787,85833.0473313003,85595.73100467288,85360.4825782013,85127.27938111415,
	84896.09903799702,84666.91946413409,84439.7188609394,84214.47571146546,83991.16877599561,
	83769.77708771218,83550.27994844013,83332.65692447171,83116.88784246104,82902.95278539178,
	82690.8320886148,82480.50633596134,82271.95635591804,82065.16321787385,81860.10822842851,
	81656.77292777208,81455.13908612145,81255.18870022334,81056.90398991699,80860.2673947576,
	80665.26157069564,80471.8693868192,80280.07392214975,80089.85846249209,79901.20649734163,
	79714.1017168459,79528.528008815,79344.4694557861,79161.91033213977,78980.83510126163,
	78801.22841275988,78623.07509972254,78446.36017602865,78271.0688337008,78097.18644030578,
	77924.69853639987,77753.59083301504,77583.8492091929,77415.45970955439,77248.40854191748,
	77082.68207495075,76918.26683587012,76755.14950817215,76593.31692940778,76432.7560889932,
	76273.45412605873,76115.39832733307,75958.57612506332,75802.97509497392,75648.58295425463,
	75495.38755958705,75343.37690520339,75192.53912097713,75042.86247054848,74894.33534947986,
	74746.94628344371,74600.6839264416,74455.53705904997,74311.4945867041,74168.54553800466,
	74026.67906305332,73885.88443181926,73746.15103253843,73607.46837012915,73469.8260646457,
	73333.21384975468,73197.62157123788,73063.03918552164,72929.45675823528,72796.86446278889,
	72665.25257898425,72534.61149164484,72404.93168927307,72276.20376273443,72148.41840396117,
	72021.56640468467,71895.63865518979,71770.62614309316,71646.51995214525,71523.31126105886,
	71400.99134235666,71279.55156124465,71158.98337451158,71039.2783294445,70920.42806277721,
	70802.42429965505,70685.2588526266,70568.92362065881,70453.41058817417,70338.71182411407,
	70224.81948102677,70111.72579417528,69999.4230806778,69887.90373866673,69777.16024647308,
	69667.18516184184,69557.97112117098,69449.51083877536,69341.79710618041,69234.82279144276,
	69128.5808385004,69023.06426655139,68918.26616946238,68814.17971520996,68710.79814535141,
	68608.11477452908,68506.12299000936,68404.81625125709,68304.18808954235,68204.23210758794,
	68104.94197925515,68006.31144926634,67908.33433297304,67811.00451616233,67714.31595491037,
	67618.26267547981,67522.83877426556,67428.03841778904,67333.85584274365,67240.285356092,
	67147.32133521716,67054.95822813176,66963.1905537435,66872.01290217953,66781.41993517548,
	66691.40638652691,66601.9670626018,66513.09684292876,66424.79068084511,66337.043604222,
	66249.85071625731,66163.20719634462,66077.10830101462,65991.5493649534,65906.52580209837,
	65822.03310680612,65738.0668551063,65654.62270602293,65571.69640298303,65489.28377529027,
	65407.380739685075,65325.98330196967,65245.08755870892,65164.68969899641,65084.78600629064,
	65005.37286030698,64926.44673896833,64848.00422040812,64770.041985015356,64692.556817519384,
	64615.54560910215,64539.00535953338,64462.93317931583,64387.32629183034,64312.18203547059,
	64237.49786575254,64163.271357386875,64089.50020630038,64016.18223158521,63943.31537737194,
	63870.89771459157,63798.927442627006,63727.40289082031,63656.3225198238,63585.684922777305,
	63515.48882628249,63445.73309116058,63376.41671297535,63307.53882228852,63239.09868464145,
	63171.09570023302,63103.52940328167,63036.39946104467,62969.70567248331,62903.44796655742,
	62837.62640013002,62772.24115547294,62707.29253736049,62642.78096974226,62578.70699198652,
	62515.0712546946,62451.874515078445,62389.11763190625,62326.80156001865,62264.92734442802,
	62203.49611399825,62142.50907473688,62081.967502698266,62021.872736534286,61962.226169696005,
	61903.029242339195,61844.283432934775,61785.99024963486,61728.15122142331,61670.767889084374,
	61613.84179603203,61557.37447904093,61501.367458916015,61445.822231149825,61390.740256605255,
	61336.12295227474,61281.97168215368,61228.28774827114,61175.07238193103,61122.32673518889,
	61070.05187261916,61018.24876340455,60966.91827378199,60916.06115988104,60865.67806099078,
	60815.769493271335,60766.33584394376,60717.377365980734,60668.89417330465,60620.88623652646,
	60573.35337921464,60526.29527471584,60479.71144353325,60433.60125124579,60387.96390698525,
	60342.79846245131,60298.10381146433,60253.878690029574,60210.121676920455,60166.8311947389,
	60124.00551145049,60081.64274236412,60039.74085253505,59998.29765957119,59957.31083680369,
	59916.77791681193,59876.69629525669,59837.06323501487,59797.8758705635,59759.13121260339,
	59720.826152885194,59682.95746921031,59645.521830585385,59608.51580249289,59571.93585226209,
	59535.77835451211,59500.03959664319,59464.7157843485,59429.8030471335,59395.29744382486,
	59361.19496803124,59327.491553563916,59294.18307978281,59261.265376860945,59228.73423095433,
	59196.58538925827,59164.81456495196,59133.4174420068,59102.389679865664,59071.726917970314,
	59041.424780146335,59011.47887883022,58981.88481913513,58952.638202764225,58923.73463174847,
	58895.16971203,58866.93905687705,58839.03829013362,58811.46304930558,58784.208988481914,
	58757.27178110275,58730.647122564675,58704.330732667746,58678.318357919154,58652.60577367766,
	58627.18878616762,58602.06323433657,58577.22499159546,58552.66996740601,58528.39410875743,
	58504.39340151169,58480.66387163795,58457.201586322895,58434.00265498539,58411.063230171065,
	58388.3795083702,58365.94773071471,58343.76418360476,58321.82519924262,58300.12715608111,
	58278.66647920308,58257.4396406216,58236.44315951034,58215.67360238122,58195.127583180874,
	58174.801763348216,58154.692851806794,58134.797604902305,58115.112826322584,58095.635366928815,
	58076.36212458274,58057.29004391367,58038.416116059525,58019.73737838353,58001.25091413651,
	57982.9538521161,57964.84336628796,57946.91667538375,57929.17104248668,57911.60377459224,
	57894.21222213759,57876.99377855103,57859.94587974429,57843.06600363071,57826.35166960758,
	57809.80043803204,57793.40990970227,57777.17772533786,57761.10156499792,57745.179147575865,
	57729.40823023233,57713.78660784787,57698.31211247253,57682.98261276769,57667.79601345318,
	57652.75025475248,57637.843311839504,57623.07319428961,57608.43794552121,57593.93564226187,
	57579.564393992005,57565.32234241535,57551.207660915534,57537.218554023624,57523.35325690418,
	57509.61003480987,57495.98718258549,57482.48302414466,57469.09591196879,57455.82422660529,
	57442.66637617178,57429.62079587748,57416.68594752471,57403.86031905268,57391.14242405838,
	57378.530801332105,57366.0240144113,57353.62065112594,57341.31932316032,57329.11866561361,
	57317.01733657496,57305.01401670519,57293.107408814714,57281.296237458766,57269.57924854389,
	57257.95520892051,57246.42290600938,57234.98114740598,57223.628760520514,57212.36459220172,
	57201.18750837548,57190.096393695814,57179.09015119242,57168.1677019298,57157.327984669915,
	57146.569955544655,57135.89258773477,57125.294871146514,57114.77581210032,57104.33443303633,
	57093.969772194774,57083.680883341614,57073.466835475476,57063.32671252551,57053.25961310266,
	57043.2646502103,57033.340950973965,57023.48765639741,57013.70392108535,57003.98891300555,
	56994.341813237304,56984.76181572716,56975.24812705981,56965.79996621058,56956.41656433859,
	56947.09716454125,56937.84102165106,56928.647402014816,56919.515583280634,56910.44485419667,
	56901.43451441445,56892.483874260244,56883.59225458434,56874.758986549685,56865.983411432,
	56857.264880462935,56848.6027546229,56839.99640449748,56831.44521008093,56822.9485606086,
	56814.505854407646,56806.11649871784,56797.77990953474,56789.49551147267,56781.26273758347,
	56773.08102923252,56764.949835927146,56756.86861520022,56748.83683244854,56740.85396079523,
	56732.919480964905,56725.03288115877,56717.19365689897,56709.40131090992,56701.65535300339,
	56693.9552999501,56686.30067536109,56678.691009556685,56671.125839476656,56663.604708543266,
	56656.1271665649,56648.69276961187,56641.30107992728,56633.95166581234,56626.644101524915,
	56619.37796718225,56612.152848652564,56604.96833746717,56597.82403073,56590.71953100922,
	56583.654446257955,56576.62838972039,56569.64097984615,56562.69184019906,56555.780599382204,
	56548.90689093605,56542.07035328784,56535.27062963793,56528.50736790712,56521.780220645815,
	56515.08884495752,56508.43290244373,56501.812059105454,56495.225985290286,56488.674355613475,
	56482.15684889515,56475.67314808826,56469.22294021695,56462.80591630349,56456.42177131746,
	56450.07020410659,56443.75091733344,56437.46361740607,56431.208014454125,56424.98382221957,
	56418.79075805003,56412.628542808015,56406.496900827835,56400.395559869525,56394.324251048325,
	56388.282708799175,56382.270670821876,56376.287878022624,56370.33407447298,56364.40900735723,
	56358.51242693441,56352.64408648093,56346.803742241704,56340.9911534016,56335.20608202647,
	56329.44829303071,56323.717554122275,56318.01363577281,56312.336311159765,56306.685356164955,
	56301.06054927561,56295.46167159561,56289.888506791554,56284.340841042576,56278.81846301875,
	56273.32116383191,56267.84873702591,56262.40097850756,56256.977686527374,56251.578661659216,
	56246.2037067393,56240.8526268584,56235.52522930816,56230.22132357569,56224.94072129279,
	56219.68323619743,56214.44868413346,56209.23688299445,56204.047652702255,56198.88081519295,
	56193.73619436177,56188.613616054055,56183.51290804272,56178.43389998337,56173.376423397465,
	56168.34031164373,56163.32539990682,56158.33152516101,56153.358526125194,56148.40624328206,
	56143.47451882069,56138.56319662229,56133.67212224525,56128.8011428944,56123.95010739005,
	56119.11886617313,56114.30727125369,56109.515176207955,56104.74243615511,56099.98890772467,
	56095.254449060114,56090.538919765706,56085.84218092197,56081.164095039334,56076.50452606115,
	56071.86333932237,56067.24040154699,56062.635580827875,56058.04874659829,56053.479769634505,
	56048.928522021706,56044.39487713476,56039.87870964251,56035.37989545978,56030.89831177461,
	56026.43383698453,56021.98635070796,56017.55573376567,56013.141868170664,56008.74463708696,
	56004.36392485286,55999.99961694415,55995.651599955534,55991.31976160065,55987.00399068294,
	55982.70417710042,55978.420211815515,55974.15198685906,55969.899395296015,55965.662331221094,
	55961.440689758616,55957.23436703651,55953.04326017598,55948.86726727739,55944.70628741237,
	55940.560220619016,55936.42896786989,55932.312431076854,55928.210513081496,55924.12311763784,
	55920.05014939461,55915.99151390217,55911.94711757275,55907.91686770811,55903.90067246977,
	55899.898440849836,55895.91008269922,55891.93550868988,55887.97463031381,55884.027359870306,
	55880.09361047109,55876.173296006375,55872.266331153034,55868.372631358645,55864.49211284053,
	55860.62469256885,55856.77028825882,55852.92881835644,55849.10020205468,55845.28435925558,
	55841.48121056504,55837.69067732014,55833.91268152546,55830.14714589204,55826.39399381164,
	55822.65314934051,55818.92453720264,55815.20808279033,55811.503712125144,55807.81135190081,
	55804.13092941968,55800.46237263592,55796.80561010676,55793.16057101811,55789.52718515537,
	55785.90538291801,55782.295095290225,55778.696253846065,55775.10879073559,55771.532638705205,
	55767.96773105181,55764.41400164028,55760.871384895996,55757.33981579188,55753.8192298519,
	55750.30956312709,55746.81075221587,55743.32273423164,55739.84544683473,55736.378828166,
	55732.92281689727,55729.477352220805,55726.04237378955,55722.61782178661,55719.20363687284,
	55715.799760193746,55712.406133368815,55709.022698506385,55705.64939816666,55702.286175386114,
	55698.932973659,55695.58973693155,55692.256409600355,55688.93293651791,55685.61926295649,
	55682.315334642415,55679.02109773267,55675.736498806094,55672.46148486599,55669.19600333438,
	55665.94000204323,55662.69342925206,55659.456233610086,55656.22836416202,55653.00977038541,
	55649.800402098634,55646.60020956001,55643.40914339043,55640.22715458995,55637.05419455571,
	55633.890215029714,55630.73516815537,55627.589006419905,55624.45168269418,55621.32315019566,
	55618.20336250405,55615.09227354124,55611.98983760502,55608.89600929579,55605.8107436049,
	55602.73399583286,55599.665721621575,55596.60587695235,55593.55441812784,55590.51130177952,
	55587.47648487163,55584.44992465996,55581.431578771284,55578.4214050879,55575.41936184379,
	55572.42540754373,55569.4395010373,55566.46160145215,55563.49166822165,55560.52966107523,
	55557.575540033155,55554.6292654094,55551.69079780968,55548.76009812053,55545.83712750772,
	55542.92184742563,55540.014219606914,55537.11420604175,55534.22176901178,55531.33687106727,
	55528.45947501316,55525.58954392526,55522.72704115241,55519.87193028972,55517.02417518821,
	55514.18373997591,55511.35058899619,55508.52468687672,55505.70599849402,55502.89448893943,
	55500.090123574395,55497.29286799906,55494.50268804442,55491.71954977907,55488.94341952458,
	55486.17426381381,55483.41204941372,55480.65674332574,55477.90831278723,55475.1667252441,
	55472.431948377925,55469.70395006954,55466.98269845553,55464.26816185395,55461.56030881699,
	55458.859108089484,55456.164528673515,55453.47653973006,55450.795110646344,55448.12021102318,
	55445.451810659535,55442.78987955375,55440.13438790556,55437.48530611863,55434.84260478663,
	55432.206254706936,55429.57622685841,55426.95249242123,55424.335022755346,55421.723789436386,
	55419.11876419167,55416.51991895746,55413.92722584026,55411.34065715421,55408.760185354346,
	55406.185783104025,55403.61742323556,55401.05507875871,55398.498722858385,55395.94832888843,
	55393.403870389826,55390.8653210418,55388.332654731115,55385.80584548672,55383.28486751162,
	55380.76969517052,55378.26030299341,55375.75666567234,55373.25875806815,55370.76655518449,
	55368.28003220325,55365.79916443895,55363.32392738058,55360.854296654135,55358.390248068754,
	55355.931757560546,55353.478801214806,55351.031355276464,55348.589396136515,55346.15290032186,
	55343.721844534295,55341.296205577964,55338.875960439764,55336.46108621576,55334.051560169726,
	55331.64735969673,55329.24846231582,55326.854845714086,55324.466487639394,55322.083366156825,
	55319.70545923537,55317.33274509958,55314.965202115985,55312.602808743744,55310.24554358591,
	55307.89338538153,55305.54631297641,55303.20430537011,55300.86734166852,55298.53540112274,
	55296.2084630808,55293.886507036535,55291.56951259265,55289.25745947954,55286.95032754703,
	55284.64809677315,55282.350747236305,55280.058259139405,55277.770612886554,55275.48778869224,
	55273.209767324,55270.9365293898,55268.66805564442,55266.40432700723,55264.14532446934,
	55261.89102914798,55259.641422266875,55257.396485155325,55255.15619926227,55252.92054613049,
	55250.68950741228,55248.46306487142,55246.241200379554,55244.02389590442,55241.81113351235,
	55239.60289538599,55237.399163786904,55235.19992111828,55233.005149848505,55230.814832558775,
	55228.62895191563,55226.447490699524,55224.27043179325,55222.09775815942,55219.92945284973,
	55217.76549904365,55215.60587998629,55213.45057902722,55211.299579616294,55209.15286527947,
	55207.01041964882,55204.87222643914,55202.73826944688,55200.60853259073,55198.48299984158,
	55196.361655299675,55194.24448308977,55192.13146747993,55190.02259282101,55187.91784352126,
	55185.81720408392,55183.72065911552,55181.62819328339,55179.53979135988,55177.455438179655,
	55175.375118669144,55173.29881783677,55171.226520782184,55169.1582126639,55167.09387873461,
	55165.033504335515,55162.97707485317,55160.924575782454,55158.87599269504,55156.83131123122,
	55154.79051711247,55152.75359611746,55150.72053414733,55148.691317118464,55146.665931063086,
	55144.64436207128,55142.626596326954,55140.612620056796,55138.602419577226,55136.595981270206,
	55134.593291609235,55132.594337111135,55130.59910438496,55128.60758007143,55126.61975095232,
	55124.63560379603,55122.65512551176,55120.67830303174,55118.70512337403,55116.735573612415,
	55114.769640895975,55112.80731243593,55110.84857552601,55108.89341748339,55106.94182576202,
	55104.99378779688,55103.04929115165,55101.10832341438,55099.17087225595,55097.23692540398,
	55095.30647066361,55093.37949588216,55091.45598896019,55089.535937896384,55087.61933071454,
	55085.70615551987,55083.79640047601,55081.89005379329,55079.987103747306,55078.08753867029,
	55076.191346974025,55074.29851710536,55072.40903755341,55070.52289691556,55068.64008380964,
	55066.76058690281,55064.88439495188,55063.01149673703,55061.14188111438,55059.27553698091,
	55057.412453314384,55055.55261910258,55053.69602343232,55051.84265542163,55049.99250424394,
	55048.14555912483,55046.3018093411,55044.4612442322,55042.62385318924,55040.78962564819,
	55038.95855108277,55037.13061904567,55035.30581911429,55033.484140955574,55031.66557422077,
	55029.850108679995,55028.037734123856,55026.22844037891,55024.422217333806,55022.61905492673,
	55020.818943152655,55019.02187202178,55017.22783163122,55015.43681211279,55013.648803621,
	55011.86379640368,55010.0817807045,55008.30274685286,55006.52668520016,55004.75358615277,
	55002.98344016304,55001.21623772856,54999.4519693838,54997.69062573045,54995.93219738325,
	54994.17667500932,54992.424049340894,54990.67431112389,54988.92745116878,54987.18346032861,
	54985.44232948767,54983.70404956469,54981.96861154237,54980.236006449864,54978.50622531762,
	54976.77925926173,54975.05509941268,54973.33373695179,54971.61516310183,54969.89936912446,
	54968.18634632024,54966.47608603154,54964.76857962486,54963.063818535724,54961.36179422193,
	54959.662498174745,54957.96592192147,54956.27205706576,54954.580895199375,54952.89242797313,
	54951.206647087354,54949.523544250835,54947.8431112427,54946.16533986342,54944.49022194677,
	54942.817749358095,54941.14791401023,54939.48070787713,54937.816122906916,54936.15415113673,
	54934.49478462112,54932.838015447705,54931.18383573048,54929.53223764622,54927.88321337193,
	54926.23675514485,54924.59285524014,54922.9515059454,54921.31269959841,54919.676428553736,
	54918.04268521616,54916.411462022465,54914.78275143882,54913.15654595287,54911.53283809849,
	54909.91162047234,54908.29288561655,54906.67662619221,54905.062834868,54903.45150432038,
	54901.84262728306,54900.23619649022,54898.63220476513,54897.030644889564,54895.43150974169,
	54893.83479219904,54892.24048517254,54890.64858157795,54889.05907441963,54887.47195667347,
	54885.887221393845,54884.30486163152,54882.72487047781,54881.1472410618,54879.57196652466,
	54877.99904004657,54876.42845484297,54874.86020413844,54873.29428121992,54871.730679353794,
	54870.169391886586,54868.61041215436,54867.05373354146,54865.49934945897,54863.947253330785,
	54862.39743862736,54860.84989883316,54859.304627475765,54857.761618081946,54856.22086422893,
	54854.68235951859,54853.14609758398,54851.61207205063,54850.080276610934,54848.55070496114,
	54847.02335083961,54845.49820800657,54843.97527022928,54842.45453131536,54840.93598510634,
	54839.41962545028,54837.90544623814,54836.39344136533,54834.8836047871,54833.37593043097,
	54831.870412313314,54830.36704442586,54828.86582078795,54827.36673546154,54825.86978255162,
	54824.374956120686,54822.8822503407,54821.391659325076,54819.90317726205,54818.41679836839,
	54816.93251684457,54815.450326953294,54813.97022294609,54812.492199124565,54811.016249796536,
	54809.542369312774,54808.07055202831,54806.600792323836,54805.13308458698,54803.667423297324,
	54802.203802848635,54800.74221774833,54799.28266247411,54797.82513155418,54796.369619509795,
	54794.91612091199,54793.46463033083,54792.01514238665,54790.56765168238,54789.12215289457,
	54787.678640646096,54786.23710966064,54784.79755463057,54783.35997027604,54781.92435136653,
	54780.49069264633,54779.05898892992,54777.62923502837,54776.20142573397,54774.7755559467,
	54773.351620539215,54771.92961434366,54770.50953231449,54769.09136937304,54767.67512049425,
	54766.26078060733,54764.84834471909,54763.43780783586,54762.029164988155,54760.622411229924,
	54759.21754161218,54757.81455121768,54756.41343517146,54755.0141885855,54753.6168065905,
	54752.2212843448,54750.82761706049,54749.43579986808,54748.045828045324,54746.65769680319,
	54745.27140139401,54743.886937068666,54742.50429914764,54741.12348291712,54739.74448369567,
	54738.36729680926,54736.99191766108,54735.618341574685,54734.24656397905,54732.87658026827,
	54731.50838587987,54730.141976250845,54728.777346834024,54727.414493120436,54726.05341060764,
	54724.69409479729,54723.33654122415,54721.98074540641,54720.62670295276,54719.27440942236,
	54717.923860396695,54716.57505150166,54715.227978358234,54713.882636615286,54712.53902191555,
	54711.197129969616,54709.85695642296,54708.51849701085,54707.18174745945,54705.846703476,
	54704.5133608897,54703.18171538036,54701.85176277562,54700.523498883085,54699.196919498725,
	54697.8720204506,54696.548797622185,54695.22724684053,54693.90736400139,54692.58914497426,
	54691.272585675295,54689.95768204913,54688.64443001393,54687.33282551022,54686.02286451622,
	54684.714542995716,54683.407856965205,54682.10280241749,54680.79937538347,54679.49757189324,
	54678.19738800178,54676.89881977961,54675.60186332067,54674.30651467135,54673.0127699928,
	54671.72062536518,54670.430076948236,54669.141120889515,54667.853753320815,54666.56797047417,
	54665.28376849762,54664.001143601854,54662.72009200473,54661.44060995063,54660.16269366462,
	54658.88633941147,54657.61154345444,54656.33830209834,54655.06661161318,54653.796468306165,
	54652.52786851274,54651.260808577696,54649.99528482715,54648.73129363199,54647.46883135626,
	54646.20789441812,54644.948479165956,54643.690582029085,54642.43419944832,54641.17932786012,
	54639.92596368397,54638.674103400095,54637.42374347683,54636.174880407416,54634.92751066587,
	54633.68163078702,54632.437237264756,54631.19432666519,54629.95289550261,54628.712940356294,
	54627.47445778625,54626.23744436606,54625.00189669298,54623.76781136704,54622.535185014334,
	54621.30401423751,54620.074295704384,54618.846026046325,54617.61920192882,54616.3938200144,
	54615.16987702441,54613.94736959995,54612.7262944844,54611.506648389186,54610.288428019914,
	54609.07163015673,54607.85625150609,54606.642288835144,54605.42973895687,54604.21859861508,
	54603.00886460231,54601.8005337653,54600.59360287417,54599.38806875682,54598.183928263476,
	54596.98117826926,54595.77981557385,54594.57983708054,54593.38123966621,54592.184020210734,
	54590.98817561371,54589.79370279706,54588.60059865977,54587.408860150266,54586.218484194076,
	54585.029467759174,54583.841807774785,54582.65550124566,54581.470545116994,54580.28693640312,
	54579.10467212421,54577.923749241636,54576.74416480091,54575.56591582484,54574.38899937438,
	54573.213412452176,54572.039152161335,54570.866215529786,54569.694599686176,54568.52430167732,
	54567.355318605674,54566.187647592065,54565.02128573446,54563.85623015638,54562.69247799705,
	54561.53002641986,54560.368872551946,54559.20901354958,54558.05044660515,54556.89316890219,
	54555.73717759201,54554.58246991378,54553.42904305308,54552.276894257004,54551.12602068114,
	54549.9764196177,54548.82808830125,54547.68102397909,54546.535223880295,54545.39068531993,
	54544.24740556372,54543.10538186907,54541.96461156478,54540.82509195718,54539.68682032426,
	54538.54979399488,54537.414010322456,54536.279466632965,54535.14616026544,54534.01408858583,
	54532.88324893862,54531.7536387085,54530.62525525784,54529.49809601157,54528.37215832846,
	54527.24743961931,54526.12393731034,54525.00164879164,54523.880571538,54522.7607029515,
	54521.64204047957,54520.524581595666,54519.40832370929,54518.293264346954,54517.17940095192,
	54516.066731008345,54514.955252029315,54513.844961497874,54512.7358569122,54511.6279358086,
	54510.52119567646,54509.415634079174,54508.311248552665,54507.20803664249,54506.10599585334,
	54505.00512379965,54503.905418036484,54502.80687614087,54501.709495680785,54500.61327425749,
	54499.518209465095,54498.424298921826,54497.33154019587,54496.23993097251,54495.14946882349,
	54494.06015139874,54492.971976361994,54491.88494133803,54490.799043989835,54489.714281963505,
	54488.63065294872,54487.54815462491,54486.46678466329,54485.386540747284,54484.30742060082,
	54483.22942191595,54482.15254238825,54481.07677975457,54480.00213173229,54478.928596053905,
	54477.8561704705,54476.784852711,54475.71464053911,54474.64553171177,54473.57752399048,
	54472.51061515249,54471.44480297438,54470.380085241784,54469.316459738715,54468.25392428553,
	54467.19247668387,54466.13211470722,54465.0728362337,54464.01463903588,54462.95752097619,
	54461.90147988611,54460.84651361735,54459.79262000036,54458.739796919974,54457.68804220238,
	54456.6373537521
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	1943633466.7628152,1903700931.4244537,1864590824.445094,1826286148.2834516,1788770356.660751,
	1752027143.6745534,1716040522.3751423,1680794928.6430192,1646275115.0810032,1612466014.517785,
	1579353024.3433752,1546921774.5448568,1515158194.501256,1484048512.7498417,1453579255.626634,
	1423737188.3811047,1394509387.8477745,1365883200.0130503,1337846197.8517725,1310386225.1696613,
	1283491393.7318938,1257150039.7085874,1231350773.1533785,1206082390.2276046,1181333956.6392252,
	1157094755.754485,1133354268.8051782,1110102230.260395,1087328566.974705,1065023415.9313543,
	1043177119.138261,1021780214.1705561,1000823444.9882218,980297732.5696739,960194195.2783997,
	940504130.2746443,921219014.1717453,902330499.9998887,883830419.443701,865710769.504202,
	847963699.5622561,830581541.2417336,813556770.8202497,796882029.3858575,780550099.5221535,
	764553919.8849436,748886577.2329158,733541289.1592741,718511427.0732137,703790493.3259847,
	689372119.7575327,675250075.0523883,661418259.2077757,647870690.7933639,634601518.8139557,
	621605005.6233301,608875537.9527549,596407617.9704448,584195856.0019629,572234980.6009016,
	560519823.5631659,549045325.3363754,537806532.6233771,526798591.11807805,516016748.96830165,
	505456350.7012039,495112838.193635,484981746.0234157,475058702.19917226,465339423.91016483,
	455819717.4406849,446495474.5673216,437362673.2056481,428417373.5175464,419655715.36314446,
	411073921.36234564,402668289.0653117,394435194.3588221,386371086.1818495,378472488.83095235,
	370735996.4006995,363158272.9404347,355736053.65210056,348466138.54724663,341345394.6878303,
	334370754.1563439,327539210.8359296,320847822.43224055,314293705.49836147,307874037.1000798,
	301586052.243747,295427042.79498345,289394356.65702784,283485396.0731699,277697617.18721646,
	272028528.13062423,266475688.35571727,261036708.47001114,255709247.02623907,250491011.92428133,
	245379757.52777764,240373284.76965487,235469440.07153723,230666113.9579313,225961240.22841668,
	221352795.58507818,216838798.223492,212417307.36081415,208086422.00200543,203844280.16355205,
	199689058.5334906,195618971.08124945,191632268.6968102,187727238.3080879,183902201.9646987,
	180155516.28993472,176485571.90058032,172890792.47070467,169369634.01749593,165920584.44209802,
	162542162.75710633,159232918.44940093,155991430.86277995,152816308.62851334,149706188.93054852,
	146659737.0269439,143675645.7022305,140752634.54435146,137889449.60530654,135084862.63295224,
	132337670.70997886,129646695.64219816,127010783.50896546,124428804.05857967,121899650.39788537,
	119422238.31209302,116995505.94511078,114618413.27372758,112289941.62514666,110009093.35005641,
	107774891.24776217,105586378.27455777,103442617.02041247,101342689.40685154,99285696.18526572,
	97270756.64102156,95297008.12046315,93363605.75746468,91469722.02039929,89614546.40465537,
	87797285.08478224,86017160.52531439,84273411.21188,82565291.22752543,80892070.06163251,
	79253032.15344988,77647476.6882475,76074717.24762464,74534081.50248079,73024910.97061887,
	71546560.68250114,70098398.9154144,68679806.94910285,67290178.77033357,65928920.80398105,
	64595451.680650145,63289201.97644054,62009613.96167325,60756141.36601003,59528249.140532464,
	58325413.22711995,57147120.328575715,55992867.700953715,54862162.908772476,53754523.64603356,
	52669477.5021384,51606561.768461116,50565323.24475169,49545318.03202647,48546111.342948236,
	47567277.32122951,46608398.853767216,45669067.385991916,44748882.758264154,43847453.01774732,
	42964394.26516778,42099330.47240186,41251893.33629168,40421722.108019896,39608463.447495185,
	38811771.2619755,38031306.561968595,37266737.31464249,36517738.29966464,35783990.96985829,
	35065183.31365009,34361009.722382896,33671170.85429493,32995373.509433113,32333330.504042756,
	31684760.542239945,31049388.100510556,30426943.3051694,29817161.817063082,29219784.718757138,
	28634558.403074108,28061234.461676165,27499569.58134585,26949325.437755726,26410268.591321632,
	25882170.390634857,25364806.87053501,24857958.6573445,24361410.874530934,23874953.049786877,
	23398379.024881683,22931486.867042065,22474078.782439187,22025961.029786326,21586943.83876902,
	21156841.32728963,20735471.422527228,20322655.78177887,19918219.716559187,19521992.116831355,
	19133805.378140263,18753495.32960258,18380901.162773747,18015865.363303855,17658233.642513685,
	17307854.872366667,16964581.019023076,16628267.080651818,16298771.024331272,15975953.725396981,
	15659678.907918679,15349813.08587424,15046225.505965441,14748788.091592992,14457375.388017097,
	14171864.508351691,13892135.080820933,13618069.19740979,13349551.362983746,13086468.44598265,
	12828709.629867755,12576166.365578277,12328732.325016694,12086303.355513008,11848777.435118638,
	11616054.628997972,11388037.046460042,11164628.799222492,10945735.96013535,10731266.523013676,
	10521130.363379009,10315239.199660791,10113506.555462357,9915847.722662896,9722179.724904833,
	9532421.282340525,9346492.776713936,9164316.21724145,8985815.207334105,8810914.911885224,
	8639542.025282795,8471624.739961887,8307092.715809,8145877.050006227,7987910.2475875085,
	7833126.192577966,7681460.119752218,7532848.586944364,7387229.447898836,7244541.825758555,
	7104726.087016469,6967723.816095404,6833477.790290082,6701931.955463252,6573031.401960457,
	6446722.341285388,6322952.083080593,6201669.01260539,6082822.56876039,5966363.222462268,
	5852242.455550524,5740412.740025342,5630827.5178437065,5523441.18099385,5418209.052067191,
	5315087.365220841,5214033.247480412,5115004.700502204,5017960.582624386,4922860.591370437,
	4829665.246235227,4738335.871899551,4648834.581719688,4561124.261612019,4475168.554225937,
	4390931.843469097,4308379.239329687,4227476.563048493,4148190.3325314587,4070487.7481303588,
	3994336.678665109,3919705.6477600564,3846563.82044462,3774880.9900449747,3704627.565332279,
	3635774.557934253,3568293.570020953,3502156.782219129,3437336.9417940467,3373807.35106559,
	3311541.8560661376,3250514.835423444,3190701.1894802977,3132076.329636305,3074616.16790005,
	3018297.1066651638,2963096.0286922595,2908990.2872987734,2855957.696742648,2803976.5228142063,
	2753025.473615186,2703083.690521812,2654130.739346928,2606146.6016700394,2559111.66635135,
	2513006.7212191587,2467812.9449300417,2423511.898990664,2380085.5199475014,2337516.1117353714,
	2295786.338183441,2254879.215675016,2214778.1059550387,2175466.7090891856,2136929.056566628,
	2099149.5045414655,2062112.7272153879,2025803.7103536788,1990207.7449393184,1955310.420948108,
	1921097.6212621613,1887555.515699321,1854670.5551692012,1822429.4659494322,1790819.244077286,
	1759827.1498560985,1729440.7024761157,1699647.6747460782,1670436.0879276663,1641794.2066828115,
	1613710.53411892,1586173.8069392233,1559172.9906896295,1532697.2751054077,1506736.0695505405,
	1481278.9985536851,1456315.89743248,1431836.8080083667,1407831.9744098834,1384291.8389618674,
	1361207.0381568223,1338568.3987104977,1316366.9336982938,1294593.8387689046,1273240.4884372249,
	1252298.4324521448,1231759.3922378123,1211615.2574095037,1191858.0823591065,1172480.082910277,
	1153473.6330431,1134831.2616845337,1116545.649564498,1098609.6261363819,1081016.166560309,
	1063758.388747501,1046829.5504653421,1030223.0465012509,1013932.4058840962,997951.2891626327,
	982273.4857390566,966892.9112563696,951803.6050401138,936999.7275908071,922475.5581281066,
	908225.4921845328,894244.0392484737,880525.8204544121,867065.5663206602,853858.1145326511,
	840898.4077712778,828181.4915851103,815702.5123061354,803456.7150072592,791439.4415013518,
	779646.1283810659,768072.3050976467,756713.5920793682,745565.6988876002,734624.4224101013,
	723885.6450909984,713345.3331964137,702999.5351151285,692844.3796935694,682876.0746043634,
	673090.9047476334,663485.2306849312,654055.4871042145,644798.181316225,635709.8917806739,
	626787.266662555,618027.0224172868,609425.9424041174,600980.8755278802,592688.734907703,
	584546.4965725675,576551.1981831995,568699.937779422,560989.872552774,553418.2176440025,
	545982.2449641917,538679.2820401065,531506.7108822601,524461.9668759909,517542.5376947676,
	510745.9622349744,504069.8295726278,497511.77794041554,491069.493725781,484740.7104886862,
	478523.2079993595,472414.81129519857,466413.3897566911,460516.8562017168,454723.1659982305,
	449030.31619452994,443436.34466711595,437939.32928567886,432537.3870946957,427228.6735115618,
	422011.38154086337,416883.7410042967,411844.01778619207,406890.51309415133,402021.56273446226,
	397235.5364022488,392530.8369857843,387905.899884834,383359.1923426774,378889.21279171255,
	374494.49021210254,370173.5835034033,365925.08086889074,361747.5992123074,357639.7835467205,
	353600.3064153925,349627.8673243845,345721.19218650897,341879.03277664713,338100.16619807924,
	334383.39435957524,330727.54346313473,327131.46350210614,323594.0277694892,320114.1323762447,
	316690.69577938423,313322.6583196256,310008.981768565,306748.64888495184,303540.66298011993,
	300384.0474921851,297277.8455690482,294221.11965983023,291212.9511147085,288252.4397929472,
	285338.70367894106,282470.8785061541,279648.1173887616,276869.5904608414,274134.4845230418,
	271442.00269645243,268791.36408363347,266181.8034366452,263612.5708319047,261082.93135173537,
	258592.16477255113,256139.5652594433,253724.44106710784,251346.11424694007,249003.92036027412,
	246697.2081974789,244425.33950292188,242187.6887056973,239983.64265588566,237812.60036633877,
	235673.97275983304,233567.18242148732,231491.6633563845,229446.8607521939,227432.23074678378,
	225447.24020073083,223491.36647449786,221564.09721037114,219664.9301189143,217793.37276991218,
	215948.94238770127,214131.16565080438,212339.57849575594,210573.72592508205,208833.16181928266,
	207117.44875280163,205426.1578138629,203758.86842809475,202115.1681858803,200494.65267334762,
	198896.92530693376,197321.59717142922,195768.28686145542,194236.6203262831,192726.23071794494,
	191236.7582425346,189767.85001469636,188319.15991513908,186890.34845122177,185481.08262045434,
	184091.03577690758,182719.88750045086,181367.32346876417,180033.03533205413,178716.72059045054,
	177418.0824739771,176136.82982508384,174872.67698366998,173625.34367455656,172394.55489732162,
	171180.04081850112,169981.53666608036,168798.7826261813,167631.52374201702,166479.5098149169,
	165342.49530750737,164220.23924892474,163112.5051420441,162019.0608726726,160939.67862068632,
	159874.13477304156,158822.20983862053,157783.68836491936,156758.35885646142,155746.0136949793,
	154746.44906125165,153759.46485864057,152784.86463820425,151822.45552543292,150872.04814851767,
	149933.4565681415,149006.498208756,148090.99379132572,147186.76726746646,146293.6457550076,
	145411.4594748917,144540.0416894231,143679.22864181528,142828.85949700698,141988.77628373736,
	141158.8238378348,140338.84974670978,139528.70429500617,138728.24041139384,137937.31361650166,
	137155.78197191755,136383.50603027703,135620.34878640034,134866.17562943624,134120.8542960368,
	133384.25482448668,132656.24950981073,131936.71285981027,131225.521552025,130522.5543915857,
	129827.69226995663,129140.81812452592,128461.81689905263,127790.5755049235,127126.98278321694,
	126470.92946756967,125822.30814779195,125181.01323425527,124546.9409230125,123919.9891616315,
	123300.05761575056,122687.04763631137,122080.86222747355,121481.40601520007,120888.58521646532,
	120302.30760912104,119722.48250237212,119149.02070785721,118581.83451131958,118020.83764487052,
	117465.94525980442,116917.07389998263,116374.14147575368,115837.06723840558,115305.77175514396,
	114780.17688456776,114260.20575265889,113745.78272924756,113236.83340495675,112733.28456861782,
	112235.06418513643,111742.10137381202,111254.32638709016,110771.6705897444,110294.0664384749,
	109821.44746192486,109353.74824108608,108890.9043901015,108432.85253746255,107979.53030756784,
	107530.87630265154,107086.83008508277,106647.33216000898,106212.32395834457,105781.74782009849,
	105355.5469780338,104933.66554165025,104516.0484814805,104102.641613698,103693.3915850344,
	103288.24585798339,102887.15269629871,102490.06115078845,102096.92104536554,101707.68296339377,
	101322.29823428286,100940.7189203617,100562.8978039895,100188.78837493142,99818.34481797685,
	99451.52200079379,99088.27546202233,98728.56139959302,98372.33665927983,98019.5587234669,
	97670.18570013375,97324.17631205192,96981.48988618981,96642.08634332375,96305.92618783374,
	95972.97049771884,95643.18091478177,95316.51963500388,94992.94939911757,94672.43348334148,
	94354.93569029703,94040.42034009918,93728.85226161632,93420.19678388909,93114.41972771747,
	92811.48739740082,92511.36657264014,92214.02450058631,91919.42888803812,91627.54789378952,
	91338.35012111561,91051.80461040369,90767.88083191686,90486.54867869505,90207.77845958677,
	89931.5408924119,89657.80709724774,89386.54858984165,89117.73727514457,88851.34544096723,
	88587.34575174382,88325.71124242264,88066.41531245815,87809.43171991777,87554.7345757024,
	87302.29833785856,87052.09780600794,86804.10811587119,86558.30473389033,86314.66345195877,
	86073.16038223344,85833.77195205122,85596.47489893119,85361.24626567344,85128.0633955393,
	84896.90392752434,84667.74579171224,84440.56720471778,84215.34666520418,83992.06294948807,
	83770.69510721976,83551.22245713882,83333.6245829138,83117.88132904608,82903.97279685314,
	82691.87934052244,82481.58156323667,82273.0603133637,82066.29668071981,81861.27199289891,
	81657.96781166179,81456.36592939516,81256.44836563035,81058.19736362867,80861.59538702057,
	80666.62511651023,80473.26944663575,80281.51148258787,80091.33453708579,79902.72212730855,
	79715.65797187912,79530.12598790582,79346.11028807264,79163.59517778411,78982.56515236327,
	78803.00489429309,78624.8992705143,78448.23332976893,78272.99229999198,78099.16158575266,
	77926.72676573556,77755.67359027774,77585.98797894196,77417.65601813949,77250.66395879754,
	77084.99821406454,76920.64535706723,76757.59211870043,76595.82538546652,76435.33219735362,
	76276.09974575309,76118.11537142088,75961.36656247744,75805.84095244789,75651.52631834209,
	75498.41057877502,75346.48179212381,75195.72815472998,75046.1379991304,74897.69979233858,
	74750.4021341559,74604.23375552728,74459.18351693223,74315.24040681621,74172.39354006149,
	74030.63215649498,73889.94561943877,73750.32341429821,73611.7551471888,73474.23054360601,
	73337.73944713439,73202.27181819863,73067.8177328556,72934.36738162852,72801.91106838522,
	72670.43920926332,72539.94233163144,72410.41107310078,72281.83618058928,72154.20850942079,
	72027.51902248249,71901.75878942687,71776.91898592573,71652.99089297916,71529.96589627114,
	71407.8354855858,71286.59125427889,71166.22489880268,71046.72821829768,70928.09311423503,
	70810.31159013326,70693.37575132596,70577.27780480818,70462.01005913984,70347.56492442642,
	70233.9349123594,70121.11263634547,70009.09081169662,69897.86225589845,69787.41988896098,
	69677.7567338416,69568.86591695396,69460.74066875162,69353.37432439865,69246.76032452173,
	69140.89221604366,69035.76365310277,68931.36839805426,68827.70032255563,68724.75340873326,
	68622.52175043154,68520.99955454054,68420.18114240111,68320.0609512816,68220.63353593429,
	68121.89357020555,68023.8358487229,67926.45528862577,67829.7469313575,67733.70594449367,
	67638.3276236081,67543.60739416759,67449.54081344156,67356.12357241673,67263.3514977078,
	67171.22055344807,67079.72684315055,66988.86661151679,66898.63624618779,66809.03227941152,
	66720.05138961475,66631.69040286004,66543.9462941623,66456.81618865613,66370.29736258391,
	66284.38724408709,66199.08341377716,66114.38360506913,66030.28570425036,65946.78775026479,
	65863.88793419368,65781.58459840671,65699.87623536943,65618.76148608213,65538.23913813445,
	65458.30812336133,65378.967515079195,65300.21652489658,65222.05449908072,65144.48091447821,
	65067.495373977,64991.09760151392,64915.287436617116,64840.06482849682,64765.42982968387,
	64691.382589223394,64617.923345444935,64545.05241831546,64472.77020139898,64401.07715344902,
	64329.97378965274,64259.460672564186,64189.53840275331,64120.207609208934,64051.46893953725,
	63983.32304998645,63915.7705953544,63848.81221881284,63782.448541698286,63716.68015331481,
	63651.507600803765,63586.93137911886,63522.9519211566,63459.56958809667,63396.78465999055,
	63334.597326645286,63273.007678846654,63212.01569996652,63151.621257982304,63091.82409795405,
	63032.62383499142,62974.019947728346,62916.01177234936,62858.59849717111,62801.7791578142,
	62745.55263296154,62689.91764073066,62634.87273565335,62580.41630627514,62526.54657336504,
	62473.26158872947,62420.55923463659,62368.43722381614,62316.89310003737,62265.92423924265,
	62215.527851204955,62165.70098170754,62116.44051519623,62067.74317789641,62019.605541353776,
	61972.02402637763,61924.99490734493,61878.514316845314,61832.578250628125,61787.182572819496,
	61742.3230213776,61697.995213760536,61654.194652759135,61610.916732487494,61568.15674447817,
	61525.909883870045,61484.17125565514,61442.93588095285,61402.19870329792,61361.95459490788,
	61322.19836291636,61282.92475554834,61244.128468211245,61205.80414950056,61167.94640708973,
	61130.54981349901,61093.60891171762,61057.11822069533,61021.07224065397,60985.46545824963,
	60950.29235154996,60915.547394837224,60881.22506322607,60847.3198370881,60813.82620629622,
	60780.738674261396,60748.05176179619,60715.76001076829,60683.85798756871,60652.340286399616,
	60621.20153235252,60590.43638432841,60560.03953775406,60530.00572713424,60500.329728425306,
	60471.00636123812,60442.03049088537,60413.397030258864,60385.10094156021,60357.1372378812,
	60329.500984637874,60302.1873008725,60275.19136042274,60248.50839295441,60222.13368489317,
	60196.06258021766,60170.29048116482,60144.81284880245,60119.625203541334,60094.72312552016,
	60070.10225491731,60045.75829216767,60021.68699811906,59997.88419409033,59974.34576187788,
	59951.0676436938,59928.04584203051,59905.276419479465,59882.755498502396,59860.479261126995,
	59838.443948633474,59816.64586116299,59795.0813573097,59773.74685367016,59752.63882435366,
	59731.7538004761,59711.08836960087,59690.63917520801,59670.40291605345,59650.37634559593,
	59630.556271350826,59610.939554255085,59591.52310800339,59572.303898371894,59553.27894254922,
	59534.44530843284,59515.80011393593,59497.34052628025,59479.06376128666,59460.9670826632,
	59443.04780129011,59425.303274500155,59407.73090535837,59390.32814195372,59373.092476672886,
	59356.02144549509,59339.11262727851,59322.36364305093,59305.77215531013,59289.33586732602,
	59273.052522443504,59256.9199034024,59240.935831650466,59225.09816667084,59209.40480531928,
	59193.85368115567,59178.44276379953,59163.170058282645,59148.033604405326,59133.0314761265,
	59118.16178091946,59103.42265917793,59088.812283605825,59074.32885862312,59059.97061978569,
	59045.735833200124,59031.62279496364,59017.62983059639,59003.7552945066,58989.997569432824,
	58976.355065922224,58962.82622180276,58949.40950167506,58936.10339640089,58922.9064226071,
	58909.817122203654,58896.83406190069,58883.955832733016,58871.181049610444,58858.508350851145,
	58845.936397747704,58833.46387411841,58821.08948589149,58808.81196067754,58796.63004735098,
	58784.54251566443,58772.54815582529,58760.645778125894,58748.83421255963,58737.11230843653,
	58725.47893402297,58713.932976184704,58702.473340022305,58691.09894854378,58679.80874230252,
	58668.60167908579,58657.47673357377,58646.43289703097,58635.46917698747,58624.58459692953,
	58613.778196007195,58603.04902873411,58592.39616470088,58581.81868828802,58571.315698401166,
	58560.886308177876,58550.52964474672,58540.24484894563,58530.031075087085,58519.88749068297,
	58509.81327621888,58499.80762491225,58489.86974246981,58479.998846851624,58470.19416806856,
	58460.45494793675,58450.78043987364,58441.16990868116,58431.62263033482,58422.137891798375,
	58412.714990794564,58403.353235629555,58394.051944998144,58384.81044779464,58375.62808292795,
	58366.50419913892,58357.43815482658,58348.42931788165,58339.47706550083,58330.58078403797,
	58321.73986882907,58312.95372403936,58304.22176250138,58295.54340556987,58286.918082958975,
	58278.34523260327,58269.824300533786,58261.35474068872,58252.936014811145,58244.56759230887,
	58236.24895011029,58227.97957255007,58219.75895121512,58211.58658485205,58203.461979219195,
	58195.3846469774,58187.35410756835,58179.36988709884,58171.4315182326,58163.538540071575,
	58155.690498048716,58147.88694382407,58140.12743517744,58132.411535910025,58124.73881573496,
	58117.108850185345,58109.521220513525,58101.97551359971,58094.471321854464,58087.00824313185,
	58079.58588063671,58072.20384283406,58064.86174336454,58057.559200973956,58050.29583939872,
	58043.071287310995,58035.885178236924,58028.73715045702,58021.626846966596,58014.55391535009,
	58007.51800775182,58000.51878078568,57993.55589545395,57986.62901709939,57979.737815310495,
	57972.881963885055,57966.061140730424,57959.27502782282,57952.523311134595,57945.80568057624,
	57939.12182992087,57932.471456771316,57925.854262462315,57919.269952040115,57912.7182341869,
	57906.198821157996,57899.71142874964,57893.25577621465,57886.83158624807,57880.43858488685,
	57874.07650150308,57867.74506872872,57861.444022415715,57855.173101578184,57848.93204836088,
	57842.72060797363,57836.53852866,57830.385561639625,57824.261461083464,57818.165984044106,
	57812.09889043755,57806.0599429807,57800.048907157034,57794.065551201136,57788.10964600622,
	57782.180965132626,57776.2792847442,57770.40438358603,57764.556042921235,57758.734046535195,
	57752.93818065818,57747.16823395803,57741.42399748379,57735.7052646663,57730.011831230164,
	57724.343495220906,57718.700056925176,57713.0813188627,57707.48708575925,57701.91716448504,
	57696.37136406701,57690.849495628805,57685.351372368954,57679.876809530295,57674.42562438705,
	57668.997636190026,57663.59266616508,57658.21053746726,57652.851075161874,57647.51410620386,
	57642.1994594,57636.90696539635,57631.636456643864,57626.38776737196,57621.160733582794,
	57615.95519300645,57610.77098507975,57605.60795093451,57600.465933383704,57595.34477686252,
	57590.244327441724,57585.1644327918,57580.10494215981,57575.06570636412,57570.04657774842,
	57565.047410179795,57560.06805902841,57555.1083811486,57550.168234840574,57545.24747986073,
	57540.34597737752,57535.46358996958,57530.60018159197,57525.75561759478,57520.92976464211,
	57516.122490767855,57511.33366529611,57506.56315886344,57501.81084338899,57497.07659206255,
	57492.360279312896,57487.66178081685,57482.98097346972,57478.31773537236,57473.67194580871,
	57469.04348523976,57464.43223529465,57459.83807874033,57455.260899487,57450.700582545585,
	57446.15701404433,57441.63008120224,57437.11967231175,57432.625676726864,57428.14798486009,
	57423.68648816314,57419.24107910402,57414.81165117284,57410.39809886359,57406.00031765274,
	57401.61820398462,57397.25165530618,57392.90056997138,57388.56484731899,57384.244387586834,
	57379.93909195442,57375.64886250187,57371.37360221077,57367.11321496188,57362.86760549131,
	57358.63667942106,57354.42034323119,57350.21850423633,57346.031070606994,57341.8579513258,
	57337.69905620208,57333.55429586234,57329.423581711315,57325.30682596688,57321.20394161418,
	57317.11484241883,57313.03944291075,57308.97765837491,57304.929404827424,57300.89459905787,
	57296.87315855507,57292.8650015369,57288.87004694756,57284.88821441444,57280.919424286476,
	57276.96359758248,57273.02065602467,57269.090521992155,57265.17311853466,57261.26836937889,
	57257.37619888012,57253.4965320449,57249.629294543294,57245.77441264026,57241.931813257186,
	57238.101423898974,57234.28317272246,57230.476988457514,57226.68280044295,57222.90053860614,
	57219.130133476625,57215.371516132065,57211.62461824673,57207.889372057216,57204.16571035681,
	57200.45356648942,57196.75287435826,57193.06356840254,57189.385583608375,57185.71885547056,
	57182.06332002065,57178.41891383817,57174.785573970934,57171.16323801538,57167.551844047055,
	57163.951330653246,57160.36163690794,57156.78270237883,57153.214467127174,57149.656871662446,
	57146.10985699663,57142.5733646098,57139.04733641906,57135.53171482792,57132.02644269807,
	57128.53146331268,57125.04672042154,57121.57215821325,57118.10772131196,57114.65335477343,
	57111.20900407658,57107.77461512234,57104.35013424792,57100.935508193164,57097.53068409847,
	57094.135609538964,57090.75023245785,57087.37450123388,57084.00836460547,57080.65177172612,
	57077.304672134305,57073.967015734015,57070.63875282879,57067.31983409644,57064.01021056723,
	57060.70983366623,57057.41865516451,57054.13662720557,57050.863702279385,57047.59983324432,
	57044.344973302555,57041.09907600199,57037.86209524423,57034.63398525024,57031.41470060528,
	57028.20419621705,57025.0024273248,57021.80934949082,57018.62491861466,57015.44909091085,
	57012.281822911325,57009.12307146244,57005.97279373905,57002.83094720957,56999.69748964839,
	56996.57237914244,56993.45557408178,56990.34703315715,56987.24671533975,56984.15457990485,
	56981.07058642503,56977.99469474752,56974.92686500796,56971.86705763651,56968.815233325455,
	56965.77135305206,56962.735378070705,56959.70726990896,56956.68699035797,56953.674501479996,
	56950.669765606726,56947.67274533007,56944.68340348961,56941.70170320364,56938.72760783076,
	56935.76108098635,56932.80208654336,56929.850588613976,56926.90655157398,56923.96994000939,
	56921.040718788056,56918.11885299703,56915.20430795057,56912.29704922913,56909.39704262581,
	56906.50425416162,56903.61865011238,56900.740196945895,56897.86886138377,56895.004610363365,
	56892.14741103693,56889.29723078729,56886.454037202544,56883.61779809501,56880.78848150066,
	56877.966055642915,56875.150488982545,56872.34175017345,56869.53980807727,56866.74463176045,
	56863.95619049663,56861.17445376592,56858.39939124019,56855.63097278087,56852.86916846775,
	56850.11394855307,56847.365283517356,56844.62314398407,56841.88750081003,56839.15832500143,
	56836.43558778522,56833.71926056608,56831.009314911535,56828.30572260316,56825.60845556735,
	56822.91748593544,56820.232786022054,56817.55432828584,56814.882085397316,56812.216030175616,
	56809.55613561612,56806.90237489168,56804.25472133464,56801.61314846218,56798.977629936126,
	56796.34813959193,56793.72465144207,56791.10713964102,56788.49557850801,56785.889942530506,
	56783.29020635524,56780.696344780525,56778.108332750344,56775.526145394135,56772.94975795451,
	56770.379145849976,56767.814284653774,56765.25515007755,56762.701717992895,56760.153964400386,
	56757.611865455685,56755.07539748189,56752.5445368963,56750.01926030469,56747.499544444625,
	56744.98536617041,56742.476702500986,56739.9735305895,56737.47582772143,56734.98357130395,
	56732.496738908456,56730.01530822625,56727.53925708149,56725.06856342369,56722.60320535416,
	56720.14316107231,56717.68840893109,56715.23892741227,56712.79469511149,56710.35569075248,
	56707.92189318588,56705.493281393865,56703.06983447945,56700.65153166464,56698.238352273234,
	56695.830275784836,56693.427281785065,56691.02934996153,56688.636460139016,56686.248592252996,
	56683.86572634864,56681.48784261279,56679.11492130668,56676.746942825695,56674.38388767674,
	56672.02573647115,56669.672469965626,56667.32406894819,56664.98051442335,56662.6417874098,
	56660.307869075135,56657.97874070038,56655.654383648536,56653.33477941579,56651.01990956483,
	56648.70975580368,56646.40429992489,56644.10352380607,56641.80740945145,56639.51593896109,
	56637.22909451972,56634.946858439034,56632.669213095505,56630.39614098269,56628.12762469164,
	56625.86364691211,56623.60419042111,56621.34923808807,56619.098772887126,56616.85277786617,
	56614.6112362052,56612.374131132914,56610.14144600019,56607.913164220605,56605.68926934096,
	56603.46974494607,56601.254574758495,56599.04374253589,56596.837232176775,56594.63502763242,
	56592.43711297005,56590.24347229841,56588.05408985159,56585.86894993236,56583.68803692601,
	56581.51133532229,56579.338829645116,56577.17050456113,56575.00634478105,56572.846335100556,
	56570.69046039986,56568.53870563993,56566.39105586786,56564.247496201424,56562.1080118518,
	56559.9725880784,56557.84121023224,56555.71386376131,56553.59053415628,56551.4712070182,
	56549.35586797234,56547.244502794296,56545.13709726156,56543.03363725797,56540.9341087496,
	56538.838497756995,56536.74679037824,56534.65897278333,56532.575031228975,56530.49495200078,
	56528.41872149799,56526.34632618706,56524.277752570226,56522.21298725451,56520.15201687877,
	56518.09482819822,56516.04140798729,56513.99174311319,56511.9458205209,56509.90362718766,
	56507.86515018773,56505.83037663561,56503.79929372446,56501.77188873033,56499.748148948696,
	56497.728061787835,56495.71161467045,56493.69879512009,56491.68959072377,56489.68398909084,
	56487.6819779248,56485.6835449896,56483.68867810362,56481.697365124666,56479.70959403272,
	56477.72535279562,56475.7446294766,56473.76741220495,56471.793689121405,56469.8234485007,
	56467.85667862027,56465.8933678149,56463.93350450759,56461.977077139185,56460.02407425399,
	56458.07448440749,56456.12829624154,56454.18549842559,56452.24607971088,56450.310028894026,
	56448.3773348293,56446.44798639038,56444.52197256031,56442.59928233865,56440.679904789125,
	56438.76382902763,56436.85104421948,56434.94153957393,56433.035304373356,56431.132327944644,
	56429.232599638584,56427.33610888396,56425.442845178164,56423.552798002,56421.66595695565,
	56419.78231165985,56417.901851786315,56416.024567032175,56414.15044719005,56412.27948206288,
	56410.41166152512,56408.54697547878,56406.68541387153,56404.826966727764,56402.971624099424,
	56401.119376081595,56399.270212802265,56397.424124463956,56395.58110131464,56393.74113362496,
	56391.90421169983,56390.0703259537,56388.23946675244,56386.411624607295,56384.58678997165,
	56382.76495341346,56380.9461055459,56379.13023696042,56377.31733837169,56375.50740047244,
	56373.700414017774,56371.896369839,56370.0952587643,56368.29707167238,56366.501799511316,
	56364.709433229626,56362.919963846216,56361.13338242421,56359.34968004135,56357.56884781654,
	56355.79087694299,56354.01575862665,56352.2434841073,56350.47404467459,56348.70743166826,
	56346.94363643883,56345.1826504072,56343.42446501501,56341.6690717372,56339.91646209693,
	56338.166627646344,56336.41955998289,56334.67525073604,56332.93369158136,56331.1948742268,
	56329.458790406235,56327.725431897175,56325.99479051195,56324.26685810876,56322.54162657837,
	56320.81908783506,56319.09923383454,56317.38205655784,56315.66754806108,56313.95570037011,
	56312.246505614305,56310.539955910375,56308.8360434214,56307.134760340596,56305.43609891256,
	56303.740051393426,56302.04661008458,56300.35576732671,56298.66751546544,56296.98184692358,
	56295.29875412876,56293.61822951073,56291.9402655922,56290.26485491902,56288.59199000287,
	56286.92166347384,56285.25386794034,56283.588596061534,56281.92584050337,56280.26559402012,
	56278.607849315464,56276.952599194265,56275.29983644253,56273.64955393166,56272.00174449738,
	56270.3564010652,56268.7135165397,56267.07308389113,56265.435096109104,56263.79954621962,
	56262.16642722538,56260.535732243254,56258.90745436551,56257.281586731246,56255.65812247605,
	56254.037054825654,56252.41837697445,56250.802082172544,56249.18816367974,56247.57661483065,
	56245.96742893338,56244.36059934422,56242.75611944645,56241.15398265016,56239.55418240151,
	56237.95671216981,56236.36156544135,56234.76873571238,56233.178216558896,56231.59000153112,
	56230.00408424082,56228.420458310335,56226.83911737677,56225.26005512067,56223.68326525166,
	56222.1087414851,56220.53647757282,56218.966467291844,56217.39870445124,56215.83318287599,
	56214.26989639648,56212.70883892672,56211.15000432748,56209.593386559594,56208.038979545796,
	56206.48677729016,56204.936773749534,56203.388962978584,56201.8433389941,56200.29989588754,
	56198.758627764866,56197.21952870698,56195.6825928621,56194.14781441718,56192.6151875264,
	56191.08470640109,56189.556365314675,56188.03015848066,56186.50608016845,56184.98412469487,
	56183.464286408576,56181.94655960066,56180.43093865766,56178.91741798735,56177.405991987864,
	56175.89665505814,56174.38940171191,56172.88422636392,56171.38112356141,56169.880087787256,
	56168.381113591546,56166.884195540435,56165.38932820116,56163.896506187106,56162.405724115015,
	56160.91697664304,56159.43025841635,56157.94556412707,56156.462888470756,56154.982226176915,
	56153.50357201041,56152.02692071897,56150.55226710108,56149.079605928004,56147.608932063864,
	56146.14024033166,56144.67352561971,56143.20878277164,56141.74600672969,56140.285192397925,
	56138.82633472074,56137.3694286525,56135.91446919233,56134.46145133026,56133.01037007134,
	56131.56122047558,56130.113997563625,56128.66869644963,56127.225312203045,56125.783839928896,
	56124.344274773786,56122.90661186626,56121.470846388635,56120.036973516166,56118.604988448256,
	56117.17488641833,56115.746662636084,56114.32031236984,56112.89583089397,56111.47321348159,
	56110.052455480974,56108.63355216756,56107.21649892071,56105.80129106307,56104.38792399752,
	56102.976393135046,56101.5666938199,56100.158821530575,56098.75277169983,56097.34853977544,
	56095.94612125481,56094.545511620134,56093.14670634855,56091.74970102156,56090.35449115169,
	56088.961072300364,56087.56944003246,56086.17958996187,56084.791517669415,56083.405218795626,
	56082.02068895876,56080.637923839444,56079.25691908377,56077.877670389644,56076.50017344679,
	56075.12442397571,56073.75041771388,56072.378150395656,56071.00761779691,56069.638815678576,
	56068.27173983376,56066.90638609774,56065.54275025355,56064.180828170014,56062.82061566597,
	56061.46210862844,56060.1053029408,56058.75019449972,56057.39677920704,56056.04505297336,
	56054.69501178169,56053.34665152905,56051.99996822176,56050.65495782808,56049.31161634681,
	56047.96993979057,56046.62992417779,56045.291565544605,56043.95485994553,56042.61980345926,
	56041.28639213622,56039.954622088255,56038.624489417314,56037.295990263825,56035.96912072539,
	56034.64387698065,56033.3202551502,56031.998251439065,56030.67786204423,56029.359083137206,
	56028.04191094782,56026.72634170086,56025.41237162621,56024.099996993566,56022.78921404579,
	56021.4800190883,56020.17240837429,56018.86637824084,56017.56192500292,56016.25904496416,
	56014.9577344817,56013.65798989551,56012.35980760754,56011.063183958286,56009.76811535489,
	56008.47459818953,56007.18262890466,56005.892203900774,56004.6033196189,56003.3159725191,
	56002.030159079455,56000.74587575976,55999.46311903133,55998.18188542083,55996.90217141848,
	55995.62397357542,55994.34728839204,55993.072112433365,55991.798442264066,55990.52627444294,
	55989.25560554425,55987.98643216522,55986.71875092941,55985.45255840906,55984.18785128624,
	55982.92462614699,55981.66287966633,55980.40260849295,55979.143809303816,55977.88647878046,
	55976.6306136232,55975.37621050814,55974.123266185234,55972.87177735787,55971.62174077764,
	55970.37315316314,55969.12601132408,55967.880311972694,55966.63605191363,55965.39322793195,
	55964.151836840196,55962.91187542475,55961.673340531204,55960.436228978215,55959.200537612254,
	55957.966263267095,55956.733402846694,55955.501953177525,55954.27191116974,55953.043273708725,
	55951.81603770131,55950.59020005384,55949.36575768902,55948.14270752567,55946.92104654728,
	55945.70077166142,55944.481879861654,55943.264368122225,55942.04823338793,55940.83347269578,
	55939.62008300307,55938.40806137072,55937.197404770224,55935.9881102547,55934.78017486245,
	55933.57359568202,55932.36836969049,55931.16449400235,55929.961965693066,55928.76078184774,
	55927.56093955657,55926.362435921386,55925.16526807266,55923.96943311992,55922.77492818838,
	55921.5817504423,55920.38989701969,55919.19936506784,55918.01015178125,55916.82225431525,
	55915.63566986076,55914.450395618915,55913.26642879359,55912.08376659008,55910.90240622961,
	55909.72234495146,55908.54357998601,55907.36610859163,55906.18992800818,55905.01503549324,
	55903.841428348416,55902.669103843036,55901.49805926481,55900.32829190538,55899.15979907845,
	55897.99257811598,55896.826626293245,55895.661940999686,55894.49851953621,55893.33635927303,
	55892.17545754302,55891.01581172214,55889.85741918885,55888.70027732137,55887.54438350695,
	55886.38973513248,55885.23632962591,55884.0841643803,55882.93323680685,55881.7835443719,
	55880.6350844824,55879.48785458677,55878.34185213283,55877.19707459517,55876.0535194375,
	55874.91118411401,55873.77006612565,55872.63016296431,55871.491472115624,55870.353991101925,
	55869.21771742433,55868.082648620846,55866.948782196036,55865.8161156966,55864.68464664947,
	55863.554372640116,55862.42529119714,55861.29739989367,55860.17069630473,55859.045178014814,
	55857.920842590356,55856.797687651306,55855.675710773045,55854.55490958574,55853.435281731785,
	55852.31682475549,55851.19953633939,55850.08341412635,55848.96845573949,55847.8546588299,
	55846.742021068545,55845.63054010614,55844.520213646385,55843.411039319835,55842.303014842226,
	55841.196137907915,55840.09040619517,55838.98581744972,55837.88236933289,55836.780059585624,
	55835.678885961155,55834.578846154596,55833.47993791789,55832.38215899657,55831.28550715526,
	55830.189980136696,55829.0955757343,55828.00229166732,55826.91012578168,55825.81907582464,
	55824.72913957764,55823.64031483995,55822.552599453535,55821.465991214485,55820.38048791458,
	55819.296087403076,55818.2127875028,55817.130586042345,55816.04948087342,55814.969469849806,
	55813.89055079571,55812.81272162818,55811.73598017776,55810.66032431337,55809.58575193386,
	55808.512260918134
	}}
};
