//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/IntegrationRuntimes_GetStatus.json
func ExampleIntegrationRuntimeStatusClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationRuntimeStatusClient().Get(ctx, "exampleResourceGroup", "exampleWorkspace", "exampleIntegrationRuntime", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationRuntimeStatusResponse = armsynapse.IntegrationRuntimeStatusResponse{
	// 	Name: to.Ptr("exampleIntegrationRuntime"),
	// 	Properties: &armsynapse.SelfHostedIntegrationRuntimeStatus{
	// 		Type: to.Ptr(armsynapse.IntegrationRuntimeTypeSelfHosted),
	// 		State: to.Ptr(armsynapse.IntegrationRuntimeStateOnline),
	// 		TypeProperties: &armsynapse.SelfHostedIntegrationRuntimeStatusTypeProperties{
	// 			AutoUpdate: to.Ptr(armsynapse.IntegrationRuntimeAutoUpdateOff),
	// 			Capabilities: map[string]*string{
	// 				"connectedToResourceManager": to.Ptr("True"),
	// 				"credentialInSync": to.Ptr("True"),
	// 				"httpsPortEnabled": to.Ptr("True"),
	// 				"nodeEnabled": to.Ptr("True"),
	// 				"serviceBusConnected": to.Ptr("True"),
	// 			},
	// 			CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-06-14T09:17:45.183Z"); return t}()),
	// 			LatestVersion: to.Ptr("3.7.6711.1"),
	// 			LocalTimeZoneOffset: to.Ptr("PT8H"),
	// 			Nodes: []*armsynapse.SelfHostedIntegrationRuntimeNode{
	// 				{
	// 					Capabilities: map[string]*string{
	// 						"connectedToResourceManager": to.Ptr("True"),
	// 						"credentialInSync": to.Ptr("True"),
	// 						"httpsPortEnabled": to.Ptr("True"),
	// 						"nodeEnabled": to.Ptr("True"),
	// 						"serviceBusConnected": to.Ptr("True"),
	// 					},
	// 					HostServiceURI: to.Ptr("https://yanzhang-dt.fareast.corp.microsoft.com:8050/HostServiceRemote.svc/"),
	// 					IsActiveDispatcher: to.Ptr(true),
	// 					LastConnectTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-06-14T14:52:59.893Z"); return t}()),
	// 					LastStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-06-14T14:52:59.893Z"); return t}()),
	// 					LastUpdateResult: to.Ptr(armsynapse.IntegrationRuntimeUpdateResultNone),
	// 					MachineName: to.Ptr("YANZHANG-DT"),
	// 					MaxConcurrentJobs: to.Ptr[int32](56),
	// 					NodeName: to.Ptr("Node_1"),
	// 					RegisterTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-06-14T14:51:44.923Z"); return t}()),
	// 					Status: to.Ptr(armsynapse.SelfHostedIntegrationRuntimeNodeStatusOnline),
	// 					Version: to.Ptr("3.8.6730.2"),
	// 					VersionStatus: to.Ptr("UpToDate"),
	// 			}},
	// 			ServiceUrls: []*string{
	// 				to.Ptr("wu.frontend.int.clouddatahub-int.net"),
	// 				to.Ptr("*.servicebus.windows.net")},
	// 				TaskQueueID: to.Ptr("1a6296ab-423c-4346-9bcc-85a78c2c0582"),
	// 				UpdateDelayOffset: to.Ptr("PT3H"),
	// 				Version: to.Ptr("3.8.6730.2"),
	// 				VersionStatus: to.Ptr("UpToDate"),
	// 			},
	// 		},
	// 	}
}
