//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// VulnerabilityAssessmentScansServer is a fake server for instances of the armsql.VulnerabilityAssessmentScansClient type.
type VulnerabilityAssessmentScansServer struct {
	// Get is the fake for method VulnerabilityAssessmentScansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.VulnerabilityAssessmentScansClientGetOptions) (resp azfake.Responder[armsql.VulnerabilityAssessmentScansClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySQLVulnerabilityAssessmentsPager is the fake for method VulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySQLVulnerabilityAssessmentsPager func(resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsOptions) (resp azfake.PagerResponder[armsql.VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse])
}

// NewVulnerabilityAssessmentScansServerTransport creates a new instance of VulnerabilityAssessmentScansServerTransport with the provided implementation.
// The returned VulnerabilityAssessmentScansServerTransport instance is connected to an instance of armsql.VulnerabilityAssessmentScansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVulnerabilityAssessmentScansServerTransport(srv *VulnerabilityAssessmentScansServer) *VulnerabilityAssessmentScansServerTransport {
	return &VulnerabilityAssessmentScansServerTransport{
		srv: srv,
		newListBySQLVulnerabilityAssessmentsPager: newTracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse]](),
	}
}

// VulnerabilityAssessmentScansServerTransport connects instances of armsql.VulnerabilityAssessmentScansClient to instances of VulnerabilityAssessmentScansServer.
// Don't use this type directly, use NewVulnerabilityAssessmentScansServerTransport instead.
type VulnerabilityAssessmentScansServerTransport struct {
	srv                                       *VulnerabilityAssessmentScansServer
	newListBySQLVulnerabilityAssessmentsPager *tracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse]]
}

// Do implements the policy.Transporter interface for VulnerabilityAssessmentScansServerTransport.
func (v *VulnerabilityAssessmentScansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VulnerabilityAssessmentScansClient.Get":
		resp, err = v.dispatchGet(req)
	case "VulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager":
		resp, err = v.dispatchNewListBySQLVulnerabilityAssessmentsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VulnerabilityAssessmentScansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VulnerabilityAssessmentScanRecordForSQL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VulnerabilityAssessmentScansServerTransport) dispatchNewListBySQLVulnerabilityAssessmentsPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListBySQLVulnerabilityAssessmentsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySQLVulnerabilityAssessmentsPager not implemented")}
	}
	newListBySQLVulnerabilityAssessmentsPager := v.newListBySQLVulnerabilityAssessmentsPager.get(req)
	if newListBySQLVulnerabilityAssessmentsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListBySQLVulnerabilityAssessmentsPager(resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, nil)
		newListBySQLVulnerabilityAssessmentsPager = &resp
		v.newListBySQLVulnerabilityAssessmentsPager.add(req, newListBySQLVulnerabilityAssessmentsPager)
		server.PagerResponderInjectNextLinks(newListBySQLVulnerabilityAssessmentsPager, req, func(page *armsql.VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySQLVulnerabilityAssessmentsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListBySQLVulnerabilityAssessmentsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySQLVulnerabilityAssessmentsPager) {
		v.newListBySQLVulnerabilityAssessmentsPager.remove(req)
	}
	return resp, nil
}
