//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicefabric

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ApplicationDeltaHealthPolicy.
func (a ApplicationDeltaHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultServiceTypeDeltaHealthPolicy", a.DefaultServiceTypeDeltaHealthPolicy)
	populate(objectMap, "serviceTypeDeltaHealthPolicies", a.ServiceTypeDeltaHealthPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationDeltaHealthPolicy.
func (a *ApplicationDeltaHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultServiceTypeDeltaHealthPolicy":
			err = unpopulate(val, "DefaultServiceTypeDeltaHealthPolicy", &a.DefaultServiceTypeDeltaHealthPolicy)
			delete(rawMsg, key)
		case "serviceTypeDeltaHealthPolicies":
			err = unpopulate(val, "ServiceTypeDeltaHealthPolicies", &a.ServiceTypeDeltaHealthPolicies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationHealthPolicy.
func (a ApplicationHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultServiceTypeHealthPolicy", a.DefaultServiceTypeHealthPolicy)
	populate(objectMap, "serviceTypeHealthPolicies", a.ServiceTypeHealthPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationHealthPolicy.
func (a *ApplicationHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultServiceTypeHealthPolicy":
			err = unpopulate(val, "DefaultServiceTypeHealthPolicy", &a.DefaultServiceTypeHealthPolicy)
			delete(rawMsg, key)
		case "serviceTypeHealthPolicies":
			err = unpopulate(val, "ServiceTypeHealthPolicies", &a.ServiceTypeHealthPolicies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationMetricDescription.
func (a ApplicationMetricDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maximumCapacity", a.MaximumCapacity)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "reservationCapacity", a.ReservationCapacity)
	populate(objectMap, "totalApplicationCapacity", a.TotalApplicationCapacity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationMetricDescription.
func (a *ApplicationMetricDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maximumCapacity":
			err = unpopulate(val, "MaximumCapacity", &a.MaximumCapacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "reservationCapacity":
			err = unpopulate(val, "ReservationCapacity", &a.ReservationCapacity)
			delete(rawMsg, key)
		case "totalApplicationCapacity":
			err = unpopulate(val, "TotalApplicationCapacity", &a.TotalApplicationCapacity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResource.
func (a ApplicationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResource.
func (a *ApplicationResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceList.
func (a ApplicationResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResourceList.
func (a *ApplicationResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceProperties.
func (a ApplicationResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managedIdentities", a.ManagedIdentities)
	populate(objectMap, "maximumNodes", a.MaximumNodes)
	populate(objectMap, "metrics", a.Metrics)
	populate(objectMap, "minimumNodes", a.MinimumNodes)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "removeApplicationCapacity", a.RemoveApplicationCapacity)
	populate(objectMap, "typeName", a.TypeName)
	populate(objectMap, "typeVersion", a.TypeVersion)
	populate(objectMap, "upgradePolicy", a.UpgradePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResourceProperties.
func (a *ApplicationResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managedIdentities":
			err = unpopulate(val, "ManagedIdentities", &a.ManagedIdentities)
			delete(rawMsg, key)
		case "maximumNodes":
			err = unpopulate(val, "MaximumNodes", &a.MaximumNodes)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &a.Metrics)
			delete(rawMsg, key)
		case "minimumNodes":
			err = unpopulate(val, "MinimumNodes", &a.MinimumNodes)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "removeApplicationCapacity":
			err = unpopulate(val, "RemoveApplicationCapacity", &a.RemoveApplicationCapacity)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &a.TypeName)
			delete(rawMsg, key)
		case "typeVersion":
			err = unpopulate(val, "TypeVersion", &a.TypeVersion)
			delete(rawMsg, key)
		case "upgradePolicy":
			err = unpopulate(val, "UpgradePolicy", &a.UpgradePolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceUpdate.
func (a ApplicationResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResourceUpdate.
func (a *ApplicationResourceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceUpdateProperties.
func (a ApplicationResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managedIdentities", a.ManagedIdentities)
	populate(objectMap, "maximumNodes", a.MaximumNodes)
	populate(objectMap, "metrics", a.Metrics)
	populate(objectMap, "minimumNodes", a.MinimumNodes)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "removeApplicationCapacity", a.RemoveApplicationCapacity)
	populate(objectMap, "typeVersion", a.TypeVersion)
	populate(objectMap, "upgradePolicy", a.UpgradePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResourceUpdateProperties.
func (a *ApplicationResourceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managedIdentities":
			err = unpopulate(val, "ManagedIdentities", &a.ManagedIdentities)
			delete(rawMsg, key)
		case "maximumNodes":
			err = unpopulate(val, "MaximumNodes", &a.MaximumNodes)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &a.Metrics)
			delete(rawMsg, key)
		case "minimumNodes":
			err = unpopulate(val, "MinimumNodes", &a.MinimumNodes)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "removeApplicationCapacity":
			err = unpopulate(val, "RemoveApplicationCapacity", &a.RemoveApplicationCapacity)
			delete(rawMsg, key)
		case "typeVersion":
			err = unpopulate(val, "TypeVersion", &a.TypeVersion)
			delete(rawMsg, key)
		case "upgradePolicy":
			err = unpopulate(val, "UpgradePolicy", &a.UpgradePolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeResource.
func (a ApplicationTypeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationTypeResource.
func (a *ApplicationTypeResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeResourceList.
func (a ApplicationTypeResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationTypeResourceList.
func (a *ApplicationTypeResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeResourceProperties.
func (a ApplicationTypeResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationTypeResourceProperties.
func (a *ApplicationTypeResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeVersionResource.
func (a ApplicationTypeVersionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationTypeVersionResource.
func (a *ApplicationTypeVersionResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeVersionResourceList.
func (a ApplicationTypeVersionResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationTypeVersionResourceList.
func (a *ApplicationTypeVersionResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeVersionResourceProperties.
func (a ApplicationTypeVersionResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appPackageUrl", a.AppPackageURL)
	populate(objectMap, "defaultParameterList", a.DefaultParameterList)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationTypeVersionResourceProperties.
func (a *ApplicationTypeVersionResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appPackageUrl":
			err = unpopulate(val, "AppPackageURL", &a.AppPackageURL)
			delete(rawMsg, key)
		case "defaultParameterList":
			err = unpopulate(val, "DefaultParameterList", &a.DefaultParameterList)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeVersionsCleanupPolicy.
func (a ApplicationTypeVersionsCleanupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxUnusedVersionsToKeep", a.MaxUnusedVersionsToKeep)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationTypeVersionsCleanupPolicy.
func (a *ApplicationTypeVersionsCleanupPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxUnusedVersionsToKeep":
			err = unpopulate(val, "MaxUnusedVersionsToKeep", &a.MaxUnusedVersionsToKeep)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationUpgradePolicy.
func (a ApplicationUpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationHealthPolicy", a.ApplicationHealthPolicy)
	populate(objectMap, "forceRestart", a.ForceRestart)
	populate(objectMap, "recreateApplication", a.RecreateApplication)
	populate(objectMap, "rollingUpgradeMonitoringPolicy", a.RollingUpgradeMonitoringPolicy)
	populate(objectMap, "upgradeMode", a.UpgradeMode)
	populate(objectMap, "upgradeReplicaSetCheckTimeout", a.UpgradeReplicaSetCheckTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationUpgradePolicy.
func (a *ApplicationUpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationHealthPolicy":
			err = unpopulate(val, "ApplicationHealthPolicy", &a.ApplicationHealthPolicy)
			delete(rawMsg, key)
		case "forceRestart":
			err = unpopulate(val, "ForceRestart", &a.ForceRestart)
			delete(rawMsg, key)
		case "recreateApplication":
			err = unpopulate(val, "RecreateApplication", &a.RecreateApplication)
			delete(rawMsg, key)
		case "rollingUpgradeMonitoringPolicy":
			err = unpopulate(val, "RollingUpgradeMonitoringPolicy", &a.RollingUpgradeMonitoringPolicy)
			delete(rawMsg, key)
		case "upgradeMode":
			err = unpopulate(val, "UpgradeMode", &a.UpgradeMode)
			delete(rawMsg, key)
		case "upgradeReplicaSetCheckTimeout":
			err = unpopulate(val, "UpgradeReplicaSetCheckTimeout", &a.UpgradeReplicaSetCheckTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationUserAssignedIdentity.
func (a ApplicationUserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "principalId", a.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationUserAssignedIdentity.
func (a *ApplicationUserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmApplicationHealthPolicy.
func (a ArmApplicationHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "considerWarningAsError", a.ConsiderWarningAsError)
	populate(objectMap, "defaultServiceTypeHealthPolicy", a.DefaultServiceTypeHealthPolicy)
	populate(objectMap, "maxPercentUnhealthyDeployedApplications", a.MaxPercentUnhealthyDeployedApplications)
	populate(objectMap, "serviceTypeHealthPolicyMap", a.ServiceTypeHealthPolicyMap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmApplicationHealthPolicy.
func (a *ArmApplicationHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "considerWarningAsError":
			err = unpopulate(val, "ConsiderWarningAsError", &a.ConsiderWarningAsError)
			delete(rawMsg, key)
		case "defaultServiceTypeHealthPolicy":
			err = unpopulate(val, "DefaultServiceTypeHealthPolicy", &a.DefaultServiceTypeHealthPolicy)
			delete(rawMsg, key)
		case "maxPercentUnhealthyDeployedApplications":
			err = unpopulate(val, "MaxPercentUnhealthyDeployedApplications", &a.MaxPercentUnhealthyDeployedApplications)
			delete(rawMsg, key)
		case "serviceTypeHealthPolicyMap":
			err = unpopulate(val, "ServiceTypeHealthPolicyMap", &a.ServiceTypeHealthPolicyMap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmRollingUpgradeMonitoringPolicy.
func (a ArmRollingUpgradeMonitoringPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failureAction", a.FailureAction)
	populate(objectMap, "healthCheckRetryTimeout", a.HealthCheckRetryTimeout)
	populate(objectMap, "healthCheckStableDuration", a.HealthCheckStableDuration)
	populate(objectMap, "healthCheckWaitDuration", a.HealthCheckWaitDuration)
	populate(objectMap, "upgradeDomainTimeout", a.UpgradeDomainTimeout)
	populate(objectMap, "upgradeTimeout", a.UpgradeTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmRollingUpgradeMonitoringPolicy.
func (a *ArmRollingUpgradeMonitoringPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failureAction":
			err = unpopulate(val, "FailureAction", &a.FailureAction)
			delete(rawMsg, key)
		case "healthCheckRetryTimeout":
			err = unpopulate(val, "HealthCheckRetryTimeout", &a.HealthCheckRetryTimeout)
			delete(rawMsg, key)
		case "healthCheckStableDuration":
			err = unpopulate(val, "HealthCheckStableDuration", &a.HealthCheckStableDuration)
			delete(rawMsg, key)
		case "healthCheckWaitDuration":
			err = unpopulate(val, "HealthCheckWaitDuration", &a.HealthCheckWaitDuration)
			delete(rawMsg, key)
		case "upgradeDomainTimeout":
			err = unpopulate(val, "UpgradeDomainTimeout", &a.UpgradeDomainTimeout)
			delete(rawMsg, key)
		case "upgradeTimeout":
			err = unpopulate(val, "UpgradeTimeout", &a.UpgradeTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmServiceTypeHealthPolicy.
func (a ArmServiceTypeHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxPercentUnhealthyPartitionsPerService", a.MaxPercentUnhealthyPartitionsPerService)
	populate(objectMap, "maxPercentUnhealthyReplicasPerPartition", a.MaxPercentUnhealthyReplicasPerPartition)
	populate(objectMap, "maxPercentUnhealthyServices", a.MaxPercentUnhealthyServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmServiceTypeHealthPolicy.
func (a *ArmServiceTypeHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxPercentUnhealthyPartitionsPerService":
			err = unpopulate(val, "MaxPercentUnhealthyPartitionsPerService", &a.MaxPercentUnhealthyPartitionsPerService)
			delete(rawMsg, key)
		case "maxPercentUnhealthyReplicasPerPartition":
			err = unpopulate(val, "MaxPercentUnhealthyReplicasPerPartition", &a.MaxPercentUnhealthyReplicasPerPartition)
			delete(rawMsg, key)
		case "maxPercentUnhealthyServices":
			err = unpopulate(val, "MaxPercentUnhealthyServices", &a.MaxPercentUnhealthyServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableOperationDisplay.
func (a AvailableOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "provider", a.Provider)
	populate(objectMap, "resource", a.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableOperationDisplay.
func (a *AvailableOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &a.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &a.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureActiveDirectory.
func (a AzureActiveDirectory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientApplication", a.ClientApplication)
	populate(objectMap, "clusterApplication", a.ClusterApplication)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureActiveDirectory.
func (a *AzureActiveDirectory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientApplication":
			err = unpopulate(val, "ClientApplication", &a.ClientApplication)
			delete(rawMsg, key)
		case "clusterApplication":
			err = unpopulate(val, "ClusterApplication", &a.ClusterApplication)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateDescription.
func (c CertificateDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "thumbprint", c.Thumbprint)
	populate(objectMap, "thumbprintSecondary", c.ThumbprintSecondary)
	populate(objectMap, "x509StoreName", c.X509StoreName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateDescription.
func (c *CertificateDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		case "thumbprintSecondary":
			err = unpopulate(val, "ThumbprintSecondary", &c.ThumbprintSecondary)
			delete(rawMsg, key)
		case "x509StoreName":
			err = unpopulate(val, "X509StoreName", &c.X509StoreName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientCertificateCommonName.
func (c ClientCertificateCommonName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateCommonName", c.CertificateCommonName)
	populate(objectMap, "certificateIssuerThumbprint", c.CertificateIssuerThumbprint)
	populate(objectMap, "isAdmin", c.IsAdmin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientCertificateCommonName.
func (c *ClientCertificateCommonName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateCommonName":
			err = unpopulate(val, "CertificateCommonName", &c.CertificateCommonName)
			delete(rawMsg, key)
		case "certificateIssuerThumbprint":
			err = unpopulate(val, "CertificateIssuerThumbprint", &c.CertificateIssuerThumbprint)
			delete(rawMsg, key)
		case "isAdmin":
			err = unpopulate(val, "IsAdmin", &c.IsAdmin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientCertificateThumbprint.
func (c ClientCertificateThumbprint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateThumbprint", c.CertificateThumbprint)
	populate(objectMap, "isAdmin", c.IsAdmin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientCertificateThumbprint.
func (c *ClientCertificateThumbprint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateThumbprint":
			err = unpopulate(val, "CertificateThumbprint", &c.CertificateThumbprint)
			delete(rawMsg, key)
		case "isAdmin":
			err = unpopulate(val, "IsAdmin", &c.IsAdmin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cluster.
func (c *Cluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCodeVersionsListResult.
func (c ClusterCodeVersionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCodeVersionsListResult.
func (c *ClusterCodeVersionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCodeVersionsResult.
func (c ClusterCodeVersionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCodeVersionsResult.
func (c *ClusterCodeVersionsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterHealthPolicy.
func (c ClusterHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationHealthPolicies", c.ApplicationHealthPolicies)
	populate(objectMap, "maxPercentUnhealthyApplications", c.MaxPercentUnhealthyApplications)
	populate(objectMap, "maxPercentUnhealthyNodes", c.MaxPercentUnhealthyNodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterHealthPolicy.
func (c *ClusterHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationHealthPolicies":
			err = unpopulate(val, "ApplicationHealthPolicies", &c.ApplicationHealthPolicies)
			delete(rawMsg, key)
		case "maxPercentUnhealthyApplications":
			err = unpopulate(val, "MaxPercentUnhealthyApplications", &c.MaxPercentUnhealthyApplications)
			delete(rawMsg, key)
		case "maxPercentUnhealthyNodes":
			err = unpopulate(val, "MaxPercentUnhealthyNodes", &c.MaxPercentUnhealthyNodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterListResult.
func (c ClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterListResult.
func (c *ClusterListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterProperties.
func (c ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addOnFeatures", c.AddOnFeatures)
	populate(objectMap, "applicationTypeVersionsCleanupPolicy", c.ApplicationTypeVersionsCleanupPolicy)
	populate(objectMap, "availableClusterVersions", c.AvailableClusterVersions)
	populate(objectMap, "azureActiveDirectory", c.AzureActiveDirectory)
	populate(objectMap, "certificate", c.Certificate)
	populate(objectMap, "certificateCommonNames", c.CertificateCommonNames)
	populate(objectMap, "clientCertificateCommonNames", c.ClientCertificateCommonNames)
	populate(objectMap, "clientCertificateThumbprints", c.ClientCertificateThumbprints)
	populate(objectMap, "clusterCodeVersion", c.ClusterCodeVersion)
	populate(objectMap, "clusterEndpoint", c.ClusterEndpoint)
	populate(objectMap, "clusterId", c.ClusterID)
	populate(objectMap, "clusterState", c.ClusterState)
	populate(objectMap, "diagnosticsStorageAccountConfig", c.DiagnosticsStorageAccountConfig)
	populate(objectMap, "eventStoreServiceEnabled", c.EventStoreServiceEnabled)
	populate(objectMap, "fabricSettings", c.FabricSettings)
	populate(objectMap, "infrastructureServiceManager", c.InfrastructureServiceManager)
	populate(objectMap, "managementEndpoint", c.ManagementEndpoint)
	populate(objectMap, "nodeTypes", c.NodeTypes)
	populate(objectMap, "notifications", c.Notifications)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "reliabilityLevel", c.ReliabilityLevel)
	populate(objectMap, "reverseProxyCertificate", c.ReverseProxyCertificate)
	populate(objectMap, "reverseProxyCertificateCommonNames", c.ReverseProxyCertificateCommonNames)
	populate(objectMap, "sfZonalUpgradeMode", c.SfZonalUpgradeMode)
	populate(objectMap, "upgradeDescription", c.UpgradeDescription)
	populate(objectMap, "upgradeMode", c.UpgradeMode)
	populateDateTimeRFC3339(objectMap, "upgradePauseEndTimestampUtc", c.UpgradePauseEndTimestampUTC)
	populateDateTimeRFC3339(objectMap, "upgradePauseStartTimestampUtc", c.UpgradePauseStartTimestampUTC)
	populate(objectMap, "upgradeWave", c.UpgradeWave)
	populate(objectMap, "vmImage", c.VMImage)
	populate(objectMap, "vmssZonalUpgradeMode", c.VmssZonalUpgradeMode)
	populate(objectMap, "waveUpgradePaused", c.WaveUpgradePaused)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterProperties.
func (c *ClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addOnFeatures":
			err = unpopulate(val, "AddOnFeatures", &c.AddOnFeatures)
			delete(rawMsg, key)
		case "applicationTypeVersionsCleanupPolicy":
			err = unpopulate(val, "ApplicationTypeVersionsCleanupPolicy", &c.ApplicationTypeVersionsCleanupPolicy)
			delete(rawMsg, key)
		case "availableClusterVersions":
			err = unpopulate(val, "AvailableClusterVersions", &c.AvailableClusterVersions)
			delete(rawMsg, key)
		case "azureActiveDirectory":
			err = unpopulate(val, "AzureActiveDirectory", &c.AzureActiveDirectory)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "certificateCommonNames":
			err = unpopulate(val, "CertificateCommonNames", &c.CertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateCommonNames":
			err = unpopulate(val, "ClientCertificateCommonNames", &c.ClientCertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateThumbprints":
			err = unpopulate(val, "ClientCertificateThumbprints", &c.ClientCertificateThumbprints)
			delete(rawMsg, key)
		case "clusterCodeVersion":
			err = unpopulate(val, "ClusterCodeVersion", &c.ClusterCodeVersion)
			delete(rawMsg, key)
		case "clusterEndpoint":
			err = unpopulate(val, "ClusterEndpoint", &c.ClusterEndpoint)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &c.ClusterID)
			delete(rawMsg, key)
		case "clusterState":
			err = unpopulate(val, "ClusterState", &c.ClusterState)
			delete(rawMsg, key)
		case "diagnosticsStorageAccountConfig":
			err = unpopulate(val, "DiagnosticsStorageAccountConfig", &c.DiagnosticsStorageAccountConfig)
			delete(rawMsg, key)
		case "eventStoreServiceEnabled":
			err = unpopulate(val, "EventStoreServiceEnabled", &c.EventStoreServiceEnabled)
			delete(rawMsg, key)
		case "fabricSettings":
			err = unpopulate(val, "FabricSettings", &c.FabricSettings)
			delete(rawMsg, key)
		case "infrastructureServiceManager":
			err = unpopulate(val, "InfrastructureServiceManager", &c.InfrastructureServiceManager)
			delete(rawMsg, key)
		case "managementEndpoint":
			err = unpopulate(val, "ManagementEndpoint", &c.ManagementEndpoint)
			delete(rawMsg, key)
		case "nodeTypes":
			err = unpopulate(val, "NodeTypes", &c.NodeTypes)
			delete(rawMsg, key)
		case "notifications":
			err = unpopulate(val, "Notifications", &c.Notifications)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "reliabilityLevel":
			err = unpopulate(val, "ReliabilityLevel", &c.ReliabilityLevel)
			delete(rawMsg, key)
		case "reverseProxyCertificate":
			err = unpopulate(val, "ReverseProxyCertificate", &c.ReverseProxyCertificate)
			delete(rawMsg, key)
		case "reverseProxyCertificateCommonNames":
			err = unpopulate(val, "ReverseProxyCertificateCommonNames", &c.ReverseProxyCertificateCommonNames)
			delete(rawMsg, key)
		case "sfZonalUpgradeMode":
			err = unpopulate(val, "SfZonalUpgradeMode", &c.SfZonalUpgradeMode)
			delete(rawMsg, key)
		case "upgradeDescription":
			err = unpopulate(val, "UpgradeDescription", &c.UpgradeDescription)
			delete(rawMsg, key)
		case "upgradeMode":
			err = unpopulate(val, "UpgradeMode", &c.UpgradeMode)
			delete(rawMsg, key)
		case "upgradePauseEndTimestampUtc":
			err = unpopulateDateTimeRFC3339(val, "UpgradePauseEndTimestampUTC", &c.UpgradePauseEndTimestampUTC)
			delete(rawMsg, key)
		case "upgradePauseStartTimestampUtc":
			err = unpopulateDateTimeRFC3339(val, "UpgradePauseStartTimestampUTC", &c.UpgradePauseStartTimestampUTC)
			delete(rawMsg, key)
		case "upgradeWave":
			err = unpopulate(val, "UpgradeWave", &c.UpgradeWave)
			delete(rawMsg, key)
		case "vmImage":
			err = unpopulate(val, "VMImage", &c.VMImage)
			delete(rawMsg, key)
		case "vmssZonalUpgradeMode":
			err = unpopulate(val, "VmssZonalUpgradeMode", &c.VmssZonalUpgradeMode)
			delete(rawMsg, key)
		case "waveUpgradePaused":
			err = unpopulate(val, "WaveUpgradePaused", &c.WaveUpgradePaused)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPropertiesUpdateParameters.
func (c ClusterPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addOnFeatures", c.AddOnFeatures)
	populate(objectMap, "applicationTypeVersionsCleanupPolicy", c.ApplicationTypeVersionsCleanupPolicy)
	populate(objectMap, "certificate", c.Certificate)
	populate(objectMap, "certificateCommonNames", c.CertificateCommonNames)
	populate(objectMap, "clientCertificateCommonNames", c.ClientCertificateCommonNames)
	populate(objectMap, "clientCertificateThumbprints", c.ClientCertificateThumbprints)
	populate(objectMap, "clusterCodeVersion", c.ClusterCodeVersion)
	populate(objectMap, "eventStoreServiceEnabled", c.EventStoreServiceEnabled)
	populate(objectMap, "fabricSettings", c.FabricSettings)
	populate(objectMap, "infrastructureServiceManager", c.InfrastructureServiceManager)
	populate(objectMap, "nodeTypes", c.NodeTypes)
	populate(objectMap, "notifications", c.Notifications)
	populate(objectMap, "reliabilityLevel", c.ReliabilityLevel)
	populate(objectMap, "reverseProxyCertificate", c.ReverseProxyCertificate)
	populate(objectMap, "sfZonalUpgradeMode", c.SfZonalUpgradeMode)
	populate(objectMap, "upgradeDescription", c.UpgradeDescription)
	populate(objectMap, "upgradeMode", c.UpgradeMode)
	populateDateTimeRFC3339(objectMap, "upgradePauseEndTimestampUtc", c.UpgradePauseEndTimestampUTC)
	populateDateTimeRFC3339(objectMap, "upgradePauseStartTimestampUtc", c.UpgradePauseStartTimestampUTC)
	populate(objectMap, "upgradeWave", c.UpgradeWave)
	populate(objectMap, "vmssZonalUpgradeMode", c.VmssZonalUpgradeMode)
	populate(objectMap, "waveUpgradePaused", c.WaveUpgradePaused)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPropertiesUpdateParameters.
func (c *ClusterPropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addOnFeatures":
			err = unpopulate(val, "AddOnFeatures", &c.AddOnFeatures)
			delete(rawMsg, key)
		case "applicationTypeVersionsCleanupPolicy":
			err = unpopulate(val, "ApplicationTypeVersionsCleanupPolicy", &c.ApplicationTypeVersionsCleanupPolicy)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "certificateCommonNames":
			err = unpopulate(val, "CertificateCommonNames", &c.CertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateCommonNames":
			err = unpopulate(val, "ClientCertificateCommonNames", &c.ClientCertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateThumbprints":
			err = unpopulate(val, "ClientCertificateThumbprints", &c.ClientCertificateThumbprints)
			delete(rawMsg, key)
		case "clusterCodeVersion":
			err = unpopulate(val, "ClusterCodeVersion", &c.ClusterCodeVersion)
			delete(rawMsg, key)
		case "eventStoreServiceEnabled":
			err = unpopulate(val, "EventStoreServiceEnabled", &c.EventStoreServiceEnabled)
			delete(rawMsg, key)
		case "fabricSettings":
			err = unpopulate(val, "FabricSettings", &c.FabricSettings)
			delete(rawMsg, key)
		case "infrastructureServiceManager":
			err = unpopulate(val, "InfrastructureServiceManager", &c.InfrastructureServiceManager)
			delete(rawMsg, key)
		case "nodeTypes":
			err = unpopulate(val, "NodeTypes", &c.NodeTypes)
			delete(rawMsg, key)
		case "notifications":
			err = unpopulate(val, "Notifications", &c.Notifications)
			delete(rawMsg, key)
		case "reliabilityLevel":
			err = unpopulate(val, "ReliabilityLevel", &c.ReliabilityLevel)
			delete(rawMsg, key)
		case "reverseProxyCertificate":
			err = unpopulate(val, "ReverseProxyCertificate", &c.ReverseProxyCertificate)
			delete(rawMsg, key)
		case "sfZonalUpgradeMode":
			err = unpopulate(val, "SfZonalUpgradeMode", &c.SfZonalUpgradeMode)
			delete(rawMsg, key)
		case "upgradeDescription":
			err = unpopulate(val, "UpgradeDescription", &c.UpgradeDescription)
			delete(rawMsg, key)
		case "upgradeMode":
			err = unpopulate(val, "UpgradeMode", &c.UpgradeMode)
			delete(rawMsg, key)
		case "upgradePauseEndTimestampUtc":
			err = unpopulateDateTimeRFC3339(val, "UpgradePauseEndTimestampUTC", &c.UpgradePauseEndTimestampUTC)
			delete(rawMsg, key)
		case "upgradePauseStartTimestampUtc":
			err = unpopulateDateTimeRFC3339(val, "UpgradePauseStartTimestampUTC", &c.UpgradePauseStartTimestampUTC)
			delete(rawMsg, key)
		case "upgradeWave":
			err = unpopulate(val, "UpgradeWave", &c.UpgradeWave)
			delete(rawMsg, key)
		case "vmssZonalUpgradeMode":
			err = unpopulate(val, "VmssZonalUpgradeMode", &c.VmssZonalUpgradeMode)
			delete(rawMsg, key)
		case "waveUpgradePaused":
			err = unpopulate(val, "WaveUpgradePaused", &c.WaveUpgradePaused)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpdateParameters.
func (c ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterUpdateParameters.
func (c *ClusterUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpgradeDeltaHealthPolicy.
func (c ClusterUpgradeDeltaHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationDeltaHealthPolicies", c.ApplicationDeltaHealthPolicies)
	populate(objectMap, "maxPercentDeltaUnhealthyApplications", c.MaxPercentDeltaUnhealthyApplications)
	populate(objectMap, "maxPercentDeltaUnhealthyNodes", c.MaxPercentDeltaUnhealthyNodes)
	populate(objectMap, "maxPercentUpgradeDomainDeltaUnhealthyNodes", c.MaxPercentUpgradeDomainDeltaUnhealthyNodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterUpgradeDeltaHealthPolicy.
func (c *ClusterUpgradeDeltaHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationDeltaHealthPolicies":
			err = unpopulate(val, "ApplicationDeltaHealthPolicies", &c.ApplicationDeltaHealthPolicies)
			delete(rawMsg, key)
		case "maxPercentDeltaUnhealthyApplications":
			err = unpopulate(val, "MaxPercentDeltaUnhealthyApplications", &c.MaxPercentDeltaUnhealthyApplications)
			delete(rawMsg, key)
		case "maxPercentDeltaUnhealthyNodes":
			err = unpopulate(val, "MaxPercentDeltaUnhealthyNodes", &c.MaxPercentDeltaUnhealthyNodes)
			delete(rawMsg, key)
		case "maxPercentUpgradeDomainDeltaUnhealthyNodes":
			err = unpopulate(val, "MaxPercentUpgradeDomainDeltaUnhealthyNodes", &c.MaxPercentUpgradeDomainDeltaUnhealthyNodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpgradePolicy.
func (c ClusterUpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deltaHealthPolicy", c.DeltaHealthPolicy)
	populate(objectMap, "forceRestart", c.ForceRestart)
	populate(objectMap, "healthCheckRetryTimeout", c.HealthCheckRetryTimeout)
	populate(objectMap, "healthCheckStableDuration", c.HealthCheckStableDuration)
	populate(objectMap, "healthCheckWaitDuration", c.HealthCheckWaitDuration)
	populate(objectMap, "healthPolicy", c.HealthPolicy)
	populate(objectMap, "upgradeDomainTimeout", c.UpgradeDomainTimeout)
	populate(objectMap, "upgradeReplicaSetCheckTimeout", c.UpgradeReplicaSetCheckTimeout)
	populate(objectMap, "upgradeTimeout", c.UpgradeTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterUpgradePolicy.
func (c *ClusterUpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deltaHealthPolicy":
			err = unpopulate(val, "DeltaHealthPolicy", &c.DeltaHealthPolicy)
			delete(rawMsg, key)
		case "forceRestart":
			err = unpopulate(val, "ForceRestart", &c.ForceRestart)
			delete(rawMsg, key)
		case "healthCheckRetryTimeout":
			err = unpopulate(val, "HealthCheckRetryTimeout", &c.HealthCheckRetryTimeout)
			delete(rawMsg, key)
		case "healthCheckStableDuration":
			err = unpopulate(val, "HealthCheckStableDuration", &c.HealthCheckStableDuration)
			delete(rawMsg, key)
		case "healthCheckWaitDuration":
			err = unpopulate(val, "HealthCheckWaitDuration", &c.HealthCheckWaitDuration)
			delete(rawMsg, key)
		case "healthPolicy":
			err = unpopulate(val, "HealthPolicy", &c.HealthPolicy)
			delete(rawMsg, key)
		case "upgradeDomainTimeout":
			err = unpopulate(val, "UpgradeDomainTimeout", &c.UpgradeDomainTimeout)
			delete(rawMsg, key)
		case "upgradeReplicaSetCheckTimeout":
			err = unpopulate(val, "UpgradeReplicaSetCheckTimeout", &c.UpgradeReplicaSetCheckTimeout)
			delete(rawMsg, key)
		case "upgradeTimeout":
			err = unpopulate(val, "UpgradeTimeout", &c.UpgradeTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterVersionDetails.
func (c ClusterVersionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeVersion", c.CodeVersion)
	populate(objectMap, "environment", c.Environment)
	populate(objectMap, "supportExpiryUtc", c.SupportExpiryUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterVersionDetails.
func (c *ClusterVersionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeVersion":
			err = unpopulate(val, "CodeVersion", &c.CodeVersion)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &c.Environment)
			delete(rawMsg, key)
		case "supportExpiryUtc":
			err = unpopulate(val, "SupportExpiryUTC", &c.SupportExpiryUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsStorageAccountConfig.
func (d DiagnosticsStorageAccountConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobEndpoint", d.BlobEndpoint)
	populate(objectMap, "protectedAccountKeyName", d.ProtectedAccountKeyName)
	populate(objectMap, "protectedAccountKeyName2", d.ProtectedAccountKeyName2)
	populate(objectMap, "queueEndpoint", d.QueueEndpoint)
	populate(objectMap, "storageAccountName", d.StorageAccountName)
	populate(objectMap, "tableEndpoint", d.TableEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsStorageAccountConfig.
func (d *DiagnosticsStorageAccountConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobEndpoint":
			err = unpopulate(val, "BlobEndpoint", &d.BlobEndpoint)
			delete(rawMsg, key)
		case "protectedAccountKeyName":
			err = unpopulate(val, "ProtectedAccountKeyName", &d.ProtectedAccountKeyName)
			delete(rawMsg, key)
		case "protectedAccountKeyName2":
			err = unpopulate(val, "ProtectedAccountKeyName2", &d.ProtectedAccountKeyName2)
			delete(rawMsg, key)
		case "queueEndpoint":
			err = unpopulate(val, "QueueEndpoint", &d.QueueEndpoint)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &d.StorageAccountName)
			delete(rawMsg, key)
		case "tableEndpoint":
			err = unpopulate(val, "TableEndpoint", &d.TableEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointRangeDescription.
func (e EndpointRangeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endPort", e.EndPort)
	populate(objectMap, "startPort", e.StartPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointRangeDescription.
func (e *EndpointRangeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endPort":
			err = unpopulate(val, "EndPort", &e.EndPort)
			delete(rawMsg, key)
		case "startPort":
			err = unpopulate(val, "StartPort", &e.StartPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorModel.
func (e ErrorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorModel.
func (e *ErrorModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorModelError.
func (e ErrorModelError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorModelError.
func (e *ErrorModelError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentity.
func (m ManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentity.
func (m *ManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedPartitionSchemeDescription.
func (n NamedPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", n.Count)
	populate(objectMap, "names", n.Names)
	objectMap["partitionScheme"] = PartitionSchemeNamed
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedPartitionSchemeDescription.
func (n *NamedPartitionSchemeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		case "names":
			err = unpopulate(val, "Names", &n.Names)
			delete(rawMsg, key)
		case "partitionScheme":
			err = unpopulate(val, "PartitionScheme", &n.PartitionScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeTypeDescription.
func (n NodeTypeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationPorts", n.ApplicationPorts)
	populate(objectMap, "capacities", n.Capacities)
	populate(objectMap, "clientConnectionEndpointPort", n.ClientConnectionEndpointPort)
	populate(objectMap, "durabilityLevel", n.DurabilityLevel)
	populate(objectMap, "ephemeralPorts", n.EphemeralPorts)
	populate(objectMap, "httpGatewayEndpointPort", n.HTTPGatewayEndpointPort)
	populate(objectMap, "isPrimary", n.IsPrimary)
	populate(objectMap, "isStateless", n.IsStateless)
	populate(objectMap, "multipleAvailabilityZones", n.MultipleAvailabilityZones)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "placementProperties", n.PlacementProperties)
	populate(objectMap, "reverseProxyEndpointPort", n.ReverseProxyEndpointPort)
	populate(objectMap, "vmInstanceCount", n.VMInstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NodeTypeDescription.
func (n *NodeTypeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationPorts":
			err = unpopulate(val, "ApplicationPorts", &n.ApplicationPorts)
			delete(rawMsg, key)
		case "capacities":
			err = unpopulate(val, "Capacities", &n.Capacities)
			delete(rawMsg, key)
		case "clientConnectionEndpointPort":
			err = unpopulate(val, "ClientConnectionEndpointPort", &n.ClientConnectionEndpointPort)
			delete(rawMsg, key)
		case "durabilityLevel":
			err = unpopulate(val, "DurabilityLevel", &n.DurabilityLevel)
			delete(rawMsg, key)
		case "ephemeralPorts":
			err = unpopulate(val, "EphemeralPorts", &n.EphemeralPorts)
			delete(rawMsg, key)
		case "httpGatewayEndpointPort":
			err = unpopulate(val, "HTTPGatewayEndpointPort", &n.HTTPGatewayEndpointPort)
			delete(rawMsg, key)
		case "isPrimary":
			err = unpopulate(val, "IsPrimary", &n.IsPrimary)
			delete(rawMsg, key)
		case "isStateless":
			err = unpopulate(val, "IsStateless", &n.IsStateless)
			delete(rawMsg, key)
		case "multipleAvailabilityZones":
			err = unpopulate(val, "MultipleAvailabilityZones", &n.MultipleAvailabilityZones)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "placementProperties":
			err = unpopulate(val, "PlacementProperties", &n.PlacementProperties)
			delete(rawMsg, key)
		case "reverseProxyEndpointPort":
			err = unpopulate(val, "ReverseProxyEndpointPort", &n.ReverseProxyEndpointPort)
			delete(rawMsg, key)
		case "vmInstanceCount":
			err = unpopulate(val, "VMInstanceCount", &n.VMInstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Notification.
func (n Notification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isEnabled", n.IsEnabled)
	populate(objectMap, "notificationCategory", n.NotificationCategory)
	populate(objectMap, "notificationLevel", n.NotificationLevel)
	populate(objectMap, "notificationTargets", n.NotificationTargets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Notification.
func (n *Notification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &n.IsEnabled)
			delete(rawMsg, key)
		case "notificationCategory":
			err = unpopulate(val, "NotificationCategory", &n.NotificationCategory)
			delete(rawMsg, key)
		case "notificationLevel":
			err = unpopulate(val, "NotificationLevel", &n.NotificationLevel)
			delete(rawMsg, key)
		case "notificationTargets":
			err = unpopulate(val, "NotificationTargets", &n.NotificationTargets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationTarget.
func (n NotificationTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "notificationChannel", n.NotificationChannel)
	populate(objectMap, "receivers", n.Receivers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationTarget.
func (n *NotificationTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "notificationChannel":
			err = unpopulate(val, "NotificationChannel", &n.NotificationChannel)
			delete(rawMsg, key)
		case "receivers":
			err = unpopulate(val, "Receivers", &n.Receivers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResult.
func (o OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartitionSchemeDescription.
func (p PartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["partitionScheme"] = p.PartitionScheme
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartitionSchemeDescription.
func (p *PartitionSchemeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "partitionScheme":
			err = unpopulate(val, "PartitionScheme", &p.PartitionScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerCertificateCommonName.
func (s ServerCertificateCommonName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateCommonName", s.CertificateCommonName)
	populate(objectMap, "certificateIssuerThumbprint", s.CertificateIssuerThumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerCertificateCommonName.
func (s *ServerCertificateCommonName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateCommonName":
			err = unpopulate(val, "CertificateCommonName", &s.CertificateCommonName)
			delete(rawMsg, key)
		case "certificateIssuerThumbprint":
			err = unpopulate(val, "CertificateIssuerThumbprint", &s.CertificateIssuerThumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerCertificateCommonNames.
func (s ServerCertificateCommonNames) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commonNames", s.CommonNames)
	populate(objectMap, "x509StoreName", s.X509StoreName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerCertificateCommonNames.
func (s *ServerCertificateCommonNames) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commonNames":
			err = unpopulate(val, "CommonNames", &s.CommonNames)
			delete(rawMsg, key)
		case "x509StoreName":
			err = unpopulate(val, "X509StoreName", &s.X509StoreName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceCorrelationDescription.
func (s ServiceCorrelationDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scheme", s.Scheme)
	populate(objectMap, "serviceName", s.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceCorrelationDescription.
func (s *ServiceCorrelationDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scheme":
			err = unpopulate(val, "Scheme", &s.Scheme)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &s.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceLoadMetricDescription.
func (s ServiceLoadMetricDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultLoad", s.DefaultLoad)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "primaryDefaultLoad", s.PrimaryDefaultLoad)
	populate(objectMap, "secondaryDefaultLoad", s.SecondaryDefaultLoad)
	populate(objectMap, "weight", s.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceLoadMetricDescription.
func (s *ServiceLoadMetricDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultLoad":
			err = unpopulate(val, "DefaultLoad", &s.DefaultLoad)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "primaryDefaultLoad":
			err = unpopulate(val, "PrimaryDefaultLoad", &s.PrimaryDefaultLoad)
			delete(rawMsg, key)
		case "secondaryDefaultLoad":
			err = unpopulate(val, "SecondaryDefaultLoad", &s.SecondaryDefaultLoad)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &s.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePlacementPolicyDescription.
func (s ServicePlacementPolicyDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePlacementPolicyDescription.
func (s *ServicePlacementPolicyDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResource.
func (s ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResource.
func (s *ServiceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalServiceResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceList.
func (s ServiceResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceList.
func (s *ServiceResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceProperties.
func (s ServiceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "partitionDescription", s.PartitionDescription)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "serviceDnsName", s.ServiceDNSName)
	objectMap["serviceKind"] = s.ServiceKind
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePackageActivationMode", s.ServicePackageActivationMode)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populate(objectMap, "serviceTypeName", s.ServiceTypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceProperties.
func (s *ServiceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "partitionDescription":
			s.PartitionDescription, err = unmarshalPartitionSchemeDescriptionClassification(val)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "serviceDnsName":
			err = unpopulate(val, "ServiceDNSName", &s.ServiceDNSName)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePackageActivationMode":
			err = unpopulate(val, "ServicePackageActivationMode", &s.ServicePackageActivationMode)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "serviceTypeName":
			err = unpopulate(val, "ServiceTypeName", &s.ServiceTypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourcePropertiesBase.
func (s ServiceResourcePropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourcePropertiesBase.
func (s *ServiceResourcePropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceUpdate.
func (s ServiceResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceUpdate.
func (s *ServiceResourceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalServiceResourceUpdatePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceUpdateProperties.
func (s ServiceResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	objectMap["serviceKind"] = s.ServiceKind
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceUpdateProperties.
func (s *ServiceResourceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTypeDeltaHealthPolicy.
func (s ServiceTypeDeltaHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxPercentDeltaUnhealthyServices", s.MaxPercentDeltaUnhealthyServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTypeDeltaHealthPolicy.
func (s *ServiceTypeDeltaHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxPercentDeltaUnhealthyServices":
			err = unpopulate(val, "MaxPercentDeltaUnhealthyServices", &s.MaxPercentDeltaUnhealthyServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTypeHealthPolicy.
func (s ServiceTypeHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxPercentUnhealthyServices", s.MaxPercentUnhealthyServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTypeHealthPolicy.
func (s *ServiceTypeHealthPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxPercentUnhealthyServices":
			err = unpopulate(val, "MaxPercentUnhealthyServices", &s.MaxPercentUnhealthyServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SettingsParameterDescription.
func (s SettingsParameterDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SettingsParameterDescription.
func (s *SettingsParameterDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SettingsSectionDescription.
func (s SettingsSectionDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "parameters", s.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SettingsSectionDescription.
func (s *SettingsSectionDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SingletonPartitionSchemeDescription.
func (s SingletonPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["partitionScheme"] = PartitionSchemeSingleton
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingletonPartitionSchemeDescription.
func (s *SingletonPartitionSchemeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "partitionScheme":
			err = unpopulate(val, "PartitionScheme", &s.PartitionScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatefulServiceProperties.
func (s StatefulServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "hasPersistedState", s.HasPersistedState)
	populate(objectMap, "minReplicaSetSize", s.MinReplicaSetSize)
	populate(objectMap, "partitionDescription", s.PartitionDescription)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "quorumLossWaitDuration", s.QuorumLossWaitDuration)
	populateDateTimeRFC3339(objectMap, "replicaRestartWaitDuration", s.ReplicaRestartWaitDuration)
	populate(objectMap, "serviceDnsName", s.ServiceDNSName)
	objectMap["serviceKind"] = ServiceKindStateful
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePackageActivationMode", s.ServicePackageActivationMode)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populate(objectMap, "serviceTypeName", s.ServiceTypeName)
	populateDateTimeRFC3339(objectMap, "standByReplicaKeepDuration", s.StandByReplicaKeepDuration)
	populate(objectMap, "targetReplicaSetSize", s.TargetReplicaSetSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatefulServiceProperties.
func (s *StatefulServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "hasPersistedState":
			err = unpopulate(val, "HasPersistedState", &s.HasPersistedState)
			delete(rawMsg, key)
		case "minReplicaSetSize":
			err = unpopulate(val, "MinReplicaSetSize", &s.MinReplicaSetSize)
			delete(rawMsg, key)
		case "partitionDescription":
			s.PartitionDescription, err = unmarshalPartitionSchemeDescriptionClassification(val)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "quorumLossWaitDuration":
			err = unpopulateDateTimeRFC3339(val, "QuorumLossWaitDuration", &s.QuorumLossWaitDuration)
			delete(rawMsg, key)
		case "replicaRestartWaitDuration":
			err = unpopulateDateTimeRFC3339(val, "ReplicaRestartWaitDuration", &s.ReplicaRestartWaitDuration)
			delete(rawMsg, key)
		case "serviceDnsName":
			err = unpopulate(val, "ServiceDNSName", &s.ServiceDNSName)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePackageActivationMode":
			err = unpopulate(val, "ServicePackageActivationMode", &s.ServicePackageActivationMode)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "serviceTypeName":
			err = unpopulate(val, "ServiceTypeName", &s.ServiceTypeName)
			delete(rawMsg, key)
		case "standByReplicaKeepDuration":
			err = unpopulateDateTimeRFC3339(val, "StandByReplicaKeepDuration", &s.StandByReplicaKeepDuration)
			delete(rawMsg, key)
		case "targetReplicaSetSize":
			err = unpopulate(val, "TargetReplicaSetSize", &s.TargetReplicaSetSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatefulServiceUpdateProperties.
func (s StatefulServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "minReplicaSetSize", s.MinReplicaSetSize)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populateDateTimeRFC3339(objectMap, "quorumLossWaitDuration", s.QuorumLossWaitDuration)
	populateDateTimeRFC3339(objectMap, "replicaRestartWaitDuration", s.ReplicaRestartWaitDuration)
	objectMap["serviceKind"] = ServiceKindStateful
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populateDateTimeRFC3339(objectMap, "standByReplicaKeepDuration", s.StandByReplicaKeepDuration)
	populate(objectMap, "targetReplicaSetSize", s.TargetReplicaSetSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatefulServiceUpdateProperties.
func (s *StatefulServiceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "minReplicaSetSize":
			err = unpopulate(val, "MinReplicaSetSize", &s.MinReplicaSetSize)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "quorumLossWaitDuration":
			err = unpopulateDateTimeRFC3339(val, "QuorumLossWaitDuration", &s.QuorumLossWaitDuration)
			delete(rawMsg, key)
		case "replicaRestartWaitDuration":
			err = unpopulateDateTimeRFC3339(val, "ReplicaRestartWaitDuration", &s.ReplicaRestartWaitDuration)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "standByReplicaKeepDuration":
			err = unpopulateDateTimeRFC3339(val, "StandByReplicaKeepDuration", &s.StandByReplicaKeepDuration)
			delete(rawMsg, key)
		case "targetReplicaSetSize":
			err = unpopulate(val, "TargetReplicaSetSize", &s.TargetReplicaSetSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatelessServiceProperties.
func (s StatelessServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "instanceCloseDelayDuration", s.InstanceCloseDelayDuration)
	populate(objectMap, "instanceCount", s.InstanceCount)
	populate(objectMap, "partitionDescription", s.PartitionDescription)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "serviceDnsName", s.ServiceDNSName)
	objectMap["serviceKind"] = ServiceKindStateless
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePackageActivationMode", s.ServicePackageActivationMode)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populate(objectMap, "serviceTypeName", s.ServiceTypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatelessServiceProperties.
func (s *StatelessServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "instanceCloseDelayDuration":
			err = unpopulate(val, "InstanceCloseDelayDuration", &s.InstanceCloseDelayDuration)
			delete(rawMsg, key)
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &s.InstanceCount)
			delete(rawMsg, key)
		case "partitionDescription":
			s.PartitionDescription, err = unmarshalPartitionSchemeDescriptionClassification(val)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "serviceDnsName":
			err = unpopulate(val, "ServiceDNSName", &s.ServiceDNSName)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePackageActivationMode":
			err = unpopulate(val, "ServicePackageActivationMode", &s.ServicePackageActivationMode)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "serviceTypeName":
			err = unpopulate(val, "ServiceTypeName", &s.ServiceTypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatelessServiceUpdateProperties.
func (s StatelessServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "instanceCloseDelayDuration", s.InstanceCloseDelayDuration)
	populate(objectMap, "instanceCount", s.InstanceCount)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	objectMap["serviceKind"] = ServiceKindStateless
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatelessServiceUpdateProperties.
func (s *StatelessServiceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "instanceCloseDelayDuration":
			err = unpopulate(val, "InstanceCloseDelayDuration", &s.InstanceCloseDelayDuration)
			delete(rawMsg, key)
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &s.InstanceCount)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UniformInt64RangePartitionSchemeDescription.
func (u UniformInt64RangePartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", u.Count)
	populate(objectMap, "highKey", u.HighKey)
	populate(objectMap, "lowKey", u.LowKey)
	objectMap["partitionScheme"] = PartitionSchemeUniformInt64Range
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UniformInt64RangePartitionSchemeDescription.
func (u *UniformInt64RangePartitionSchemeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &u.Count)
			delete(rawMsg, key)
		case "highKey":
			err = unpopulate(val, "HighKey", &u.HighKey)
			delete(rawMsg, key)
		case "lowKey":
			err = unpopulate(val, "LowKey", &u.LowKey)
			delete(rawMsg, key)
		case "partitionScheme":
			err = unpopulate(val, "PartitionScheme", &u.PartitionScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradableVersionPathResult.
func (u UpgradableVersionPathResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportedPath", u.SupportedPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradableVersionPathResult.
func (u *UpgradableVersionPathResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportedPath":
			err = unpopulate(val, "SupportedPath", &u.SupportedPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradableVersionsDescription.
func (u UpgradableVersionsDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetVersion", u.TargetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradableVersionsDescription.
func (u *UpgradableVersionsDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetVersion":
			err = unpopulate(val, "TargetVersion", &u.TargetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
