// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/identity/accesscontextmanager/v1/access_level.proto

package accesscontextmanager

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	_type "google.golang.org/genproto/googleapis/identity/accesscontextmanager/type"
	expr "google.golang.org/genproto/googleapis/type/expr"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Options for how the `conditions` list should be combined to determine if
// this `AccessLevel` is applied. Default is AND.
type BasicLevel_ConditionCombiningFunction int32

const (
	// All `Conditions` must be true for the `BasicLevel` to be true.
	BasicLevel_AND BasicLevel_ConditionCombiningFunction = 0
	// If at least one `Condition` is true, then the `BasicLevel` is true.
	BasicLevel_OR BasicLevel_ConditionCombiningFunction = 1
)

// Enum value maps for BasicLevel_ConditionCombiningFunction.
var (
	BasicLevel_ConditionCombiningFunction_name = map[int32]string{
		0: "AND",
		1: "OR",
	}
	BasicLevel_ConditionCombiningFunction_value = map[string]int32{
		"AND": 0,
		"OR":  1,
	}
)

func (x BasicLevel_ConditionCombiningFunction) Enum() *BasicLevel_ConditionCombiningFunction {
	p := new(BasicLevel_ConditionCombiningFunction)
	*p = x
	return p
}

func (x BasicLevel_ConditionCombiningFunction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BasicLevel_ConditionCombiningFunction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_enumTypes[0].Descriptor()
}

func (BasicLevel_ConditionCombiningFunction) Type() protoreflect.EnumType {
	return &file_google_identity_accesscontextmanager_v1_access_level_proto_enumTypes[0]
}

func (x BasicLevel_ConditionCombiningFunction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BasicLevel_ConditionCombiningFunction.Descriptor instead.
func (BasicLevel_ConditionCombiningFunction) EnumDescriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP(), []int{1, 0}
}

// An `AccessLevel` is a label that can be applied to requests to Google Cloud
// services, along with a list of requirements necessary for the label to be
// applied.
type AccessLevel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the Access Level. The `short_name` component
	// must begin with a letter and only include alphanumeric and '_'. Format:
	// `accessPolicies/{policy_id}/accessLevels/{short_name}`. The maximum length
	// of the `short_name` component is 50 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable title. Must be unique within the Policy.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Description of the `AccessLevel` and its use. Does not affect behavior.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Describes the necessary conditions for the level to apply.
	//
	// Types that are assignable to Level:
	//	*AccessLevel_Basic
	//	*AccessLevel_Custom
	Level isAccessLevel_Level `protobuf_oneof:"level"`
	// Output only. Time the `AccessLevel` was created in UTC.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time the `AccessLevel` was updated in UTC.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *AccessLevel) Reset() {
	*x = AccessLevel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessLevel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessLevel) ProtoMessage() {}

func (x *AccessLevel) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessLevel.ProtoReflect.Descriptor instead.
func (*AccessLevel) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP(), []int{0}
}

func (x *AccessLevel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AccessLevel) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *AccessLevel) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *AccessLevel) GetLevel() isAccessLevel_Level {
	if m != nil {
		return m.Level
	}
	return nil
}

func (x *AccessLevel) GetBasic() *BasicLevel {
	if x, ok := x.GetLevel().(*AccessLevel_Basic); ok {
		return x.Basic
	}
	return nil
}

func (x *AccessLevel) GetCustom() *CustomLevel {
	if x, ok := x.GetLevel().(*AccessLevel_Custom); ok {
		return x.Custom
	}
	return nil
}

func (x *AccessLevel) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AccessLevel) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isAccessLevel_Level interface {
	isAccessLevel_Level()
}

type AccessLevel_Basic struct {
	// A `BasicLevel` composed of `Conditions`.
	Basic *BasicLevel `protobuf:"bytes,4,opt,name=basic,proto3,oneof"`
}

type AccessLevel_Custom struct {
	// A `CustomLevel` written in the Common Expression Language.
	Custom *CustomLevel `protobuf:"bytes,5,opt,name=custom,proto3,oneof"`
}

func (*AccessLevel_Basic) isAccessLevel_Level() {}

func (*AccessLevel_Custom) isAccessLevel_Level() {}

// `BasicLevel` is an `AccessLevel` using a set of recommended features.
type BasicLevel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of requirements for the `AccessLevel` to be granted.
	Conditions []*Condition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// How the `conditions` list should be combined to determine if a request is
	// granted this `AccessLevel`. If AND is used, each `Condition` in
	// `conditions` must be satisfied for the `AccessLevel` to be applied. If OR
	// is used, at least one `Condition` in `conditions` must be satisfied for the
	// `AccessLevel` to be applied. Default behavior is AND.
	CombiningFunction BasicLevel_ConditionCombiningFunction `protobuf:"varint,2,opt,name=combining_function,json=combiningFunction,proto3,enum=google.identity.accesscontextmanager.v1.BasicLevel_ConditionCombiningFunction" json:"combining_function,omitempty"`
}

func (x *BasicLevel) Reset() {
	*x = BasicLevel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BasicLevel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BasicLevel) ProtoMessage() {}

func (x *BasicLevel) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BasicLevel.ProtoReflect.Descriptor instead.
func (*BasicLevel) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP(), []int{1}
}

func (x *BasicLevel) GetConditions() []*Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *BasicLevel) GetCombiningFunction() BasicLevel_ConditionCombiningFunction {
	if x != nil {
		return x.CombiningFunction
	}
	return BasicLevel_AND
}

// A condition necessary for an `AccessLevel` to be granted. The Condition is an
// AND over its fields. So a Condition is true if: 1) the request IP is from one
// of the listed subnetworks AND 2) the originating device complies with the
// listed device policy AND 3) all listed access levels are granted AND 4) the
// request was sent at a time allowed by the DateTimeRestriction.
type Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for
	// a CIDR IP address block, the specified IP address portion must be properly
	// truncated (i.e. all the host bits must be zero) or the input is considered
	// malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is
	// not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas
	// "2001:db8::1/32" is not. The originating IP of a request must be in one of
	// the listed subnets in order for this Condition to be true. If empty, all IP
	// addresses are allowed.
	IpSubnetworks []string `protobuf:"bytes,1,rep,name=ip_subnetworks,json=ipSubnetworks,proto3" json:"ip_subnetworks,omitempty"`
	// Device specific restrictions, all restrictions must hold for the
	// Condition to be true. If not specified, all devices are allowed.
	DevicePolicy *DevicePolicy `protobuf:"bytes,2,opt,name=device_policy,json=devicePolicy,proto3" json:"device_policy,omitempty"`
	// A list of other access levels defined in the same `Policy`, referenced by
	// resource name. Referencing an `AccessLevel` which does not exist is an
	// error. All access levels listed must be granted for the Condition
	// to be true. Example:
	// "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
	RequiredAccessLevels []string `protobuf:"bytes,3,rep,name=required_access_levels,json=requiredAccessLevels,proto3" json:"required_access_levels,omitempty"`
	// Whether to negate the Condition. If true, the Condition becomes a NAND over
	// its non-empty fields, each field must be false for the Condition overall to
	// be satisfied. Defaults to false.
	Negate bool `protobuf:"varint,5,opt,name=negate,proto3" json:"negate,omitempty"`
	// The request must be made by one of the provided user or service
	// accounts. Groups are not supported.
	// Syntax:
	// `user:{emailid}`
	// `serviceAccount:{emailid}`
	// If not specified, a request may come from any user.
	Members []string `protobuf:"bytes,6,rep,name=members,proto3" json:"members,omitempty"`
	// The request must originate from one of the provided countries/regions.
	// Must be valid ISO 3166-1 alpha-2 codes.
	Regions []string `protobuf:"bytes,7,rep,name=regions,proto3" json:"regions,omitempty"`
}

func (x *Condition) Reset() {
	*x = Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP(), []int{2}
}

func (x *Condition) GetIpSubnetworks() []string {
	if x != nil {
		return x.IpSubnetworks
	}
	return nil
}

func (x *Condition) GetDevicePolicy() *DevicePolicy {
	if x != nil {
		return x.DevicePolicy
	}
	return nil
}

func (x *Condition) GetRequiredAccessLevels() []string {
	if x != nil {
		return x.RequiredAccessLevels
	}
	return nil
}

func (x *Condition) GetNegate() bool {
	if x != nil {
		return x.Negate
	}
	return false
}

func (x *Condition) GetMembers() []string {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *Condition) GetRegions() []string {
	if x != nil {
		return x.Regions
	}
	return nil
}

// `CustomLevel` is an `AccessLevel` using the Cloud Common Expression Language
// to represent the necessary conditions for the level to apply to a request.
// See CEL spec at: https://github.com/google/cel-spec
type CustomLevel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A Cloud CEL expression evaluating to a boolean.
	Expr *expr.Expr `protobuf:"bytes,1,opt,name=expr,proto3" json:"expr,omitempty"`
}

func (x *CustomLevel) Reset() {
	*x = CustomLevel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomLevel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomLevel) ProtoMessage() {}

func (x *CustomLevel) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomLevel.ProtoReflect.Descriptor instead.
func (*CustomLevel) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP(), []int{3}
}

func (x *CustomLevel) GetExpr() *expr.Expr {
	if x != nil {
		return x.Expr
	}
	return nil
}

// `DevicePolicy` specifies device specific restrictions necessary to acquire a
// given access level. A `DevicePolicy` specifies requirements for requests from
// devices to be granted access levels, it does not do any enforcement on the
// device. `DevicePolicy` acts as an AND over all specified fields, and each
// repeated field is an OR over its elements. Any unset fields are ignored. For
// example, if the proto is { os_type : DESKTOP_WINDOWS, os_type :
// DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be
// true for requests originating from encrypted Linux desktops and encrypted
// Windows desktops.
type DevicePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not screenlock is required for the DevicePolicy to be true.
	// Defaults to `false`.
	RequireScreenlock bool `protobuf:"varint,1,opt,name=require_screenlock,json=requireScreenlock,proto3" json:"require_screenlock,omitempty"`
	// Allowed encryptions statuses, an empty list allows all statuses.
	AllowedEncryptionStatuses []_type.DeviceEncryptionStatus `protobuf:"varint,2,rep,packed,name=allowed_encryption_statuses,json=allowedEncryptionStatuses,proto3,enum=google.identity.accesscontextmanager.type.DeviceEncryptionStatus" json:"allowed_encryption_statuses,omitempty"`
	// Allowed OS versions, an empty list allows all types and all versions.
	OsConstraints []*OsConstraint `protobuf:"bytes,3,rep,name=os_constraints,json=osConstraints,proto3" json:"os_constraints,omitempty"`
	// Allowed device management levels, an empty list allows all management
	// levels.
	AllowedDeviceManagementLevels []_type.DeviceManagementLevel `protobuf:"varint,6,rep,packed,name=allowed_device_management_levels,json=allowedDeviceManagementLevels,proto3,enum=google.identity.accesscontextmanager.type.DeviceManagementLevel" json:"allowed_device_management_levels,omitempty"`
	// Whether the device needs to be approved by the customer admin.
	RequireAdminApproval bool `protobuf:"varint,7,opt,name=require_admin_approval,json=requireAdminApproval,proto3" json:"require_admin_approval,omitempty"`
	// Whether the device needs to be corp owned.
	RequireCorpOwned bool `protobuf:"varint,8,opt,name=require_corp_owned,json=requireCorpOwned,proto3" json:"require_corp_owned,omitempty"`
}

func (x *DevicePolicy) Reset() {
	*x = DevicePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DevicePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DevicePolicy) ProtoMessage() {}

func (x *DevicePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DevicePolicy.ProtoReflect.Descriptor instead.
func (*DevicePolicy) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP(), []int{4}
}

func (x *DevicePolicy) GetRequireScreenlock() bool {
	if x != nil {
		return x.RequireScreenlock
	}
	return false
}

func (x *DevicePolicy) GetAllowedEncryptionStatuses() []_type.DeviceEncryptionStatus {
	if x != nil {
		return x.AllowedEncryptionStatuses
	}
	return nil
}

func (x *DevicePolicy) GetOsConstraints() []*OsConstraint {
	if x != nil {
		return x.OsConstraints
	}
	return nil
}

func (x *DevicePolicy) GetAllowedDeviceManagementLevels() []_type.DeviceManagementLevel {
	if x != nil {
		return x.AllowedDeviceManagementLevels
	}
	return nil
}

func (x *DevicePolicy) GetRequireAdminApproval() bool {
	if x != nil {
		return x.RequireAdminApproval
	}
	return false
}

func (x *DevicePolicy) GetRequireCorpOwned() bool {
	if x != nil {
		return x.RequireCorpOwned
	}
	return false
}

// A restriction on the OS type and version of devices making requests.
type OsConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The allowed OS type.
	OsType _type.OsType `protobuf:"varint,1,opt,name=os_type,json=osType,proto3,enum=google.identity.accesscontextmanager.type.OsType" json:"os_type,omitempty"`
	// The minimum allowed OS version. If not set, any version of this OS
	// satisfies the constraint. Format: `"major.minor.patch"`.
	// Examples: `"10.5.301"`, `"9.2.1"`.
	MinimumVersion string `protobuf:"bytes,2,opt,name=minimum_version,json=minimumVersion,proto3" json:"minimum_version,omitempty"`
	// Only allows requests from devices with a verified Chrome OS.
	// Verifications includes requirements that the device is enterprise-managed,
	// conformant to domain policies, and the caller has permission to call
	// the API targeted by the request.
	RequireVerifiedChromeOs bool `protobuf:"varint,3,opt,name=require_verified_chrome_os,json=requireVerifiedChromeOs,proto3" json:"require_verified_chrome_os,omitempty"`
}

func (x *OsConstraint) Reset() {
	*x = OsConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OsConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OsConstraint) ProtoMessage() {}

func (x *OsConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OsConstraint.ProtoReflect.Descriptor instead.
func (*OsConstraint) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP(), []int{5}
}

func (x *OsConstraint) GetOsType() _type.OsType {
	if x != nil {
		return x.OsType
	}
	return _type.OsType_OS_UNSPECIFIED
}

func (x *OsConstraint) GetMinimumVersion() string {
	if x != nil {
		return x.MinimumVersion
	}
	return ""
}

func (x *OsConstraint) GetRequireVerifiedChromeOs() bool {
	if x != nil {
		return x.RequireVerifiedChromeOs
	}
	return false
}

var File_google_identity_accesscontextmanager_v1_access_level_proto protoreflect.FileDescriptor

var file_google_identity_accesscontextmanager_v1_access_level_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9,
	0x02, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x05, 0x62, 0x61,
	0x73, 0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x00,
	0x52, 0x05, 0x62, 0x61, 0x73, 0x69, 0x63, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x00, 0x52,
	0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x42, 0x07, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x8e, 0x02, 0x0a, 0x0a, 0x42,
	0x61, 0x73, 0x69, 0x63, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x52, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7d, 0x0a,
	0x12, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x2e, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2d, 0x0a, 0x1a,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e,
	0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x52, 0x10, 0x01, 0x22, 0x90, 0x02, 0x0a, 0x09,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x70, 0x5f,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0d, 0x69, 0x70, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x12, 0x5a, 0x0a, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0c,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x34, 0x0a, 0x16,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x34,
	0x0a, 0x0b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x25, 0x0a,
	0x04, 0x65, 0x78, 0x70, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52, 0x04,
	0x65, 0x78, 0x70, 0x72, 0x22, 0x8f, 0x04, 0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x5f, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x81, 0x01, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x19, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x5c, 0x0a, 0x0e, 0x6f, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x73, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x0d, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x89, 0x01, 0x0a, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x52, 0x1d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x43, 0x6f, 0x72,
	0x70, 0x4f, 0x77, 0x6e, 0x65, 0x64, 0x22, 0xc0, 0x01, 0x0a, 0x0c, 0x4f, 0x73, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x07, 0x6f, 0x73, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x4f, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x6f, 0x73, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x69,
	0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x1a,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x5f, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x5f, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x17, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x43, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x4f, 0x73, 0x42, 0xa6, 0x02, 0x0a, 0x2b, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0xa2, 0x02, 0x04, 0x47, 0x41, 0x43,
	0x4d, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x27, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5c, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescOnce sync.Once
	file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescData = file_google_identity_accesscontextmanager_v1_access_level_proto_rawDesc
)

func file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescGZIP() []byte {
	file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescOnce.Do(func() {
		file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescData)
	})
	return file_google_identity_accesscontextmanager_v1_access_level_proto_rawDescData
}

var file_google_identity_accesscontextmanager_v1_access_level_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_identity_accesscontextmanager_v1_access_level_proto_goTypes = []interface{}{
	(BasicLevel_ConditionCombiningFunction)(0), // 0: google.identity.accesscontextmanager.v1.BasicLevel.ConditionCombiningFunction
	(*AccessLevel)(nil),                        // 1: google.identity.accesscontextmanager.v1.AccessLevel
	(*BasicLevel)(nil),                         // 2: google.identity.accesscontextmanager.v1.BasicLevel
	(*Condition)(nil),                          // 3: google.identity.accesscontextmanager.v1.Condition
	(*CustomLevel)(nil),                        // 4: google.identity.accesscontextmanager.v1.CustomLevel
	(*DevicePolicy)(nil),                       // 5: google.identity.accesscontextmanager.v1.DevicePolicy
	(*OsConstraint)(nil),                       // 6: google.identity.accesscontextmanager.v1.OsConstraint
	(*timestamppb.Timestamp)(nil),              // 7: google.protobuf.Timestamp
	(*expr.Expr)(nil),                          // 8: google.type.Expr
	(_type.DeviceEncryptionStatus)(0),          // 9: google.identity.accesscontextmanager.type.DeviceEncryptionStatus
	(_type.DeviceManagementLevel)(0),           // 10: google.identity.accesscontextmanager.type.DeviceManagementLevel
	(_type.OsType)(0),                          // 11: google.identity.accesscontextmanager.type.OsType
}
var file_google_identity_accesscontextmanager_v1_access_level_proto_depIdxs = []int32{
	2,  // 0: google.identity.accesscontextmanager.v1.AccessLevel.basic:type_name -> google.identity.accesscontextmanager.v1.BasicLevel
	4,  // 1: google.identity.accesscontextmanager.v1.AccessLevel.custom:type_name -> google.identity.accesscontextmanager.v1.CustomLevel
	7,  // 2: google.identity.accesscontextmanager.v1.AccessLevel.create_time:type_name -> google.protobuf.Timestamp
	7,  // 3: google.identity.accesscontextmanager.v1.AccessLevel.update_time:type_name -> google.protobuf.Timestamp
	3,  // 4: google.identity.accesscontextmanager.v1.BasicLevel.conditions:type_name -> google.identity.accesscontextmanager.v1.Condition
	0,  // 5: google.identity.accesscontextmanager.v1.BasicLevel.combining_function:type_name -> google.identity.accesscontextmanager.v1.BasicLevel.ConditionCombiningFunction
	5,  // 6: google.identity.accesscontextmanager.v1.Condition.device_policy:type_name -> google.identity.accesscontextmanager.v1.DevicePolicy
	8,  // 7: google.identity.accesscontextmanager.v1.CustomLevel.expr:type_name -> google.type.Expr
	9,  // 8: google.identity.accesscontextmanager.v1.DevicePolicy.allowed_encryption_statuses:type_name -> google.identity.accesscontextmanager.type.DeviceEncryptionStatus
	6,  // 9: google.identity.accesscontextmanager.v1.DevicePolicy.os_constraints:type_name -> google.identity.accesscontextmanager.v1.OsConstraint
	10, // 10: google.identity.accesscontextmanager.v1.DevicePolicy.allowed_device_management_levels:type_name -> google.identity.accesscontextmanager.type.DeviceManagementLevel
	11, // 11: google.identity.accesscontextmanager.v1.OsConstraint.os_type:type_name -> google.identity.accesscontextmanager.type.OsType
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_identity_accesscontextmanager_v1_access_level_proto_init() }
func file_google_identity_accesscontextmanager_v1_access_level_proto_init() {
	if File_google_identity_accesscontextmanager_v1_access_level_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessLevel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BasicLevel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomLevel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DevicePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OsConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AccessLevel_Basic)(nil),
		(*AccessLevel_Custom)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_identity_accesscontextmanager_v1_access_level_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_identity_accesscontextmanager_v1_access_level_proto_goTypes,
		DependencyIndexes: file_google_identity_accesscontextmanager_v1_access_level_proto_depIdxs,
		EnumInfos:         file_google_identity_accesscontextmanager_v1_access_level_proto_enumTypes,
		MessageInfos:      file_google_identity_accesscontextmanager_v1_access_level_proto_msgTypes,
	}.Build()
	File_google_identity_accesscontextmanager_v1_access_level_proto = out.File
	file_google_identity_accesscontextmanager_v1_access_level_proto_rawDesc = nil
	file_google_identity_accesscontextmanager_v1_access_level_proto_goTypes = nil
	file_google_identity_accesscontextmanager_v1_access_level_proto_depIdxs = nil
}
