// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakerfeaturestoreruntime

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBatchGetRecord struct {
}

func (*awsRestjson1_serializeOpBatchGetRecord) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetRecord) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetRecordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/BatchGetRecord")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetRecordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetRecordInput(v *BatchGetRecordInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetRecordInput(v *BatchGetRecordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ExpirationTimeResponse) > 0 {
		ok := object.Key("ExpirationTimeResponse")
		ok.String(string(v.ExpirationTimeResponse))
	}

	if v.Identifiers != nil {
		ok := object.Key("Identifiers")
		if err := awsRestjson1_serializeDocumentBatchGetRecordIdentifiers(v.Identifiers, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRecord struct {
}

func (*awsRestjson1_serializeOpDeleteRecord) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRecord) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRecordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FeatureGroup/{FeatureGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRecordInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRecordInput(v *DeleteRecordInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.DeletionMode) > 0 {
		encoder.SetQuery("DeletionMode").String(string(v.DeletionMode))
	}

	if v.EventTime != nil {
		encoder.SetQuery("EventTime").String(*v.EventTime)
	}

	if v.FeatureGroupName == nil || len(*v.FeatureGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FeatureGroupName must not be empty")}
	}
	if v.FeatureGroupName != nil {
		if err := encoder.SetURI("FeatureGroupName").String(*v.FeatureGroupName); err != nil {
			return err
		}
	}

	if v.RecordIdentifierValueAsString != nil {
		encoder.SetQuery("RecordIdentifierValueAsString").String(*v.RecordIdentifierValueAsString)
	}

	if v.TargetStores != nil {
		for i := range v.TargetStores {
			encoder.AddQuery("TargetStores").String(string(v.TargetStores[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRecord struct {
}

func (*awsRestjson1_serializeOpGetRecord) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRecord) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRecordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FeatureGroup/{FeatureGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRecordInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRecordInput(v *GetRecordInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ExpirationTimeResponse) > 0 {
		encoder.SetQuery("ExpirationTimeResponse").String(string(v.ExpirationTimeResponse))
	}

	if v.FeatureGroupName == nil || len(*v.FeatureGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FeatureGroupName must not be empty")}
	}
	if v.FeatureGroupName != nil {
		if err := encoder.SetURI("FeatureGroupName").String(*v.FeatureGroupName); err != nil {
			return err
		}
	}

	if v.FeatureNames != nil {
		for i := range v.FeatureNames {
			encoder.AddQuery("FeatureName").String(v.FeatureNames[i])
		}
	}

	if v.RecordIdentifierValueAsString != nil {
		encoder.SetQuery("RecordIdentifierValueAsString").String(*v.RecordIdentifierValueAsString)
	}

	return nil
}

type awsRestjson1_serializeOpPutRecord struct {
}

func (*awsRestjson1_serializeOpPutRecord) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutRecord) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutRecordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FeatureGroup/{FeatureGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutRecordInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutRecordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutRecordInput(v *PutRecordInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FeatureGroupName == nil || len(*v.FeatureGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FeatureGroupName must not be empty")}
	}
	if v.FeatureGroupName != nil {
		if err := encoder.SetURI("FeatureGroupName").String(*v.FeatureGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutRecordInput(v *PutRecordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Record != nil {
		ok := object.Key("Record")
		if err := awsRestjson1_serializeDocumentRecord(v.Record, ok); err != nil {
			return err
		}
	}

	if v.TargetStores != nil {
		ok := object.Key("TargetStores")
		if err := awsRestjson1_serializeDocumentTargetStores(v.TargetStores, ok); err != nil {
			return err
		}
	}

	if v.TtlDuration != nil {
		ok := object.Key("TtlDuration")
		if err := awsRestjson1_serializeDocumentTtlDuration(v.TtlDuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchGetRecordIdentifier(v *types.BatchGetRecordIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FeatureGroupName != nil {
		ok := object.Key("FeatureGroupName")
		ok.String(*v.FeatureGroupName)
	}

	if v.FeatureNames != nil {
		ok := object.Key("FeatureNames")
		if err := awsRestjson1_serializeDocumentFeatureNames(v.FeatureNames, ok); err != nil {
			return err
		}
	}

	if v.RecordIdentifiersValueAsString != nil {
		ok := object.Key("RecordIdentifiersValueAsString")
		if err := awsRestjson1_serializeDocumentRecordIdentifiers(v.RecordIdentifiersValueAsString, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchGetRecordIdentifiers(v []types.BatchGetRecordIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatchGetRecordIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFeatureNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFeatureValue(v *types.FeatureValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FeatureName != nil {
		ok := object.Key("FeatureName")
		ok.String(*v.FeatureName)
	}

	if v.ValueAsString != nil {
		ok := object.Key("ValueAsString")
		ok.String(*v.ValueAsString)
	}

	if v.ValueAsStringList != nil {
		ok := object.Key("ValueAsStringList")
		if err := awsRestjson1_serializeDocumentValueAsStringList(v.ValueAsStringList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRecord(v []types.FeatureValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFeatureValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRecordIdentifiers(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTargetStores(v []types.TargetStore, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentTtlDuration(v *types.TtlDuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentValueAsStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}
