// Code generated by smithy-go-codegen DO NOT EDIT.

package route53profiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53profiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Associates a DNS reource configuration to a Route 53 Profile.
func (c *Client) AssociateResourceToProfile(ctx context.Context, params *AssociateResourceToProfileInput, optFns ...func(*Options)) (*AssociateResourceToProfileOutput, error) {
	if params == nil {
		params = &AssociateResourceToProfileInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateResourceToProfile", params, optFns, c.addOperationAssociateResourceToProfileMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateResourceToProfileOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateResourceToProfileInput struct {

	//  Name for the resource association.
	//
	// This member is required.
	Name *string

	//  ID of the Profile.
	//
	// This member is required.
	ProfileId *string

	//  Amazon resource number, ARN, of the DNS resource.
	//
	// This member is required.
	ResourceArn *string

	//  If you are adding a DNS Firewall rule group, include also a priority. The
	// priority indicates the processing order for the rule groups, starting with the
	// priority assinged the lowest value.
	//
	// The allowed values for priority are between 100 and 9900.
	ResourceProperties *string

	noSmithyDocumentSerde
}

type AssociateResourceToProfileOutput struct {

	//  Infromation about the AssociateResourceToProfile , including a status message.
	ProfileResourceAssociation *types.ProfileResourceAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateResourceToProfileMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAssociateResourceToProfile{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAssociateResourceToProfile{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateResourceToProfile"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAssociateResourceToProfileValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateResourceToProfile(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssociateResourceToProfile(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateResourceToProfile",
	}
}
