// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/ai/generativelanguage/v1beta/tuned_model.proto

package generativelanguagepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the tuned model.
type TunedModel_State int32

const (
	// The default value. This value is unused.
	TunedModel_STATE_UNSPECIFIED TunedModel_State = 0
	// The model is being created.
	TunedModel_CREATING TunedModel_State = 1
	// The model is ready to be used.
	TunedModel_ACTIVE TunedModel_State = 2
	// The model failed to be created.
	TunedModel_FAILED TunedModel_State = 3
)

// Enum value maps for TunedModel_State.
var (
	TunedModel_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "FAILED",
	}
	TunedModel_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"FAILED":            3,
	}
)

func (x TunedModel_State) Enum() *TunedModel_State {
	p := new(TunedModel_State)
	*p = x
	return p
}

func (x TunedModel_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TunedModel_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_enumTypes[0].Descriptor()
}

func (TunedModel_State) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_tuned_model_proto_enumTypes[0]
}

func (x TunedModel_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TunedModel_State.Descriptor instead.
func (TunedModel_State) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{0, 0}
}

// A fine-tuned model created using ModelService.CreateTunedModel.
type TunedModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The model used as the starting point for tuning.
	//
	// Types that are assignable to SourceModel:
	//
	//	*TunedModel_TunedModelSource
	//	*TunedModel_BaseModel
	SourceModel isTunedModel_SourceModel `protobuf_oneof:"source_model"`
	// Output only. The tuned model name. A unique name will be generated on
	// create. Example: `tunedModels/az2mb0bpw6i` If display_name is set on
	// create, the id portion of the name will be set by concatenating the words
	// of the display_name with hyphens and adding a random portion for
	// uniqueness. Example:
	//
	//	display_name = "Sentence Translator"
	//	name = "tunedModels/sentence-translator-u3b7m"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name to display for this model in user interfaces.
	// The display name must be up to 40 characters including spaces.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. A short description of this model.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Controls the randomness of the output.
	//
	// Values can range over `[0.0,1.0]`, inclusive. A value closer to `1.0` will
	// produce responses that are more varied, while a value closer to `0.0` will
	// typically result in less surprising responses from the model.
	//
	// This value specifies default to be the one used by the base model while
	// creating the model.
	Temperature *float32 `protobuf:"fixed32,11,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// Optional. For Nucleus sampling.
	//
	// Nucleus sampling considers the smallest set of tokens whose probability
	// sum is at least `top_p`.
	//
	// This value specifies default to be the one used by the base model while
	// creating the model.
	TopP *float32 `protobuf:"fixed32,12,opt,name=top_p,json=topP,proto3,oneof" json:"top_p,omitempty"`
	// Optional. For Top-k sampling.
	//
	// Top-k sampling considers the set of `top_k` most probable tokens.
	// This value specifies default to be used by the backend while making the
	// call to the model.
	//
	// This value specifies default to be the one used by the base model while
	// creating the model.
	TopK *int32 `protobuf:"varint,13,opt,name=top_k,json=topK,proto3,oneof" json:"top_k,omitempty"`
	// Output only. The state of the tuned model.
	State TunedModel_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.ai.generativelanguage.v1beta.TunedModel_State" json:"state,omitempty"`
	// Output only. The timestamp when this model was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this model was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The tuning task that creates the tuned model.
	TuningTask *TuningTask `protobuf:"bytes,10,opt,name=tuning_task,json=tuningTask,proto3" json:"tuning_task,omitempty"`
}

func (x *TunedModel) Reset() {
	*x = TunedModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TunedModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunedModel) ProtoMessage() {}

func (x *TunedModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunedModel.ProtoReflect.Descriptor instead.
func (*TunedModel) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{0}
}

func (m *TunedModel) GetSourceModel() isTunedModel_SourceModel {
	if m != nil {
		return m.SourceModel
	}
	return nil
}

func (x *TunedModel) GetTunedModelSource() *TunedModelSource {
	if x, ok := x.GetSourceModel().(*TunedModel_TunedModelSource); ok {
		return x.TunedModelSource
	}
	return nil
}

func (x *TunedModel) GetBaseModel() string {
	if x, ok := x.GetSourceModel().(*TunedModel_BaseModel); ok {
		return x.BaseModel
	}
	return ""
}

func (x *TunedModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TunedModel) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TunedModel) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TunedModel) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *TunedModel) GetTopP() float32 {
	if x != nil && x.TopP != nil {
		return *x.TopP
	}
	return 0
}

func (x *TunedModel) GetTopK() int32 {
	if x != nil && x.TopK != nil {
		return *x.TopK
	}
	return 0
}

func (x *TunedModel) GetState() TunedModel_State {
	if x != nil {
		return x.State
	}
	return TunedModel_STATE_UNSPECIFIED
}

func (x *TunedModel) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TunedModel) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TunedModel) GetTuningTask() *TuningTask {
	if x != nil {
		return x.TuningTask
	}
	return nil
}

type isTunedModel_SourceModel interface {
	isTunedModel_SourceModel()
}

type TunedModel_TunedModelSource struct {
	// Optional. TunedModel to use as the starting point for training the new
	// model.
	TunedModelSource *TunedModelSource `protobuf:"bytes,3,opt,name=tuned_model_source,json=tunedModelSource,proto3,oneof"`
}

type TunedModel_BaseModel struct {
	// Immutable. The name of the `Model` to tune.
	// Example: `models/text-bison-001`
	BaseModel string `protobuf:"bytes,4,opt,name=base_model,json=baseModel,proto3,oneof"`
}

func (*TunedModel_TunedModelSource) isTunedModel_SourceModel() {}

func (*TunedModel_BaseModel) isTunedModel_SourceModel() {}

// Tuned model as a source for training a new model.
type TunedModelSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the `TunedModel` to use as the starting point for
	// training the new model.
	// Example: `tunedModels/my-tuned-model`
	TunedModel string `protobuf:"bytes,1,opt,name=tuned_model,json=tunedModel,proto3" json:"tuned_model,omitempty"`
	// Output only. The name of the base `Model` this `TunedModel` was tuned from.
	// Example: `models/text-bison-001`
	BaseModel string `protobuf:"bytes,2,opt,name=base_model,json=baseModel,proto3" json:"base_model,omitempty"`
}

func (x *TunedModelSource) Reset() {
	*x = TunedModelSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TunedModelSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunedModelSource) ProtoMessage() {}

func (x *TunedModelSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunedModelSource.ProtoReflect.Descriptor instead.
func (*TunedModelSource) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{1}
}

func (x *TunedModelSource) GetTunedModel() string {
	if x != nil {
		return x.TunedModel
	}
	return ""
}

func (x *TunedModelSource) GetBaseModel() string {
	if x != nil {
		return x.BaseModel
	}
	return ""
}

// Tuning tasks that create tuned models.
type TuningTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The timestamp when tuning this model started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The timestamp when tuning this model completed.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Output only. Metrics collected during tuning.
	Snapshots []*TuningSnapshot `protobuf:"bytes,3,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// Required. Input only. Immutable. The model training data.
	TrainingData *Dataset `protobuf:"bytes,4,opt,name=training_data,json=trainingData,proto3" json:"training_data,omitempty"`
	// Immutable. Hyperparameters controlling the tuning process. If not provided,
	// default values will be used.
	Hyperparameters *Hyperparameters `protobuf:"bytes,5,opt,name=hyperparameters,proto3" json:"hyperparameters,omitempty"`
}

func (x *TuningTask) Reset() {
	*x = TuningTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TuningTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningTask) ProtoMessage() {}

func (x *TuningTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningTask.ProtoReflect.Descriptor instead.
func (*TuningTask) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{2}
}

func (x *TuningTask) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TuningTask) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *TuningTask) GetSnapshots() []*TuningSnapshot {
	if x != nil {
		return x.Snapshots
	}
	return nil
}

func (x *TuningTask) GetTrainingData() *Dataset {
	if x != nil {
		return x.TrainingData
	}
	return nil
}

func (x *TuningTask) GetHyperparameters() *Hyperparameters {
	if x != nil {
		return x.Hyperparameters
	}
	return nil
}

// Hyperparameters controlling the tuning process. Read more at
// https://ai.google.dev/docs/model_tuning_guidance
type Hyperparameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Options for specifying learning rate during tuning.
	//
	// Types that are assignable to LearningRateOption:
	//
	//	*Hyperparameters_LearningRate
	//	*Hyperparameters_LearningRateMultiplier
	LearningRateOption isHyperparameters_LearningRateOption `protobuf_oneof:"learning_rate_option"`
	// Immutable. The number of training epochs. An epoch is one pass through the
	// training data. If not set, a default of 5 will be used.
	EpochCount *int32 `protobuf:"varint,14,opt,name=epoch_count,json=epochCount,proto3,oneof" json:"epoch_count,omitempty"`
	// Immutable. The batch size hyperparameter for tuning.
	// If not set, a default of 4 or 16 will be used based on the number of
	// training examples.
	BatchSize *int32 `protobuf:"varint,15,opt,name=batch_size,json=batchSize,proto3,oneof" json:"batch_size,omitempty"`
}

func (x *Hyperparameters) Reset() {
	*x = Hyperparameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Hyperparameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hyperparameters) ProtoMessage() {}

func (x *Hyperparameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hyperparameters.ProtoReflect.Descriptor instead.
func (*Hyperparameters) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{3}
}

func (m *Hyperparameters) GetLearningRateOption() isHyperparameters_LearningRateOption {
	if m != nil {
		return m.LearningRateOption
	}
	return nil
}

func (x *Hyperparameters) GetLearningRate() float32 {
	if x, ok := x.GetLearningRateOption().(*Hyperparameters_LearningRate); ok {
		return x.LearningRate
	}
	return 0
}

func (x *Hyperparameters) GetLearningRateMultiplier() float32 {
	if x, ok := x.GetLearningRateOption().(*Hyperparameters_LearningRateMultiplier); ok {
		return x.LearningRateMultiplier
	}
	return 0
}

func (x *Hyperparameters) GetEpochCount() int32 {
	if x != nil && x.EpochCount != nil {
		return *x.EpochCount
	}
	return 0
}

func (x *Hyperparameters) GetBatchSize() int32 {
	if x != nil && x.BatchSize != nil {
		return *x.BatchSize
	}
	return 0
}

type isHyperparameters_LearningRateOption interface {
	isHyperparameters_LearningRateOption()
}

type Hyperparameters_LearningRate struct {
	// Optional. Immutable. The learning rate hyperparameter for tuning.
	// If not set, a default of 0.001 or 0.0002 will be calculated based on the
	// number of training examples.
	LearningRate float32 `protobuf:"fixed32,16,opt,name=learning_rate,json=learningRate,proto3,oneof"`
}

type Hyperparameters_LearningRateMultiplier struct {
	// Optional. Immutable. The learning rate multiplier is used to calculate a
	// final learning_rate based on the default (recommended) value. Actual
	// learning rate := learning_rate_multiplier * default learning rate Default
	// learning rate is dependent on base model and dataset size. If not set, a
	// default of 1.0 will be used.
	LearningRateMultiplier float32 `protobuf:"fixed32,17,opt,name=learning_rate_multiplier,json=learningRateMultiplier,proto3,oneof"`
}

func (*Hyperparameters_LearningRate) isHyperparameters_LearningRateOption() {}

func (*Hyperparameters_LearningRateMultiplier) isHyperparameters_LearningRateOption() {}

// Dataset for training or validation.
type Dataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Inline data or a reference to the data.
	//
	// Types that are assignable to Dataset:
	//
	//	*Dataset_Examples
	Dataset isDataset_Dataset `protobuf_oneof:"dataset"`
}

func (x *Dataset) Reset() {
	*x = Dataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset) ProtoMessage() {}

func (x *Dataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset.ProtoReflect.Descriptor instead.
func (*Dataset) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{4}
}

func (m *Dataset) GetDataset() isDataset_Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

func (x *Dataset) GetExamples() *TuningExamples {
	if x, ok := x.GetDataset().(*Dataset_Examples); ok {
		return x.Examples
	}
	return nil
}

type isDataset_Dataset interface {
	isDataset_Dataset()
}

type Dataset_Examples struct {
	// Optional. Inline examples.
	Examples *TuningExamples `protobuf:"bytes,1,opt,name=examples,proto3,oneof"`
}

func (*Dataset_Examples) isDataset_Dataset() {}

// A set of tuning examples. Can be training or validation data.
type TuningExamples struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The examples. Example input can be for text or discuss, but all
	// examples in a set must be of the same type.
	Examples []*TuningExample `protobuf:"bytes,1,rep,name=examples,proto3" json:"examples,omitempty"`
}

func (x *TuningExamples) Reset() {
	*x = TuningExamples{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TuningExamples) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningExamples) ProtoMessage() {}

func (x *TuningExamples) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningExamples.ProtoReflect.Descriptor instead.
func (*TuningExamples) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{5}
}

func (x *TuningExamples) GetExamples() []*TuningExample {
	if x != nil {
		return x.Examples
	}
	return nil
}

// A single example for tuning.
type TuningExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input to the model for this example.
	//
	// Types that are assignable to ModelInput:
	//
	//	*TuningExample_TextInput
	ModelInput isTuningExample_ModelInput `protobuf_oneof:"model_input"`
	// Required. The expected model output.
	Output string `protobuf:"bytes,3,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *TuningExample) Reset() {
	*x = TuningExample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TuningExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningExample) ProtoMessage() {}

func (x *TuningExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningExample.ProtoReflect.Descriptor instead.
func (*TuningExample) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{6}
}

func (m *TuningExample) GetModelInput() isTuningExample_ModelInput {
	if m != nil {
		return m.ModelInput
	}
	return nil
}

func (x *TuningExample) GetTextInput() string {
	if x, ok := x.GetModelInput().(*TuningExample_TextInput); ok {
		return x.TextInput
	}
	return ""
}

func (x *TuningExample) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

type isTuningExample_ModelInput interface {
	isTuningExample_ModelInput()
}

type TuningExample_TextInput struct {
	// Optional. Text model input.
	TextInput string `protobuf:"bytes,1,opt,name=text_input,json=textInput,proto3,oneof"`
}

func (*TuningExample_TextInput) isTuningExample_ModelInput() {}

// Record for a single tuning step.
type TuningSnapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The tuning step.
	Step int32 `protobuf:"varint,1,opt,name=step,proto3" json:"step,omitempty"`
	// Output only. The epoch this step was part of.
	Epoch int32 `protobuf:"varint,2,opt,name=epoch,proto3" json:"epoch,omitempty"`
	// Output only. The mean loss of the training examples for this step.
	MeanLoss float32 `protobuf:"fixed32,3,opt,name=mean_loss,json=meanLoss,proto3" json:"mean_loss,omitempty"`
	// Output only. The timestamp when this metric was computed.
	ComputeTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=compute_time,json=computeTime,proto3" json:"compute_time,omitempty"`
}

func (x *TuningSnapshot) Reset() {
	*x = TuningSnapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TuningSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningSnapshot) ProtoMessage() {}

func (x *TuningSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningSnapshot.ProtoReflect.Descriptor instead.
func (*TuningSnapshot) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP(), []int{7}
}

func (x *TuningSnapshot) GetStep() int32 {
	if x != nil {
		return x.Step
	}
	return 0
}

func (x *TuningSnapshot) GetEpoch() int32 {
	if x != nil {
		return x.Epoch
	}
	return 0
}

func (x *TuningSnapshot) GetMeanLoss() float32 {
	if x != nil {
		return x.MeanLoss
	}
	return 0
}

func (x *TuningSnapshot) GetComputeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ComputeTime
	}
	return nil
}

var File_google_ai_generativelanguage_v1beta_tuned_model_proto protoreflect.FileDescriptor

var file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x07, 0x0a, 0x0a, 0x54, 0x75,
	0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x6a, 0x0a, 0x12, 0x74, 0x75, 0x6e, 0x65,
	0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x75, 0x6e, 0x65, 0x64,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x10, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x09, 0x62, 0x61, 0x73,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a,
	0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x5f, 0x70, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02,
	0x52, 0x04, 0x74, 0x6f, 0x70, 0x50, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70,
	0x5f, 0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52,
	0x04, 0x74, 0x6f, 0x70, 0x4b, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x75,
	0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55,
	0x0a, 0x0b, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x54, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x54, 0x61, 0x73, 0x6b, 0x22, 0x44, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x65, 0xea, 0x41, 0x62,
	0x0a, 0x2c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x19,
	0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x74, 0x75, 0x6e,
	0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x2a, 0x0b, 0x74, 0x75, 0x6e, 0x65, 0x64,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x32, 0x0a, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x42, 0x0e, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x22, 0xb9, 0x01, 0x0a, 0x10, 0x54, 0x75, 0x6e, 0x65, 0x64,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x0b, 0x74,
	0x75, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0a, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x12, 0x4e, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x29, 0x0a, 0x27,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x22, 0xad, 0x03, 0x0a, 0x0a, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x73,
	0x6b, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12,
	0x5c, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x42, 0x09, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52,
	0x0c, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x12, 0x63, 0x0a,
	0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x48, 0x79, 0x70,
	0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x22, 0x8f, 0x02, 0x0a, 0x0f, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x0a, 0x0d, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x02, 0x42, 0x06, 0xe0,
	0x41, 0x05, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x52, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x18, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65,
	0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x02, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x16, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x4d,
	0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x0b, 0x65, 0x70, 0x6f,
	0x63, 0x68, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x48, 0x01, 0x52, 0x0a, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x02, 0x52,
	0x09, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x42, 0x16, 0x0a,
	0x14, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x22, 0x6c, 0x0a, 0x07, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12,
	0x56, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x65,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x22, 0x65, 0x0a, 0x0e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x22, 0x61, 0x0a, 0x0d, 0x54, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x0d, 0x0a,
	0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22, 0xaa, 0x01, 0x0a,
	0x0e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x73, 0x74, 0x65, 0x70, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x70, 0x6f, 0x63,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x70,
	0x6f, 0x63, 0x68, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x6c, 0x6f, 0x73, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x61,
	0x6e, 0x4c, 0x6f, 0x73, 0x73, 0x12, 0x42, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x9b, 0x01, 0x0a, 0x27, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0f, 0x54, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69,
	0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x70, 0x62, 0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescOnce sync.Once
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescData = file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDesc
)

func file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescGZIP() []byte {
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescOnce.Do(func() {
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescData)
	})
	return file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDescData
}

var file_google_ai_generativelanguage_v1beta_tuned_model_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_ai_generativelanguage_v1beta_tuned_model_proto_goTypes = []interface{}{
	(TunedModel_State)(0),         // 0: google.ai.generativelanguage.v1beta.TunedModel.State
	(*TunedModel)(nil),            // 1: google.ai.generativelanguage.v1beta.TunedModel
	(*TunedModelSource)(nil),      // 2: google.ai.generativelanguage.v1beta.TunedModelSource
	(*TuningTask)(nil),            // 3: google.ai.generativelanguage.v1beta.TuningTask
	(*Hyperparameters)(nil),       // 4: google.ai.generativelanguage.v1beta.Hyperparameters
	(*Dataset)(nil),               // 5: google.ai.generativelanguage.v1beta.Dataset
	(*TuningExamples)(nil),        // 6: google.ai.generativelanguage.v1beta.TuningExamples
	(*TuningExample)(nil),         // 7: google.ai.generativelanguage.v1beta.TuningExample
	(*TuningSnapshot)(nil),        // 8: google.ai.generativelanguage.v1beta.TuningSnapshot
	(*timestamppb.Timestamp)(nil), // 9: google.protobuf.Timestamp
}
var file_google_ai_generativelanguage_v1beta_tuned_model_proto_depIdxs = []int32{
	2,  // 0: google.ai.generativelanguage.v1beta.TunedModel.tuned_model_source:type_name -> google.ai.generativelanguage.v1beta.TunedModelSource
	0,  // 1: google.ai.generativelanguage.v1beta.TunedModel.state:type_name -> google.ai.generativelanguage.v1beta.TunedModel.State
	9,  // 2: google.ai.generativelanguage.v1beta.TunedModel.create_time:type_name -> google.protobuf.Timestamp
	9,  // 3: google.ai.generativelanguage.v1beta.TunedModel.update_time:type_name -> google.protobuf.Timestamp
	3,  // 4: google.ai.generativelanguage.v1beta.TunedModel.tuning_task:type_name -> google.ai.generativelanguage.v1beta.TuningTask
	9,  // 5: google.ai.generativelanguage.v1beta.TuningTask.start_time:type_name -> google.protobuf.Timestamp
	9,  // 6: google.ai.generativelanguage.v1beta.TuningTask.complete_time:type_name -> google.protobuf.Timestamp
	8,  // 7: google.ai.generativelanguage.v1beta.TuningTask.snapshots:type_name -> google.ai.generativelanguage.v1beta.TuningSnapshot
	5,  // 8: google.ai.generativelanguage.v1beta.TuningTask.training_data:type_name -> google.ai.generativelanguage.v1beta.Dataset
	4,  // 9: google.ai.generativelanguage.v1beta.TuningTask.hyperparameters:type_name -> google.ai.generativelanguage.v1beta.Hyperparameters
	6,  // 10: google.ai.generativelanguage.v1beta.Dataset.examples:type_name -> google.ai.generativelanguage.v1beta.TuningExamples
	7,  // 11: google.ai.generativelanguage.v1beta.TuningExamples.examples:type_name -> google.ai.generativelanguage.v1beta.TuningExample
	9,  // 12: google.ai.generativelanguage.v1beta.TuningSnapshot.compute_time:type_name -> google.protobuf.Timestamp
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_ai_generativelanguage_v1beta_tuned_model_proto_init() }
func file_google_ai_generativelanguage_v1beta_tuned_model_proto_init() {
	if File_google_ai_generativelanguage_v1beta_tuned_model_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TunedModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TunedModelSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TuningTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Hyperparameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TuningExamples); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TuningExample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TuningSnapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*TunedModel_TunedModelSource)(nil),
		(*TunedModel_BaseModel)(nil),
	}
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Hyperparameters_LearningRate)(nil),
		(*Hyperparameters_LearningRateMultiplier)(nil),
	}
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Dataset_Examples)(nil),
	}
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*TuningExample_TextInput)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ai_generativelanguage_v1beta_tuned_model_proto_goTypes,
		DependencyIndexes: file_google_ai_generativelanguage_v1beta_tuned_model_proto_depIdxs,
		EnumInfos:         file_google_ai_generativelanguage_v1beta_tuned_model_proto_enumTypes,
		MessageInfos:      file_google_ai_generativelanguage_v1beta_tuned_model_proto_msgTypes,
	}.Build()
	File_google_ai_generativelanguage_v1beta_tuned_model_proto = out.File
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_rawDesc = nil
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_goTypes = nil
	file_google_ai_generativelanguage_v1beta_tuned_model_proto_depIdxs = nil
}
