;; Scheduling description for IBM PowerPC 476 processor.
;; Copyright (C) 2009-2022 Free Software Foundation, Inc.
;; Contributed by Peter Bergner (bergner@vnet.ibm.com).
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

;; PPC476 Embedded PowerPC controller
;; 3 issue (476) / 4 issue (476fp)
;;
;; i_pipe  - complex integer / compare
;; lj_pipe - load-store / simple integer arithmetic
;; b_pipe  - branch pipe
;; f_pipe  - floating point arithmetic

(define_automaton "ppc476_core,ppc476_apu")

(define_cpu_unit "ppc476_i_pipe,ppc476_lj_pipe,ppc476_b_pipe" "ppc476_core")
(define_cpu_unit "ppc476_issue_fp,ppc476_f_pipe" "ppc476_apu")
(define_cpu_unit "ppc476_issue_0,ppc476_issue_1,ppc476_issue_2" "ppc476_core")

(define_reservation "ppc476_issue" "ppc476_issue_0|ppc476_issue_1|ppc476_issue_2")
(define_reservation "ppc476_issue2" "ppc476_issue_0+ppc476_issue_1\
				    |ppc476_issue_0+ppc476_issue_2\
				    |ppc476_issue_1+ppc476_issue_2")
(define_reservation "ppc476_issue3" "ppc476_issue_0+ppc476_issue_1+ppc476_issue_2")

(define_insn_reservation "ppc476-load" 4
  (and (eq_attr "type" "load,load_l,store_c,sync")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_lj_pipe")

(define_insn_reservation "ppc476-store" 4
  (and (eq_attr "type" "store")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_lj_pipe")

(define_insn_reservation "ppc476-fpload" 4
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_lj_pipe")

(define_insn_reservation "ppc476-fpstore" 4
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_lj_pipe")

(define_insn_reservation "ppc476-simple-integer" 1
  (and (ior (eq_attr "type" "integer,insert")
	    (and (eq_attr "type" "add,logical,shift,exts")
		 (eq_attr "dot" "no")))
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_i_pipe|ppc476_lj_pipe")

(define_insn_reservation "ppc476-complex-integer" 1
  (and (eq_attr "type" "cmp,cr_logical,cntlz,isel,isync,sync,trap,popcnt")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_i_pipe")

(define_insn_reservation "ppc476-compare" 4
  (and (ior (eq_attr "type" "mfcr,mfcrf,mtcr,mfjmpr,mtjmpr")
	    (and (eq_attr "type" "add,logical,shift,exts")
		 (eq_attr "dot" "yes")))
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_i_pipe")

(define_insn_reservation "ppc476-imul" 4
  (and (eq_attr "type" "mul,halfmul")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_i_pipe")

(define_insn_reservation "ppc476-idiv" 11
  (and (eq_attr "type" "div")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_i_pipe*11")

(define_insn_reservation "ppc476-branch" 1
  (and (eq_attr "type" "branch,jmpreg")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue,\
   ppc476_b_pipe")

(define_insn_reservation "ppc476-two" 2
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue2,\
   ppc476_i_pipe|ppc476_lj_pipe,\
   ppc476_i_pipe|ppc476_lj_pipe")

(define_insn_reservation "ppc476-three" 3
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue3,\
   ppc476_i_pipe|ppc476_lj_pipe,\
   ppc476_i_pipe|ppc476_lj_pipe,\
   ppc476_i_pipe|ppc476_lj_pipe")

(define_insn_reservation "ppc476-fpcompare" 6
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue+ppc476_issue_fp,\
   ppc476_f_pipe+ppc476_i_pipe")

(define_insn_reservation "ppc476-fp" 6
  (and (eq_attr "type" "fp,fpsimple,dmul")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue_fp,\
   ppc476_f_pipe")

(define_insn_reservation "ppc476-sdiv" 19
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue_fp,
   ppc476_f_pipe*19")

(define_insn_reservation "ppc476-ddiv" 33
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc476"))
  "ppc476_issue_fp,\
   ppc476_f_pipe*33")

