"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Divider = exports.DividerVariant = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_styles_1 = require("@patternfly/react-styles");
const divider_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Divider/divider"));
const util_1 = require("../../helpers/util");
var DividerVariant;
(function (DividerVariant) {
    DividerVariant["hr"] = "hr";
    DividerVariant["li"] = "li";
    DividerVariant["div"] = "div";
})(DividerVariant || (exports.DividerVariant = DividerVariant = {}));
const Divider = (_a) => {
    var { className, component = DividerVariant.hr, inset, orientation, role = 'separator' } = _a, props = tslib_1.__rest(_a, ["className", "component", "inset", "orientation", "role"]);
    const Component = component;
    return ((0, jsx_runtime_1.jsx)(Component, Object.assign({ className: (0, react_styles_1.css)(divider_1.default.divider, (0, util_1.formatBreakpointMods)(inset, divider_1.default), (0, util_1.formatBreakpointMods)(orientation, divider_1.default), className) }, (component !== 'hr' && { role }), props)));
};
exports.Divider = Divider;
exports.Divider.displayName = 'Divider';
//# sourceMappingURL=Divider.js.map