/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 11:51:53 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.variant.BCFReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class BCFReader_ESTest extends BCFReader_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("http:uft'");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Could not find: 
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(".bci");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "http##fileformat=VCFv4.0\n");
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Premature end of file: data stream
         //
         verifyException("htsjdk.samtools.util.BlockCompressedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(".bci");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "");
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.NativeMockedIO", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("{");
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // File does not exist, and RandomAccessFile is not open in write mode
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockRandomAccessFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("http ");
        fail("Expecting exception: MalformedURLException");
      
      } catch(Throwable e) {
         //
         // no protocol: http 
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("ftp");
        fail("Expecting exception: MalformedURLException");
      
      } catch(Throwable e) {
         //
         // no protocol: ftp
         //
         verifyException("java.net.URL", e);
      }
  }
}
