Afrikaans and Dutch (`apertium-afr-nld`)
===============================================================================

This is an Apertium language pair for translating between Afrikaans and 
Dutch. What you can use this language package for:

* Translating between Afrikaans and Dutch
* Morphological analysis of Afrikaans and Dutch
* Part-of-speech tagging of Afrikaans and Dutch

For information on the latter two points, see subheading "For more 
information" below

Requirements
===============================================================================

You will need the following software installed:

* lttoolbox (>= 3.2.0)
* apertium (>= 3.2.0)

If this does not make any sense, we recommend you look at: www.apertium.org

Compiling
===============================================================================

Given the requirements being installed, you should be able to just run:
```
$ ./configure 
$ make
```
You can use `./autogen.sh` instead of `./configure` you're compiling from
git. If you're using a `--prefix` to `./configure`, make sure it's the
same one you used to install apertium itself.

Testing
===============================================================================

If you are in the source directory after running `make`, the following
commands should work:
```
$ echo "Hy kan nie kom nie want hy is siek." | apertium -d . afr-nld
Hij kan niet komen want hij is ziek.
```
After installing somewhere in $PATH, you should be able to do eg.
```
$ echo "Hy kan nie kom nie want hy is siek." | apertium  afr-nld
Hij kan niet komen want hij is ziek.
```
The following command runs tests which are on the Apertium wiki page:
```
$ ./regression-tests.sh 
```
Files and data
===============================================================================

* `apertium-af-nl.af.dix`            - Monolingual dictionary for Afrikaans
* `apertium-af-nl.af-nl.dix`         - Bilingual dictionary 
* `apertium-af-nl.nl.dix`            - Monolingual dictionary for Dutch
* `apertium-af-nl.af-nl.t1x`         - Chunker rules for translating into Dutch
* `apertium-af-nl.af-nl.t2x`         - Interchunk rules for translating into Dutch
* `apertium-af-nl.af-nl.t3x`         - Postchunk rules for translating into Dutch
* `apertium-nl-af.nl-af.t1x`         - Chunker rules for translating into Afrikaans
* `apertium-nl-af.nl-af.t2x`         - Interchunk rules for translating into Afrikaans
* `apertium-nl-af.nl-af.t3x`         - Postchunk rules for translating into Afrikaans
* `af-nl.prob`                       - Tagger model for Afrikaans
* `nl-af.prob`                       - Tagger model for Dutch 
* `modes.xml`                        - Translation modes

For more information
===============================================================================

* http://wiki.apertium.org/wiki/Installation
* http://wiki.apertium.org/wiki/apertium-af-nl
* http://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary

Help and support
===============================================================================

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: `#apertium` on `irc.freenode.net`

See also the file AUTHORS included in this distribution.
